//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#include "Random.h"

using namespace tlp;

DOUBLEPLUGINOFGROUP(RandomMetric,"Random","David Auber","04/10/2001","Alpha","1.0","Misc")

//===========================================
RandomMetric::RandomMetric(const PropertyContext &context):DoubleAlgorithm(context) 
{}
//===========================================
bool RandomMetric::run() {
  node n;
  forEach(n, graph->getNodes())
    doubleResult->setNodeValue(n, (double)rand() / double(RAND_MAX));
  edge e;
  forEach(e, graph->getEdges())
    doubleResult->setEdgeValue(e, (double)rand() / double(RAND_MAX));
  return true;
}
//===========================================
