/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

//----------------------------------------------------------------------------
//
//  File:       UNSSoapServer.h
//
//----------------------------------------------------------------------------
#ifndef UNS_SOAP_SERVER_H
#define UNS_SOAP_SERVER_H

#include "soapH.h"
#include <map>
#include "UNSEventLogger.h"
#include "UNSStatus.h"


#define BACKLOG				(100)	// Max. request backlog
#define UNS_SERVER_TIMEOUT	4		// Timout for accept.

//static char UNS_AUTH_REALM[] = "Intel AMT UNS";

using namespace std;

typedef struct _EventType {
	unsigned short	category;
	unsigned long	id;
} EventType;

// Event constant fields
#define UNS_EVENT_SENSOR_TYPE	0xc0
#define UNS_EVENT_TYPE			0x70
#define UNS_EVENT_OFFSET		0x00
#define UNS_EVENT_SOURCE_TYPE	0x58
#define UNS_EVENT_SEVERITY		0x02
#define UNS_EVENT_SENSOR_NUMBER	0xff
#define UNS_EVENT_ENTITY		0x26

// Map from the first two data bytes => to EventType
// The key format is: | X X X X 0 0 0 0 | X X X X X X X X |
//                    +-----------------+-----------------+
//                    |EventData byte 0 |EventData byte 1 |
//                    +-----------------+-----------------+
//					  |Category         |Event ID         |
//
static const unsigned char UNS_REASON_GENERAL			= 0x00;
static const unsigned char UNS_REASON_CIRCUIT_BREAKER	= 0x10;
static const unsigned char UNS_REASON_EAC				= 0x20;
static const unsigned char UNS_REASON_REMOTE_DIAGNOSTIC	= 0x30;
static const unsigned char UNS_REASON_WLAN				= 0x40;


static const unsigned char UNS_CODE_NETWORK_TRAFFIC_TX_CEASED		= 0x00;
static const unsigned char UNS_CODE_NETWORK_CONNECTIVITY_TX_REDUCED	= 0x01;
static const unsigned char UNS_CODE_NETWORK_TRAFFIC_RX_CEASED		= 0x02;
static const unsigned char UNS_CODE_NETWORK_CONNECTIVITY_RX_REDUCED	= 0x03;
static const unsigned char UNS_CODE_REMOTE_SOL_STARTED				= 0x00;
static const unsigned char UNS_CODE_REMOTE_SOL_ENDED				= 0x01;
static const unsigned char UNS_CODE_REMOTE_IDER_STARTED				= 0x02;
static const unsigned char UNS_CODE_REMOTE_IDER_ENDED				= 0x03;
static const unsigned char UNS_CODE_WLAN_PROFILE_INSUFFICIENT		= 0x02;
static const unsigned char UNS_CODE_WLAN_SESSION_ESTABLISHED		= 0x03;
static const unsigned char UNS_CODE_WLAN_SECURITY_INSUFFICIENT		= 0x04;
static const unsigned char UNS_CODE_WLAN_SESSION_ENDED				= 0x05;

class UNSSoapServer
{
public:
	UNSSoapServer			();	// Ctor.
	virtual ~UNSSoapServer	();	// Dtor.

	void		SetLogger		(	UNSEventLogger *logger);// Set a pointer to a logger class.
	void		SetCredentials	(	const string userid,
									const string passwd);	// Set userid and passwd
	UNS_STATUS	Bind			(	const char *host);		// Bind host.
	void		RunServer		(	);						// Listen on socket for one time.

	int			GetPort			();	// Get this server port
	bool		IsInit			();	// Return true iff server is initialized (bind)
	SOAP_SOCKET	GetMasterSocket	();	// Get this server master socket.

	// Handle pet alerts.

	static bool HandlePetAlert	(_emc__SoapAlertRequest *request);
private:
	static void printEvent	(emi__EventLogRecordType * event);
	static bool IsEventLegal	(emi__EventLogRecordType * event);
	static bool GetEventType	(vector<unsigned char> &data, EventType &event);

	// Data members
	struct soap			*m_soap;	// Pointer to soap runtime environment
	SOAP_SOCKET			 m_socket;	// Master socket.
	unsigned short		 m_port;	// Port of the service.
	bool				 m_init;	// Flag - is initialized.

public:
	// public static data members.
	static UNSEventLogger	*m_Logger;	// Event Logger.
	static string			m_userid;	// User id for basic authentication.
	static string			m_passwd;	// Password for basic authentication.

};
#endif //UNS_SOAP_SERVER_H
