/********************************************************************

    File:       common.h

    Purpose:    Utility functions for upsd.

                Copyright 1996, Bob Hauck
                Copyright 1998, Michael Robinton
                
                This program is free software; you can redistribute it
                and/or modify it under the terms of the GNU General Public
                License as published by the Free Software Foundation;
                either version 2 of the License, or (at your option) any
                later version.

                This program is distributed in the hope that it will be
                useful, but WITHOUT ANY WARRANTY; without even the implied
                warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
                PURPOSE.  See the GNU General Public License for more details.

                You should have received a copy of the GNU General Public
                License along with this program; if not, write to the Free
                Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
                USA.

    Language:   GCC 2.7.0

    Author:     Bob Hauck
    Modified:   Michael Robinton

    Revision 1.4  1998/05/23 15:21:00  miker
    Rename Status to NetStatus to reflect usage.
    
    Revision 1.3  1997/02/07 00:05:27  bobh
    Remove PWRSTAT define...moved to Makefile.

    Revision 1.2  1997/01/20 22:43:04  bobh
    Add "const" to LogError params.

    Revision 1.1  1996/11/23 16:45:12  bobh
    Initial revision

**********************************************************************/
#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE !FALSE
#endif

extern char *ProgName;   /*  Program name  */
extern int   NetStatus;  /*  Network Status (S_* codes)  */
extern int   IsDaemon;   /*  0 = not daemon, 1 = daemon, 2 = daemon with
                          *  log file open. */


/*-------------------------------------------------------------------*
     LogError

     Log error messages to stderr or to syslog, depending on whether
     we are running as a daemon.

     Parameters:  Module - Module that is reporting the error.
                  Error  - Error message

     Returns:     Nothing.
 *-------------------------------------------------------------------*/
void LogError (const char *ModName, const char *Error);


/*-------------------------------------------------------------------*
     Usage

     Print help & usage information.

     Parameters:  None

     Returns:     Nothing.
 *-------------------------------------------------------------------*/
void Usage (void);
