-- UUAGC 0.9.5 (DefaultRules.ag)
module DefaultRules where

import qualified List (delete,intersperse)

import qualified Data.Set as Set
import qualified Data.Map as Map
import Data.Map(Map)
import qualified UU.DData.Seq as Seq
import UU.DData.Seq(Seq,(<>))
import UU.Scanner.Position(noPos)
import Pretty
import Maybe

import AbstractSyntax
import ErrorMessages

import Options(Options,modcopy,rename)

-- AbstractSyntax.ag imports
import Data.Set(Set)
import Data.Map(Map)
import Patterns    (Pattern(..),Patterns)
import Expression  (Expression(..))
import CommonTypes

-- Patterns.ag imports
import UU.Scanner.Position(Pos)
import CommonTypes (Constructor,Name)

fieldName n       = '@' : getName n
	
locName n         = '@' : getName n

attrName fld attr
 | fld == _LOC    = '@' :                       getName attr 
 | otherwise      = '@' : getName fld ++ "." ++ getName attr

_ACHILD = Ident "(" noPos -- hack
	
	
getConName typeSyns rename nt con1 
 | nt `elem` map fst typeSyns  =  synonym
 | otherwise                   =  normalName
 where con                            = getName con1
       normalName | rename            = getName nt++"_"++ con
                  | otherwise         =  con
       synonym    | con == "Cons"     = "(:)"
                  | con == "Nil"      = "[]"
                  | con == "Just"     = "Just"
                  | con == "Nothing"  = "Nothing"
                  | otherwise         = normalName



concatSeq = foldr Seq.append Seq.empty

splitAttrs :: Map Name a -> [Name] -> ([(Name,a)],[Name])	  -- a used as (String,String)
splitAttrs _      []           
  =  ([],[])
splitAttrs useMap (n:rest) 
  =  let (uses,normals) = splitAttrs useMap rest
     in case Map.lookup n useMap of
          Just x  -> ((n,x):uses ,   normals )       
          Nothing -> (      uses , n:normals )

removeDefined ::  Set (Name,Name) -> (Name,Attributes) -> (Name,[Name])
removeDefined defined (fld,as) 
  = ( fld
    , [ a 
      | a <- Map.keys as
      , not (Set.member (fld,a) defined) 
      ]
    )


	
	
	
deprecatedCopyRuleError nt con fld a
 = let mesg = 
                "In the definitions for alternative" 
            >#< getName con 
            >#< "of nonterminal" 
            >#< getName nt 
            >|< "," 
            >-< "the value of field" 
            >#< getName a  
            >#< "is copied by a copy-rule."                                    
            >-< "Copying the value of a field using a copy-rule is deprecated"
            >-< "Please add the following lines to your code:"
            >-< (    "SEM" 
                >#< getName nt
                >-< indent 2 (      "|" 
                             >#< getName con 
                             >#< getName fld 
                             >#< "." 
                             >#< a 
                             >#< "=" 
                             >#< "@" 
                             >|< a
                             )
                )  
    in  CustomError True (getPos a) mesg
	
	
missingRuleErrorExpr nt con fld a
 = "error \"missing rule: " 
   ++ show nt  ++ "." ++ show con ++ "." 
   ++ show fld ++ "." ++ show a   ++ "\""
	
	
	
makeRule :: (Name,Name) -> Expression -> String -> Rule
makeRule (f1,a1) expr origin 
 = Rule (Alias f1 a1 (Underscore noPos) []) 
        expr 
        False 
        origin


useRule :: Set Name -> [(Name,Attributes)] -> (Name,(String,String,String)) -> Rule
useRule locals ch_outs (n,(op,e,pos)) 
 =  let elems = [ fld 
                | (fld,as) <- ch_outs
                , Map.member n as
                ]
                
        expr | Set.member n locals  =  attrName _LOC n
             | null elems           =  e
             | otherwise            =  foldr1 (\x y -> x ++ " " ++ op ++ " " ++ y) 
                                              (map (flip attrName n) elems)
             
    in makeRule (_LHS,n) 
                (Expression noPos expr) 
                ("use rule " ++ pos)




selfRule lhsNecLoc attr x   
 = let expr | lhsNecLoc  = locName attr
            | otherwise  = x
     
   in makeRule (if lhsNecLoc then _LHS else _LOC,attr)
               (Expression noPos expr)
               "self rule"
               



concatRE rsess = let (rss,ess) = unzip rsess
                 in (concat rss, concatSeq ess)


copyRule :: Name -> Name -> Bool -> Set Name -> (Map Name Name, (Name,[Name])) -> ([Rule], Seq Error)
copyRule nt con modcopy locals (env,(fld,as)) 
 = concatRE (map copyRu as)
 
 where 
       copyRu a
           = ( [ makeRule (fld,a) 
                          (Expression noPos expr)
                          (cruletxt sel)
               ]
             , err
             )
                
        where 
              sel 
               |    not modcopy 
                 && Set.member a locals  =  Just _LOC
               | otherwise               =  Map.lookup a env

              (expr,err) 
               = case sel of
                  Nothing         -> ( missingRuleErrorExpr nt con fld a
                                     , Seq.single (MissingRule nt con fld a)
                                     )
                  Just f 
                   | f == _ACHILD -> ( fieldName a
                                     , Seq.single (deprecatedCopyRuleError nt con fld a)
                                     )
                   | otherwise    -> ( attrName f a
                                     , Seq.empty
                                     )
                                            
              cruletxt sel 
               | local                            = "copy rule (from local)"
               | deprChild                        = "deprecated child copy"
               | Set.member a locals && nonlocal  = "modified copy rule"
               | incoming && outgoing             = "copy rule (chain)"
               | incoming                         = "copy rule (down)"
               | outgoing                         = "copy rule (up)"
               | otherwise                        = "copy rule (chain)"
                where outgoing  =  fld == _LHS
                      incoming  =  maybe False (== _LHS)    sel
                      nonlocal  =  maybe False (/= _LOC)    sel
                      local     =  maybe False (== _LOC)    sel
                      deprChild =  maybe False (== _ACHILD) sel

{- 
multiRule replaces
  loc.(a,b) = e
by  
  loc.tup1  = e
  loc.(a,_) = @loc.tup1
  loc.(_,b) = @loc.tup1
It needs to thread a unique number for inventing names for the tuples.

It also works for nested tuples:
  loc.(a,(b,c)) = e
becomes
  loc.tup1      = e
  loc.(a,_)     = @loc.tup1
  loc.(_,tup2)  = @loc.tup1
  loc.(b,_)     = @loc.tup2
  loc.(_,c)     = @loc.tup2
-}

multiRule :: Rule -> Int -> ([Rule], Int)	
multiRule (Rule pat expr owrt origin) uniq
  =  let f :: (Pattern->Pattern) -> Expression -> Pattern -> Int -> (Pattern, ([Rule], Int))
         f w e (Product pos pats) n 
           = let freshName = Ident ("_tup" ++ show n) pos 
                 freshExpr = Expression pos (attrName _LOC freshName)
                 freshPat  = Alias _LOC freshName (Underscore pos) pats
                 a = length pats - 1
                 us b p = Product pos (replicate (a-b) (Underscore pos) ++ [p] ++ replicate b (Underscore pos))
                 g :: Pattern -> ([Pattern],[Rule],Int) -> ([Pattern],[Rule],Int)
                 g p (xs1,rs1,n1)   = let (x2,(rs2,n2)) = f (us (length xs1)) freshExpr p n1
                                      in  (x2:xs1, rs2++rs1, n2)
                 (xs9,rs9,n9) = foldr g ([], [], n+1) pats
             in  ( freshPat
                 , ( Rule (w freshPat) e owrt origin : rs9
                   , n9
                   )
                 )
         f w e p n 
           = ( p
             , ( [Rule (w p) e owrt origin]
               , n
               )
             )
     in snd (f id expr pat uniq)


isDefined :: Map Name Attributes -> Identifier -> Identifier -> Bool
isDefined mp fld nm
  = Map.member nm $ Map.findWithDefault Map.empty fld mp

-- check that for a dependency a < b, that a is an In attribute
isInAttribute :: [(Name,Attributes)] -> Identifier -> Identifier -> Bool
isInAttribute allSyns fld nm
  | fld == _INST || fld == _LOC || fld == _LHS
      = True
  | otherwise  -- is nm it a synthesized attribute of fld?
      = maybe False (Map.member nm) (lookup fld allSyns)
-- Alternative -------------------------------------------------
{-
   visit 0:
      inherited attributes:
         cr                   : Bool
         inh                  : Attributes
         manualAttrOrderMap   : AttrOrderMap
         nonterminals         : Set Nonterminal
         nt                   : Nonterminal
         o_rename             : Bool
         syn                  : Attributes
         typeSyns             : TypeSyns
         useMap               : Map Name (String,String,String)
      chained attribute:
         uniq                 : Int
      synthesized attributes:
         errors               : Seq Error
         output               : SELF
   alternatives:
      alternative Alternative:
         child con            : {Constructor}
         child children       : Children
         child rules          : Rules
         child typeSigs       : TypeSigs
         visit 0:
            local _tup1       : _
            local newRls      : _
            local errs        : _
            local orderDeps   : _
            local allAttrsInScope : _
            local invalidOrderDepsErrors : _
            local undefinedAttributeInDepsErrors : _
            local orderErrs   : _
            local output      : _
-}
-- cata
sem_Alternative :: Alternative ->
                   T_Alternative
sem_Alternative (Alternative _con _children _rules _typeSigs) =
    (sem_Alternative_Alternative _con (sem_Children _children) (sem_Rules _rules) (sem_TypeSigs _typeSigs))
-- semantic domain
newtype T_Alternative = T_Alternative (Bool ->
                                       Attributes ->
                                       AttrOrderMap ->
                                       (Set Nonterminal) ->
                                       Nonterminal ->
                                       Bool ->
                                       Attributes ->
                                       TypeSyns ->
                                       Int ->
                                       (Map Name (String,String,String)) ->
                                       ( (Seq Error),Alternative,Int))
data Inh_Alternative = Inh_Alternative {cr_Inh_Alternative :: Bool,inh_Inh_Alternative :: Attributes,manualAttrOrderMap_Inh_Alternative :: AttrOrderMap,nonterminals_Inh_Alternative :: Set Nonterminal,nt_Inh_Alternative :: Nonterminal,o_rename_Inh_Alternative :: Bool,syn_Inh_Alternative :: Attributes,typeSyns_Inh_Alternative :: TypeSyns,uniq_Inh_Alternative :: Int,useMap_Inh_Alternative :: Map Name (String,String,String)}
data Syn_Alternative = Syn_Alternative {errors_Syn_Alternative :: Seq Error,output_Syn_Alternative :: Alternative,uniq_Syn_Alternative :: Int}
wrap_Alternative (T_Alternative sem) (Inh_Alternative _lhsIcr _lhsIinh _lhsImanualAttrOrderMap _lhsInonterminals _lhsInt _lhsIo_rename _lhsIsyn _lhsItypeSyns _lhsIuniq _lhsIuseMap) =
    (let ( _lhsOerrors,_lhsOoutput,_lhsOuniq) =
             (sem _lhsIcr _lhsIinh _lhsImanualAttrOrderMap _lhsInonterminals _lhsInt _lhsIo_rename _lhsIsyn _lhsItypeSyns _lhsIuniq _lhsIuseMap)
     in  (Syn_Alternative _lhsOerrors _lhsOoutput _lhsOuniq))
sem_Alternative_Alternative :: Constructor ->
                               T_Children ->
                               T_Rules ->
                               T_TypeSigs ->
                               T_Alternative
sem_Alternative_Alternative con_ (T_Children children_) (T_Rules rules_) (T_TypeSigs typeSigs_) =
    (T_Alternative (\ _lhsIcr
                      _lhsIinh
                      _lhsImanualAttrOrderMap
                      _lhsInonterminals
                      _lhsInt
                      _lhsIo_rename
                      _lhsIsyn
                      _lhsItypeSyns
                      _lhsIuniq
                      _lhsIuseMap ->
                        (let _rulesOcon :: Constructor
                             _childrenOcon :: Constructor
                             _lhsOerrors :: (Seq Error)
                             _lhsOoutput :: Alternative
                             _lhsOuniq :: Int
                             _childrenOcr :: Bool
                             _childrenOnt :: Nonterminal
                             _rulesOnt :: Nonterminal
                             _rulesOuniq :: Int
                             _childrenIerrors :: (Seq Error)
                             _childrenIfields :: ([(Name,Type,Bool)])
                             _childrenIinputs :: ([(Name, Attributes)])
                             _childrenIoutput :: Children
                             _childrenIoutputs :: ([(Name, Attributes)])
                             _rulesIdefinedAttrs :: (Set (Name,Name))
                             _rulesIerrors :: (Seq Error)
                             _rulesIlocals :: (Set Name)
                             _rulesIoutput :: Rules
                             _rulesIuniq :: Int
                             _typeSigsIoutput :: TypeSigs
                             -- "DefaultRules.ag"(line 135, column 17)
                             _rulesOcon =
                                 con_
                             -- "DefaultRules.ag"(line 136, column 17)
                             _childrenOcon =
                                 con_
                             -- "DefaultRules.ag"(line 295, column 4)
                             _lhsOerrors =
                                 _childrenIerrors <> _errs <> _rulesIerrors <> _orderErrs
                             -- "DefaultRules.ag"(line 297, column 8)
                             __tup1 =
                                 let locals       = _rulesIlocals
                                     initenv      = Map.fromList (  [ (a,_ACHILD)
                                                                    | (a,_,_) <- _childrenIfields
                                                                    ]
                                                                 ++ attrs(_LHS, _lhsIinh)
                                                                 ++ [ (a,_LOC)
                                                                    |  a <- Set.toList locals
                                                                    ]
                                                                 )
                                     attrs (n,as) = [ (a,n) | a <- Map.keys as ]
                                     envs       = scanl (flip Map.union)
                                                        initenv
                                                        (map (Map.fromList . attrs ) _childrenIoutputs)
                                     child_envs = init envs
                                     lhs_env    = last envs
                                     (selfAttrs, normalAttrs)
                                       = Map.partition (==NT _SELF) _lhsIsyn
                                     (_,undefAttrs)
                                       = removeDefined _rulesIdefinedAttrs (_LHS, normalAttrs)
                                     (useAttrs,others)
                                       = splitAttrs _lhsIuseMap undefAttrs
                                     (rules1, errors1)
                                       = concatRE $ map (copyRule _lhsInt con_ _lhsIcr locals)
                                                        (zip envs (map (removeDefined _rulesIdefinedAttrs) _childrenIinputs))
                                     uRules
                                       = map (useRule locals _childrenIoutputs) useAttrs
                                     selfLocRules
                                       =  [ selfRule False attr (constructor [childSelf attr nm tp | (nm,tp,ho) <- _childrenIfields, not ho])
                                          | attr <- Map.keys selfAttrs
                                          , not (Set.member attr locals)
                                          ]
                                          where
                                            childSelf self nm tp
                                              = case tp of NT nt                           -> attrName nm self
                                                           _      | nm `Set.member` locals -> locname nm
                                                                  | otherwise              -> fieldName nm
                                            constructor fs
                                             | getName con_ == "Tuple" && _lhsInt `elem` map fst _lhsItypeSyns
                                               = "(" ++ concat (List.intersperse "," fs) ++ ")"
                                             | otherwise
                                               = getConName _lhsItypeSyns _lhsIo_rename _lhsInt con_ ++ " " ++ unwords fs
                                     selfRules
                                       = [ selfRule True attr undefined
                                         | attr <- Map.keys selfAttrs
                                         , not (Set.member (_LHS,attr) _rulesIdefinedAttrs)
                                         ]
                                     (rules5, errs5)
                                       = copyRule _lhsInt
                                                  con_
                                                  _lhsIcr
                                                  locals
                                                  (lhs_env, (_LHS, others))
                                 in (uRules++selfLocRules++selfRules++rules5++rules1, errors1<>errs5)
                             -- "DefaultRules.ag"(line 297, column 8)
                             (_newRls,_) =
                                 __tup1
                             -- "DefaultRules.ag"(line 297, column 8)
                             (_,_errs) =
                                 __tup1
                             -- "DefaultRules.ag"(line 413, column 17)
                             _lhsOoutput =
                                 Alternative con_ _childrenIoutput (_rulesIoutput ++ _newRls) _typeSigsIoutput
                             -- "DefaultRules.ag"(line 484, column 7)
                             _orderDeps =
                                 Set.toList $ Map.findWithDefault Set.empty con_ $ Map.findWithDefault Map.empty _lhsInt _lhsImanualAttrOrderMap
                             -- "DefaultRules.ag"(line 486, column 7)
                             _allAttrsInScope =
                                 Map.fromList ( [ (_LHS, _lhsIsyn `Map.union` _lhsIinh)
                                                , (_LOC, Map.fromList [ (l,Haskell "LOC") | l <- Set.toList _rulesIlocals]) ]
                                              ++ _childrenIinputs
                                              ++ _childrenIoutputs
                                              )
                             -- "DefaultRules.ag"(line 493, column 7)
                             _invalidOrderDepsErrors =
                                 [ ErroneousOrder _lhsInt con_ dep
                                 | dep@(Dependency (fld,nm) _) <- _orderDeps
                                 , not $ isInAttribute _childrenIoutputs fld nm
                                 ]
                             -- "DefaultRules.ag"(line 499, column 7)
                             _undefinedAttributeInDepsErrors =
                                 [ UndefAttr _lhsInt con_ fld nm
                                 | (fld,nm) <- concatMap (\(Dependency a b) -> [a,b]) $ _orderDeps
                                 , not $ isDefined _allAttrsInScope     fld nm
                                 ]
                             -- "DefaultRules.ag"(line 505, column 7)
                             _orderErrs =
                                 if null _undefinedAttributeInDepsErrors
                                 then Seq.fromList _invalidOrderDepsErrors
                                 else Seq.fromList _undefinedAttributeInDepsErrors
                             -- self rule
                             _output =
                                 Alternative con_ _childrenIoutput _rulesIoutput _typeSigsIoutput
                             -- copy rule (up)
                             _lhsOuniq =
                                 _rulesIuniq
                             -- copy rule (down)
                             _childrenOcr =
                                 _lhsIcr
                             -- copy rule (down)
                             _childrenOnt =
                                 _lhsInt
                             -- copy rule (down)
                             _rulesOnt =
                                 _lhsInt
                             -- copy rule (down)
                             _rulesOuniq =
                                 _lhsIuniq
                             ( _childrenIerrors,_childrenIfields,_childrenIinputs,_childrenIoutput,_childrenIoutputs) =
                                 (children_ _childrenOcon _childrenOcr _childrenOnt)
                             ( _rulesIdefinedAttrs,_rulesIerrors,_rulesIlocals,_rulesIoutput,_rulesIuniq) =
                                 (rules_ _rulesOcon _rulesOnt _rulesOuniq)
                             ( _typeSigsIoutput) =
                                 (typeSigs_ )
                         in  ( _lhsOerrors,_lhsOoutput,_lhsOuniq))))
-- Alternatives ------------------------------------------------
{-
   visit 0:
      inherited attributes:
         cr                   : Bool
         inh                  : Attributes
         manualAttrOrderMap   : AttrOrderMap
         nonterminals         : Set Nonterminal
         nt                   : Nonterminal
         o_rename             : Bool
         syn                  : Attributes
         typeSyns             : TypeSyns
         useMap               : Map Name (String,String,String)
      chained attribute:
         uniq                 : Int
      synthesized attributes:
         errors               : Seq Error
         output               : SELF
   alternatives:
      alternative Cons:
         child hd             : Alternative
         child tl             : Alternatives
         visit 0:
            local output      : _
      alternative Nil:
         visit 0:
            local output      : _
-}
-- cata
sem_Alternatives :: Alternatives ->
                    T_Alternatives
sem_Alternatives list =
    (Prelude.foldr sem_Alternatives_Cons sem_Alternatives_Nil (Prelude.map sem_Alternative list))
-- semantic domain
newtype T_Alternatives = T_Alternatives (Bool ->
                                         Attributes ->
                                         AttrOrderMap ->
                                         (Set Nonterminal) ->
                                         Nonterminal ->
                                         Bool ->
                                         Attributes ->
                                         TypeSyns ->
                                         Int ->
                                         (Map Name (String,String,String)) ->
                                         ( (Seq Error),Alternatives,Int))
data Inh_Alternatives = Inh_Alternatives {cr_Inh_Alternatives :: Bool,inh_Inh_Alternatives :: Attributes,manualAttrOrderMap_Inh_Alternatives :: AttrOrderMap,nonterminals_Inh_Alternatives :: Set Nonterminal,nt_Inh_Alternatives :: Nonterminal,o_rename_Inh_Alternatives :: Bool,syn_Inh_Alternatives :: Attributes,typeSyns_Inh_Alternatives :: TypeSyns,uniq_Inh_Alternatives :: Int,useMap_Inh_Alternatives :: Map Name (String,String,String)}
data Syn_Alternatives = Syn_Alternatives {errors_Syn_Alternatives :: Seq Error,output_Syn_Alternatives :: Alternatives,uniq_Syn_Alternatives :: Int}
wrap_Alternatives (T_Alternatives sem) (Inh_Alternatives _lhsIcr _lhsIinh _lhsImanualAttrOrderMap _lhsInonterminals _lhsInt _lhsIo_rename _lhsIsyn _lhsItypeSyns _lhsIuniq _lhsIuseMap) =
    (let ( _lhsOerrors,_lhsOoutput,_lhsOuniq) =
             (sem _lhsIcr _lhsIinh _lhsImanualAttrOrderMap _lhsInonterminals _lhsInt _lhsIo_rename _lhsIsyn _lhsItypeSyns _lhsIuniq _lhsIuseMap)
     in  (Syn_Alternatives _lhsOerrors _lhsOoutput _lhsOuniq))
sem_Alternatives_Cons :: T_Alternative ->
                         T_Alternatives ->
                         T_Alternatives
sem_Alternatives_Cons (T_Alternative hd_) (T_Alternatives tl_) =
    (T_Alternatives (\ _lhsIcr
                       _lhsIinh
                       _lhsImanualAttrOrderMap
                       _lhsInonterminals
                       _lhsInt
                       _lhsIo_rename
                       _lhsIsyn
                       _lhsItypeSyns
                       _lhsIuniq
                       _lhsIuseMap ->
                         (let _lhsOerrors :: (Seq Error)
                              _lhsOoutput :: Alternatives
                              _lhsOuniq :: Int
                              _hdOcr :: Bool
                              _hdOinh :: Attributes
                              _hdOmanualAttrOrderMap :: AttrOrderMap
                              _hdOnonterminals :: (Set Nonterminal)
                              _hdOnt :: Nonterminal
                              _hdOo_rename :: Bool
                              _hdOsyn :: Attributes
                              _hdOtypeSyns :: TypeSyns
                              _hdOuniq :: Int
                              _hdOuseMap :: (Map Name (String,String,String))
                              _tlOcr :: Bool
                              _tlOinh :: Attributes
                              _tlOmanualAttrOrderMap :: AttrOrderMap
                              _tlOnonterminals :: (Set Nonterminal)
                              _tlOnt :: Nonterminal
                              _tlOo_rename :: Bool
                              _tlOsyn :: Attributes
                              _tlOtypeSyns :: TypeSyns
                              _tlOuniq :: Int
                              _tlOuseMap :: (Map Name (String,String,String))
                              _hdIerrors :: (Seq Error)
                              _hdIoutput :: Alternative
                              _hdIuniq :: Int
                              _tlIerrors :: (Seq Error)
                              _tlIoutput :: Alternatives
                              _tlIuniq :: Int
                              -- use rule "DefaultRules.ag"(line 107, column 19)
                              _lhsOerrors =
                                  _hdIerrors Seq.<> _tlIerrors
                              -- self rule
                              _output =
                                  (:) _hdIoutput _tlIoutput
                              -- self rule
                              _lhsOoutput =
                                  _output
                              -- copy rule (up)
                              _lhsOuniq =
                                  _tlIuniq
                              -- copy rule (down)
                              _hdOcr =
                                  _lhsIcr
                              -- copy rule (down)
                              _hdOinh =
                                  _lhsIinh
                              -- copy rule (down)
                              _hdOmanualAttrOrderMap =
                                  _lhsImanualAttrOrderMap
                              -- copy rule (down)
                              _hdOnonterminals =
                                  _lhsInonterminals
                              -- copy rule (down)
                              _hdOnt =
                                  _lhsInt
                              -- copy rule (down)
                              _hdOo_rename =
                                  _lhsIo_rename
                              -- copy rule (down)
                              _hdOsyn =
                                  _lhsIsyn
                              -- copy rule (down)
                              _hdOtypeSyns =
                                  _lhsItypeSyns
                              -- copy rule (down)
                              _hdOuniq =
                                  _lhsIuniq
                              -- copy rule (down)
                              _hdOuseMap =
                                  _lhsIuseMap
                              -- copy rule (down)
                              _tlOcr =
                                  _lhsIcr
                              -- copy rule (down)
                              _tlOinh =
                                  _lhsIinh
                              -- copy rule (down)
                              _tlOmanualAttrOrderMap =
                                  _lhsImanualAttrOrderMap
                              -- copy rule (down)
                              _tlOnonterminals =
                                  _lhsInonterminals
                              -- copy rule (down)
                              _tlOnt =
                                  _lhsInt
                              -- copy rule (down)
                              _tlOo_rename =
                                  _lhsIo_rename
                              -- copy rule (down)
                              _tlOsyn =
                                  _lhsIsyn
                              -- copy rule (down)
                              _tlOtypeSyns =
                                  _lhsItypeSyns
                              -- copy rule (chain)
                              _tlOuniq =
                                  _hdIuniq
                              -- copy rule (down)
                              _tlOuseMap =
                                  _lhsIuseMap
                              ( _hdIerrors,_hdIoutput,_hdIuniq) =
                                  (hd_ _hdOcr _hdOinh _hdOmanualAttrOrderMap _hdOnonterminals _hdOnt _hdOo_rename _hdOsyn _hdOtypeSyns _hdOuniq _hdOuseMap)
                              ( _tlIerrors,_tlIoutput,_tlIuniq) =
                                  (tl_ _tlOcr _tlOinh _tlOmanualAttrOrderMap _tlOnonterminals _tlOnt _tlOo_rename _tlOsyn _tlOtypeSyns _tlOuniq _tlOuseMap)
                          in  ( _lhsOerrors,_lhsOoutput,_lhsOuniq))))
sem_Alternatives_Nil :: T_Alternatives
sem_Alternatives_Nil  =
    (T_Alternatives (\ _lhsIcr
                       _lhsIinh
                       _lhsImanualAttrOrderMap
                       _lhsInonterminals
                       _lhsInt
                       _lhsIo_rename
                       _lhsIsyn
                       _lhsItypeSyns
                       _lhsIuniq
                       _lhsIuseMap ->
                         (let _lhsOerrors :: (Seq Error)
                              _lhsOoutput :: Alternatives
                              _lhsOuniq :: Int
                              -- use rule "DefaultRules.ag"(line 107, column 19)
                              _lhsOerrors =
                                  Seq.empty
                              -- self rule
                              _output =
                                  []
                              -- self rule
                              _lhsOoutput =
                                  _output
                              -- copy rule (chain)
                              _lhsOuniq =
                                  _lhsIuniq
                          in  ( _lhsOerrors,_lhsOoutput,_lhsOuniq))))
-- Child -------------------------------------------------------
{-
   visit 0:
      inherited attributes:
         con                  : Constructor
         cr                   : Bool
         nt                   : Nonterminal
      synthesized attributes:
         errors               : Seq Error
         field                :  (Name,Type,Bool) 
         inherited            : Attributes
         name                 : Name
         output               : SELF
         synthesized          : Attributes
   alternatives:
      alternative Child:
         child name           : {Name}
         child tp             : {Type}
         child inh            : {Attributes}
         child syn            : {Attributes}
         child higherOrder    : {Bool}
         visit 0:
            local output      : _
-}
-- cata
sem_Child :: Child ->
             T_Child
sem_Child (Child _name _tp _inh _syn _higherOrder) =
    (sem_Child_Child _name _tp _inh _syn _higherOrder)
-- semantic domain
newtype T_Child = T_Child (Constructor ->
                           Bool ->
                           Nonterminal ->
                           ( (Seq Error),( (Name,Type,Bool) ),Attributes,Name,Child,Attributes))
data Inh_Child = Inh_Child {con_Inh_Child :: Constructor,cr_Inh_Child :: Bool,nt_Inh_Child :: Nonterminal}
data Syn_Child = Syn_Child {errors_Syn_Child :: Seq Error,field_Syn_Child ::  (Name,Type,Bool) ,inherited_Syn_Child :: Attributes,name_Syn_Child :: Name,output_Syn_Child :: Child,synthesized_Syn_Child :: Attributes}
wrap_Child (T_Child sem) (Inh_Child _lhsIcon _lhsIcr _lhsInt) =
    (let ( _lhsOerrors,_lhsOfield,_lhsOinherited,_lhsOname,_lhsOoutput,_lhsOsynthesized) =
             (sem _lhsIcon _lhsIcr _lhsInt)
     in  (Syn_Child _lhsOerrors _lhsOfield _lhsOinherited _lhsOname _lhsOoutput _lhsOsynthesized))
sem_Child_Child :: Name ->
                   Type ->
                   Attributes ->
                   Attributes ->
                   Bool ->
                   T_Child
sem_Child_Child name_ tp_ inh_ syn_ higherOrder_ =
    (T_Child (\ _lhsIcon
                _lhsIcr
                _lhsInt ->
                  (let _lhsOname :: Name
                       _lhsOinherited :: Attributes
                       _lhsOsynthesized :: Attributes
                       _lhsOfield :: ( (Name,Type,Bool) )
                       _lhsOerrors :: (Seq Error)
                       _lhsOoutput :: Child
                       -- "DefaultRules.ag"(line 138, column 11)
                       _lhsOname =
                           name_
                       -- "DefaultRules.ag"(line 147, column 11)
                       _lhsOinherited =
                           inh_
                       -- "DefaultRules.ag"(line 148, column 11)
                       _lhsOsynthesized =
                           syn_
                       -- "DefaultRules.ag"(line 386, column 11)
                       _lhsOfield =
                           (name_,tp_,higherOrder_)
                       -- use rule "DefaultRules.ag"(line 107, column 19)
                       _lhsOerrors =
                           Seq.empty
                       -- self rule
                       _output =
                           Child name_ tp_ inh_ syn_ higherOrder_
                       -- self rule
                       _lhsOoutput =
                           _output
                   in  ( _lhsOerrors,_lhsOfield,_lhsOinherited,_lhsOname,_lhsOoutput,_lhsOsynthesized))))
-- Children ----------------------------------------------------
{-
   visit 0:
      inherited attributes:
         con                  : Constructor
         cr                   : Bool
         nt                   : Nonterminal
      synthesized attributes:
         errors               : Seq Error
         fields               : [(Name,Type,Bool)]
         inputs               : [(Name, Attributes)]
         output               : SELF
         outputs              : [(Name, Attributes)]
   alternatives:
      alternative Cons:
         child hd             : Child
         child tl             : Children
         visit 0:
            local output      : _
      alternative Nil:
         visit 0:
            local output      : _
-}
-- cata
sem_Children :: Children ->
                T_Children
sem_Children list =
    (Prelude.foldr sem_Children_Cons sem_Children_Nil (Prelude.map sem_Child list))
-- semantic domain
newtype T_Children = T_Children (Constructor ->
                                 Bool ->
                                 Nonterminal ->
                                 ( (Seq Error),([(Name,Type,Bool)]),([(Name, Attributes)]),Children,([(Name, Attributes)])))
data Inh_Children = Inh_Children {con_Inh_Children :: Constructor,cr_Inh_Children :: Bool,nt_Inh_Children :: Nonterminal}
data Syn_Children = Syn_Children {errors_Syn_Children :: Seq Error,fields_Syn_Children :: [(Name,Type,Bool)],inputs_Syn_Children :: [(Name, Attributes)],output_Syn_Children :: Children,outputs_Syn_Children :: [(Name, Attributes)]}
wrap_Children (T_Children sem) (Inh_Children _lhsIcon _lhsIcr _lhsInt) =
    (let ( _lhsOerrors,_lhsOfields,_lhsOinputs,_lhsOoutput,_lhsOoutputs) =
             (sem _lhsIcon _lhsIcr _lhsInt)
     in  (Syn_Children _lhsOerrors _lhsOfields _lhsOinputs _lhsOoutput _lhsOoutputs))
sem_Children_Cons :: T_Child ->
                     T_Children ->
                     T_Children
sem_Children_Cons (T_Child hd_) (T_Children tl_) =
    (T_Children (\ _lhsIcon
                   _lhsIcr
                   _lhsInt ->
                     (let _lhsOinputs :: ([(Name, Attributes)])
                          _lhsOoutputs :: ([(Name, Attributes)])
                          _lhsOfields :: ([(Name,Type,Bool)])
                          _lhsOerrors :: (Seq Error)
                          _lhsOoutput :: Children
                          _hdOcon :: Constructor
                          _hdOcr :: Bool
                          _hdOnt :: Nonterminal
                          _tlOcon :: Constructor
                          _tlOcr :: Bool
                          _tlOnt :: Nonterminal
                          _hdIerrors :: (Seq Error)
                          _hdIfield :: ( (Name,Type,Bool) )
                          _hdIinherited :: Attributes
                          _hdIname :: Name
                          _hdIoutput :: Child
                          _hdIsynthesized :: Attributes
                          _tlIerrors :: (Seq Error)
                          _tlIfields :: ([(Name,Type,Bool)])
                          _tlIinputs :: ([(Name, Attributes)])
                          _tlIoutput :: Children
                          _tlIoutputs :: ([(Name, Attributes)])
                          -- "DefaultRules.ag"(line 151, column 10)
                          _lhsOinputs =
                              (_hdIname, _hdIinherited) : _tlIinputs
                          -- "DefaultRules.ag"(line 151, column 10)
                          _lhsOoutputs =
                              (_hdIname, _hdIsynthesized) : _tlIoutputs
                          -- "DefaultRules.ag"(line 382, column 10)
                          _lhsOfields =
                              _hdIfield : _tlIfields
                          -- use rule "DefaultRules.ag"(line 107, column 19)
                          _lhsOerrors =
                              _hdIerrors Seq.<> _tlIerrors
                          -- self rule
                          _output =
                              (:) _hdIoutput _tlIoutput
                          -- self rule
                          _lhsOoutput =
                              _output
                          -- copy rule (down)
                          _hdOcon =
                              _lhsIcon
                          -- copy rule (down)
                          _hdOcr =
                              _lhsIcr
                          -- copy rule (down)
                          _hdOnt =
                              _lhsInt
                          -- copy rule (down)
                          _tlOcon =
                              _lhsIcon
                          -- copy rule (down)
                          _tlOcr =
                              _lhsIcr
                          -- copy rule (down)
                          _tlOnt =
                              _lhsInt
                          ( _hdIerrors,_hdIfield,_hdIinherited,_hdIname,_hdIoutput,_hdIsynthesized) =
                              (hd_ _hdOcon _hdOcr _hdOnt)
                          ( _tlIerrors,_tlIfields,_tlIinputs,_tlIoutput,_tlIoutputs) =
                              (tl_ _tlOcon _tlOcr _tlOnt)
                      in  ( _lhsOerrors,_lhsOfields,_lhsOinputs,_lhsOoutput,_lhsOoutputs))))
sem_Children_Nil :: T_Children
sem_Children_Nil  =
    (T_Children (\ _lhsIcon
                   _lhsIcr
                   _lhsInt ->
                     (let _lhsOinputs :: ([(Name, Attributes)])
                          _lhsOoutputs :: ([(Name, Attributes)])
                          _lhsOfields :: ([(Name,Type,Bool)])
                          _lhsOerrors :: (Seq Error)
                          _lhsOoutput :: Children
                          -- "DefaultRules.ag"(line 153, column 10)
                          _lhsOinputs =
                              []
                          -- "DefaultRules.ag"(line 153, column 10)
                          _lhsOoutputs =
                              []
                          -- "DefaultRules.ag"(line 383, column 10)
                          _lhsOfields =
                              []
                          -- use rule "DefaultRules.ag"(line 107, column 19)
                          _lhsOerrors =
                              Seq.empty
                          -- self rule
                          _output =
                              []
                          -- self rule
                          _lhsOoutput =
                              _output
                      in  ( _lhsOerrors,_lhsOfields,_lhsOinputs,_lhsOoutput,_lhsOoutputs))))
-- Grammar -----------------------------------------------------
{-
   visit 0:
      inherited attribute:
         options              : Options
      synthesized attributes:
         errors               : Seq Error
         output               : SELF
   alternatives:
      alternative Grammar:
         child typeSyns       : {TypeSyns}
         child useMap         : {UseMap}
         child derivings      : {Derivings}
         child wrappers       : {Set Nonterminal}
         child prods          : Productions
         child pragmas        : {PragmaMap}
         child manualAttrOrderMap : {AttrOrderMap}
         visit 0:
            local output      : _
-}
-- cata
sem_Grammar :: Grammar ->
               T_Grammar
sem_Grammar (Grammar _typeSyns _useMap _derivings _wrappers _prods _pragmas _manualAttrOrderMap) =
    (sem_Grammar_Grammar _typeSyns _useMap _derivings _wrappers (sem_Productions _prods) _pragmas _manualAttrOrderMap)
-- semantic domain
newtype T_Grammar = T_Grammar (Options ->
                               ( (Seq Error),Grammar))
data Inh_Grammar = Inh_Grammar {options_Inh_Grammar :: Options}
data Syn_Grammar = Syn_Grammar {errors_Syn_Grammar :: Seq Error,output_Syn_Grammar :: Grammar}
wrap_Grammar (T_Grammar sem) (Inh_Grammar _lhsIoptions) =
    (let ( _lhsOerrors,_lhsOoutput) =
             (sem _lhsIoptions)
     in  (Syn_Grammar _lhsOerrors _lhsOoutput))
sem_Grammar_Grammar :: TypeSyns ->
                       UseMap ->
                       Derivings ->
                       (Set Nonterminal) ->
                       T_Productions ->
                       PragmaMap ->
                       AttrOrderMap ->
                       T_Grammar
sem_Grammar_Grammar typeSyns_ useMap_ derivings_ wrappers_ (T_Productions prods_) pragmas_ manualAttrOrderMap_ =
    (T_Grammar (\ _lhsIoptions ->
                    (let _prodsOo_rename :: Bool
                         _prodsOcr :: Bool
                         _prodsOnonterminals :: (Set Nonterminal)
                         _prodsOuseMap :: UseMap
                         _prodsOtypeSyns :: TypeSyns
                         _prodsOuniq :: Int
                         _prodsOmanualAttrOrderMap :: AttrOrderMap
                         _lhsOerrors :: (Seq Error)
                         _lhsOoutput :: Grammar
                         _prodsIcollect_nts :: (Set Nonterminal)
                         _prodsIerrors :: (Seq Error)
                         _prodsIoutput :: Productions
                         _prodsIuniq :: Int
                         -- "DefaultRules.ag"(line 41, column 17)
                         _prodsOo_rename =
                             rename    _lhsIoptions
                         -- "DefaultRules.ag"(line 42, column 17)
                         _prodsOcr =
                             modcopy   _lhsIoptions
                         -- "DefaultRules.ag"(line 119, column 13)
                         _prodsOnonterminals =
                             _prodsIcollect_nts
                         -- "DefaultRules.ag"(line 140, column 13)
                         _prodsOuseMap =
                             useMap_
                         -- "DefaultRules.ag"(line 142, column 13)
                         _prodsOtypeSyns =
                             typeSyns_
                         -- "DefaultRules.ag"(line 403, column 13)
                         _prodsOuniq =
                             1
                         -- "DefaultRules.ag"(line 479, column 7)
                         _prodsOmanualAttrOrderMap =
                             manualAttrOrderMap_
                         -- use rule "DefaultRules.ag"(line 107, column 19)
                         _lhsOerrors =
                             _prodsIerrors
                         -- self rule
                         _output =
                             Grammar typeSyns_ useMap_ derivings_ wrappers_ _prodsIoutput pragmas_ manualAttrOrderMap_
                         -- self rule
                         _lhsOoutput =
                             _output
                         ( _prodsIcollect_nts,_prodsIerrors,_prodsIoutput,_prodsIuniq) =
                             (prods_ _prodsOcr _prodsOmanualAttrOrderMap _prodsOnonterminals _prodsOo_rename _prodsOtypeSyns _prodsOuniq _prodsOuseMap)
                     in  ( _lhsOerrors,_lhsOoutput))))
-- Pattern -----------------------------------------------------
{-
   visit 0:
      inherited attributes:
         con                  : Constructor
         nt                   : Nonterminal
      synthesized attributes:
         containsVars         : Bool
         copy                 : SELF
         definedAttrs         : Set (Name,Name)
         errors               : Seq Error
         locals               : Set Name
         output               : SELF
   alternatives:
      alternative Alias:
         child field          : {Name}
         child attr           : {Name}
         child pat            : Pattern
         child parts          : Patterns
         visit 0:
            local copy        : _
            local output      : _
      alternative Constr:
         child name           : {Constructor}
         child pats           : Patterns
         visit 0:
            local copy        : _
            local output      : _
      alternative Product:
         child pos            : {Pos}
         child pats           : Patterns
         visit 0:
            local copy        : _
            local output      : _
      alternative Underscore:
         child pos            : {Pos}
         visit 0:
            local copy        : _
            local output      : _
-}
-- cata
sem_Pattern :: Pattern ->
               T_Pattern
sem_Pattern (Alias _field _attr _pat _parts) =
    (sem_Pattern_Alias _field _attr (sem_Pattern _pat) (sem_Patterns _parts))
sem_Pattern (Constr _name _pats) =
    (sem_Pattern_Constr _name (sem_Patterns _pats))
sem_Pattern (Product _pos _pats) =
    (sem_Pattern_Product _pos (sem_Patterns _pats))
sem_Pattern (Underscore _pos) =
    (sem_Pattern_Underscore _pos)
-- semantic domain
newtype T_Pattern = T_Pattern (Constructor ->
                               Nonterminal ->
                               ( Bool,Pattern,(Set (Name,Name)),(Seq Error),(Set Name),Pattern))
data Inh_Pattern = Inh_Pattern {con_Inh_Pattern :: Constructor,nt_Inh_Pattern :: Nonterminal}
data Syn_Pattern = Syn_Pattern {containsVars_Syn_Pattern :: Bool,copy_Syn_Pattern :: Pattern,definedAttrs_Syn_Pattern :: Set (Name,Name),errors_Syn_Pattern :: Seq Error,locals_Syn_Pattern :: Set Name,output_Syn_Pattern :: Pattern}
wrap_Pattern (T_Pattern sem) (Inh_Pattern _lhsIcon _lhsInt) =
    (let ( _lhsOcontainsVars,_lhsOcopy,_lhsOdefinedAttrs,_lhsOerrors,_lhsOlocals,_lhsOoutput) =
             (sem _lhsIcon _lhsInt)
     in  (Syn_Pattern _lhsOcontainsVars _lhsOcopy _lhsOdefinedAttrs _lhsOerrors _lhsOlocals _lhsOoutput))
sem_Pattern_Alias :: Name ->
                     Name ->
                     T_Pattern ->
                     T_Patterns ->
                     T_Pattern
sem_Pattern_Alias field_ attr_ (T_Pattern pat_) (T_Patterns parts_) =
    (T_Pattern (\ _lhsIcon
                  _lhsInt ->
                    (let _lhsOdefinedAttrs :: (Set (Name,Name))
                         _lhsOlocals :: (Set Name)
                         _lhsOcontainsVars :: Bool
                         _lhsOerrors :: (Seq Error)
                         _lhsOcopy :: Pattern
                         _lhsOoutput :: Pattern
                         _patOcon :: Constructor
                         _patOnt :: Nonterminal
                         _partsOcon :: Constructor
                         _partsOnt :: Nonterminal
                         _patIcontainsVars :: Bool
                         _patIcopy :: Pattern
                         _patIdefinedAttrs :: (Set (Name,Name))
                         _patIerrors :: (Seq Error)
                         _patIlocals :: (Set Name)
                         _patIoutput :: Pattern
                         _partsIcontainsVars :: Bool
                         _partsIcopy :: Patterns
                         _partsIdefinedAttrs :: (Set (Name,Name))
                         _partsIerrors :: (Seq Error)
                         _partsIlocals :: (Set Name)
                         _partsIoutput :: Patterns
                         -- "DefaultRules.ag"(line 376, column 11)
                         _lhsOdefinedAttrs =
                             Set.insert (field_,attr_) _patIdefinedAttrs
                         -- "DefaultRules.ag"(line 376, column 11)
                         _lhsOlocals =
                             if field_ == _LOC
                                then Set.insert attr_ _patIlocals
                                else _patIlocals
                         -- "DefaultRules.ag"(line 394, column 16)
                         _lhsOcontainsVars =
                             True
                         -- use rule "DefaultRules.ag"(line 107, column 19)
                         _lhsOerrors =
                             _patIerrors Seq.<> _partsIerrors
                         -- self rule
                         _copy =
                             Alias field_ attr_ _patIcopy _partsIcopy
                         -- self rule
                         _output =
                             Alias field_ attr_ _patIoutput _partsIoutput
                         -- self rule
                         _lhsOcopy =
                             _copy
                         -- self rule
                         _lhsOoutput =
                             _output
                         -- copy rule (down)
                         _patOcon =
                             _lhsIcon
                         -- copy rule (down)
                         _patOnt =
                             _lhsInt
                         -- copy rule (down)
                         _partsOcon =
                             _lhsIcon
                         -- copy rule (down)
                         _partsOnt =
                             _lhsInt
                         ( _patIcontainsVars,_patIcopy,_patIdefinedAttrs,_patIerrors,_patIlocals,_patIoutput) =
                             (pat_ _patOcon _patOnt)
                         ( _partsIcontainsVars,_partsIcopy,_partsIdefinedAttrs,_partsIerrors,_partsIlocals,_partsIoutput) =
                             (parts_ _partsOcon _partsOnt)
                     in  ( _lhsOcontainsVars,_lhsOcopy,_lhsOdefinedAttrs,_lhsOerrors,_lhsOlocals,_lhsOoutput))))
sem_Pattern_Constr :: Constructor ->
                      T_Patterns ->
                      T_Pattern
sem_Pattern_Constr name_ (T_Patterns pats_) =
    (T_Pattern (\ _lhsIcon
                  _lhsInt ->
                    (let _lhsOcontainsVars :: Bool
                         _lhsOdefinedAttrs :: (Set (Name,Name))
                         _lhsOerrors :: (Seq Error)
                         _lhsOlocals :: (Set Name)
                         _lhsOcopy :: Pattern
                         _lhsOoutput :: Pattern
                         _patsOcon :: Constructor
                         _patsOnt :: Nonterminal
                         _patsIcontainsVars :: Bool
                         _patsIcopy :: Patterns
                         _patsIdefinedAttrs :: (Set (Name,Name))
                         _patsIerrors :: (Seq Error)
                         _patsIlocals :: (Set Name)
                         _patsIoutput :: Patterns
                         -- use rule "DefaultRules.ag"(line 391, column 46)
                         _lhsOcontainsVars =
                             _patsIcontainsVars
                         -- use rule "DefaultRules.ag"(line 371, column 23)
                         _lhsOdefinedAttrs =
                             _patsIdefinedAttrs
                         -- use rule "DefaultRules.ag"(line 107, column 19)
                         _lhsOerrors =
                             _patsIerrors
                         -- use rule "DefaultRules.ag"(line 370, column 23)
                         _lhsOlocals =
                             _patsIlocals
                         -- self rule
                         _copy =
                             Constr name_ _patsIcopy
                         -- self rule
                         _output =
                             Constr name_ _patsIoutput
                         -- self rule
                         _lhsOcopy =
                             _copy
                         -- self rule
                         _lhsOoutput =
                             _output
                         -- copy rule (down)
                         _patsOcon =
                             _lhsIcon
                         -- copy rule (down)
                         _patsOnt =
                             _lhsInt
                         ( _patsIcontainsVars,_patsIcopy,_patsIdefinedAttrs,_patsIerrors,_patsIlocals,_patsIoutput) =
                             (pats_ _patsOcon _patsOnt)
                     in  ( _lhsOcontainsVars,_lhsOcopy,_lhsOdefinedAttrs,_lhsOerrors,_lhsOlocals,_lhsOoutput))))
sem_Pattern_Product :: Pos ->
                       T_Patterns ->
                       T_Pattern
sem_Pattern_Product pos_ (T_Patterns pats_) =
    (T_Pattern (\ _lhsIcon
                  _lhsInt ->
                    (let _lhsOcontainsVars :: Bool
                         _lhsOdefinedAttrs :: (Set (Name,Name))
                         _lhsOerrors :: (Seq Error)
                         _lhsOlocals :: (Set Name)
                         _lhsOcopy :: Pattern
                         _lhsOoutput :: Pattern
                         _patsOcon :: Constructor
                         _patsOnt :: Nonterminal
                         _patsIcontainsVars :: Bool
                         _patsIcopy :: Patterns
                         _patsIdefinedAttrs :: (Set (Name,Name))
                         _patsIerrors :: (Seq Error)
                         _patsIlocals :: (Set Name)
                         _patsIoutput :: Patterns
                         -- use rule "DefaultRules.ag"(line 391, column 46)
                         _lhsOcontainsVars =
                             _patsIcontainsVars
                         -- use rule "DefaultRules.ag"(line 371, column 23)
                         _lhsOdefinedAttrs =
                             _patsIdefinedAttrs
                         -- use rule "DefaultRules.ag"(line 107, column 19)
                         _lhsOerrors =
                             _patsIerrors
                         -- use rule "DefaultRules.ag"(line 370, column 23)
                         _lhsOlocals =
                             _patsIlocals
                         -- self rule
                         _copy =
                             Product pos_ _patsIcopy
                         -- self rule
                         _output =
                             Product pos_ _patsIoutput
                         -- self rule
                         _lhsOcopy =
                             _copy
                         -- self rule
                         _lhsOoutput =
                             _output
                         -- copy rule (down)
                         _patsOcon =
                             _lhsIcon
                         -- copy rule (down)
                         _patsOnt =
                             _lhsInt
                         ( _patsIcontainsVars,_patsIcopy,_patsIdefinedAttrs,_patsIerrors,_patsIlocals,_patsIoutput) =
                             (pats_ _patsOcon _patsOnt)
                     in  ( _lhsOcontainsVars,_lhsOcopy,_lhsOdefinedAttrs,_lhsOerrors,_lhsOlocals,_lhsOoutput))))
sem_Pattern_Underscore :: Pos ->
                          T_Pattern
sem_Pattern_Underscore pos_ =
    (T_Pattern (\ _lhsIcon
                  _lhsInt ->
                    (let _lhsOcontainsVars :: Bool
                         _lhsOdefinedAttrs :: (Set (Name,Name))
                         _lhsOerrors :: (Seq Error)
                         _lhsOlocals :: (Set Name)
                         _lhsOcopy :: Pattern
                         _lhsOoutput :: Pattern
                         -- use rule "DefaultRules.ag"(line 391, column 46)
                         _lhsOcontainsVars =
                             False
                         -- use rule "DefaultRules.ag"(line 371, column 23)
                         _lhsOdefinedAttrs =
                             Set.empty
                         -- use rule "DefaultRules.ag"(line 107, column 19)
                         _lhsOerrors =
                             Seq.empty
                         -- use rule "DefaultRules.ag"(line 370, column 23)
                         _lhsOlocals =
                             Set.empty
                         -- self rule
                         _copy =
                             Underscore pos_
                         -- self rule
                         _output =
                             Underscore pos_
                         -- self rule
                         _lhsOcopy =
                             _copy
                         -- self rule
                         _lhsOoutput =
                             _output
                     in  ( _lhsOcontainsVars,_lhsOcopy,_lhsOdefinedAttrs,_lhsOerrors,_lhsOlocals,_lhsOoutput))))
-- Patterns ----------------------------------------------------
{-
   visit 0:
      inherited attributes:
         con                  : Constructor
         nt                   : Nonterminal
      synthesized attributes:
         containsVars         : Bool
         copy                 : SELF
         definedAttrs         : Set (Name,Name)
         errors               : Seq Error
         locals               : Set Name
         output               : SELF
   alternatives:
      alternative Cons:
         child hd             : Pattern
         child tl             : Patterns
         visit 0:
            local copy        : _
            local output      : _
      alternative Nil:
         visit 0:
            local copy        : _
            local output      : _
-}
-- cata
sem_Patterns :: Patterns ->
                T_Patterns
sem_Patterns list =
    (Prelude.foldr sem_Patterns_Cons sem_Patterns_Nil (Prelude.map sem_Pattern list))
-- semantic domain
newtype T_Patterns = T_Patterns (Constructor ->
                                 Nonterminal ->
                                 ( Bool,Patterns,(Set (Name,Name)),(Seq Error),(Set Name),Patterns))
data Inh_Patterns = Inh_Patterns {con_Inh_Patterns :: Constructor,nt_Inh_Patterns :: Nonterminal}
data Syn_Patterns = Syn_Patterns {containsVars_Syn_Patterns :: Bool,copy_Syn_Patterns :: Patterns,definedAttrs_Syn_Patterns :: Set (Name,Name),errors_Syn_Patterns :: Seq Error,locals_Syn_Patterns :: Set Name,output_Syn_Patterns :: Patterns}
wrap_Patterns (T_Patterns sem) (Inh_Patterns _lhsIcon _lhsInt) =
    (let ( _lhsOcontainsVars,_lhsOcopy,_lhsOdefinedAttrs,_lhsOerrors,_lhsOlocals,_lhsOoutput) =
             (sem _lhsIcon _lhsInt)
     in  (Syn_Patterns _lhsOcontainsVars _lhsOcopy _lhsOdefinedAttrs _lhsOerrors _lhsOlocals _lhsOoutput))
sem_Patterns_Cons :: T_Pattern ->
                     T_Patterns ->
                     T_Patterns
sem_Patterns_Cons (T_Pattern hd_) (T_Patterns tl_) =
    (T_Patterns (\ _lhsIcon
                   _lhsInt ->
                     (let _lhsOcontainsVars :: Bool
                          _lhsOdefinedAttrs :: (Set (Name,Name))
                          _lhsOerrors :: (Seq Error)
                          _lhsOlocals :: (Set Name)
                          _lhsOcopy :: Patterns
                          _lhsOoutput :: Patterns
                          _hdOcon :: Constructor
                          _hdOnt :: Nonterminal
                          _tlOcon :: Constructor
                          _tlOnt :: Nonterminal
                          _hdIcontainsVars :: Bool
                          _hdIcopy :: Pattern
                          _hdIdefinedAttrs :: (Set (Name,Name))
                          _hdIerrors :: (Seq Error)
                          _hdIlocals :: (Set Name)
                          _hdIoutput :: Pattern
                          _tlIcontainsVars :: Bool
                          _tlIcopy :: Patterns
                          _tlIdefinedAttrs :: (Set (Name,Name))
                          _tlIerrors :: (Seq Error)
                          _tlIlocals :: (Set Name)
                          _tlIoutput :: Patterns
                          -- use rule "DefaultRules.ag"(line 391, column 46)
                          _lhsOcontainsVars =
                              _hdIcontainsVars || _tlIcontainsVars
                          -- use rule "DefaultRules.ag"(line 371, column 23)
                          _lhsOdefinedAttrs =
                              _hdIdefinedAttrs `Set.union` _tlIdefinedAttrs
                          -- use rule "DefaultRules.ag"(line 107, column 19)
                          _lhsOerrors =
                              _hdIerrors Seq.<> _tlIerrors
                          -- use rule "DefaultRules.ag"(line 370, column 23)
                          _lhsOlocals =
                              _hdIlocals `Set.union` _tlIlocals
                          -- self rule
                          _copy =
                              (:) _hdIcopy _tlIcopy
                          -- self rule
                          _output =
                              (:) _hdIoutput _tlIoutput
                          -- self rule
                          _lhsOcopy =
                              _copy
                          -- self rule
                          _lhsOoutput =
                              _output
                          -- copy rule (down)
                          _hdOcon =
                              _lhsIcon
                          -- copy rule (down)
                          _hdOnt =
                              _lhsInt
                          -- copy rule (down)
                          _tlOcon =
                              _lhsIcon
                          -- copy rule (down)
                          _tlOnt =
                              _lhsInt
                          ( _hdIcontainsVars,_hdIcopy,_hdIdefinedAttrs,_hdIerrors,_hdIlocals,_hdIoutput) =
                              (hd_ _hdOcon _hdOnt)
                          ( _tlIcontainsVars,_tlIcopy,_tlIdefinedAttrs,_tlIerrors,_tlIlocals,_tlIoutput) =
                              (tl_ _tlOcon _tlOnt)
                      in  ( _lhsOcontainsVars,_lhsOcopy,_lhsOdefinedAttrs,_lhsOerrors,_lhsOlocals,_lhsOoutput))))
sem_Patterns_Nil :: T_Patterns
sem_Patterns_Nil  =
    (T_Patterns (\ _lhsIcon
                   _lhsInt ->
                     (let _lhsOcontainsVars :: Bool
                          _lhsOdefinedAttrs :: (Set (Name,Name))
                          _lhsOerrors :: (Seq Error)
                          _lhsOlocals :: (Set Name)
                          _lhsOcopy :: Patterns
                          _lhsOoutput :: Patterns
                          -- use rule "DefaultRules.ag"(line 391, column 46)
                          _lhsOcontainsVars =
                              False
                          -- use rule "DefaultRules.ag"(line 371, column 23)
                          _lhsOdefinedAttrs =
                              Set.empty
                          -- use rule "DefaultRules.ag"(line 107, column 19)
                          _lhsOerrors =
                              Seq.empty
                          -- use rule "DefaultRules.ag"(line 370, column 23)
                          _lhsOlocals =
                              Set.empty
                          -- self rule
                          _copy =
                              []
                          -- self rule
                          _output =
                              []
                          -- self rule
                          _lhsOcopy =
                              _copy
                          -- self rule
                          _lhsOoutput =
                              _output
                      in  ( _lhsOcontainsVars,_lhsOcopy,_lhsOdefinedAttrs,_lhsOerrors,_lhsOlocals,_lhsOoutput))))
-- Production --------------------------------------------------
{-
   visit 0:
      inherited attributes:
         cr                   : Bool
         manualAttrOrderMap   : AttrOrderMap
         nonterminals         : Set Nonterminal
         o_rename             : Bool
         typeSyns             : TypeSyns
         useMap               : UseMap
      chained attribute:
         uniq                 : Int
      synthesized attributes:
         collect_nts          : Set Nonterminal
         errors               : Seq Error
         output               : SELF
   alternatives:
      alternative Production:
         child nt             : {Nonterminal}
         child inh            : {Attributes}
         child syn            : {Attributes}
         child alts           : Alternatives
         visit 0:
            local output      : _
-}
-- cata
sem_Production :: Production ->
                  T_Production
sem_Production (Production _nt _inh _syn _alts) =
    (sem_Production_Production _nt _inh _syn (sem_Alternatives _alts))
-- semantic domain
newtype T_Production = T_Production (Bool ->
                                     AttrOrderMap ->
                                     (Set Nonterminal) ->
                                     Bool ->
                                     TypeSyns ->
                                     Int ->
                                     UseMap ->
                                     ( (Set Nonterminal),(Seq Error),Production,Int))
data Inh_Production = Inh_Production {cr_Inh_Production :: Bool,manualAttrOrderMap_Inh_Production :: AttrOrderMap,nonterminals_Inh_Production :: Set Nonterminal,o_rename_Inh_Production :: Bool,typeSyns_Inh_Production :: TypeSyns,uniq_Inh_Production :: Int,useMap_Inh_Production :: UseMap}
data Syn_Production = Syn_Production {collect_nts_Syn_Production :: Set Nonterminal,errors_Syn_Production :: Seq Error,output_Syn_Production :: Production,uniq_Syn_Production :: Int}
wrap_Production (T_Production sem) (Inh_Production _lhsIcr _lhsImanualAttrOrderMap _lhsInonterminals _lhsIo_rename _lhsItypeSyns _lhsIuniq _lhsIuseMap) =
    (let ( _lhsOcollect_nts,_lhsOerrors,_lhsOoutput,_lhsOuniq) =
             (sem _lhsIcr _lhsImanualAttrOrderMap _lhsInonterminals _lhsIo_rename _lhsItypeSyns _lhsIuniq _lhsIuseMap)
     in  (Syn_Production _lhsOcollect_nts _lhsOerrors _lhsOoutput _lhsOuniq))
sem_Production_Production :: Nonterminal ->
                             Attributes ->
                             Attributes ->
                             T_Alternatives ->
                             T_Production
sem_Production_Production nt_ inh_ syn_ (T_Alternatives alts_) =
    (T_Production (\ _lhsIcr
                     _lhsImanualAttrOrderMap
                     _lhsInonterminals
                     _lhsIo_rename
                     _lhsItypeSyns
                     _lhsIuniq
                     _lhsIuseMap ->
                       (let _lhsOcollect_nts :: (Set Nonterminal)
                            _altsOinh :: Attributes
                            _altsOsyn :: Attributes
                            _altsOuseMap :: (Map Name (String,String,String))
                            _altsOnt :: Nonterminal
                            _lhsOerrors :: (Seq Error)
                            _lhsOoutput :: Production
                            _lhsOuniq :: Int
                            _altsOcr :: Bool
                            _altsOmanualAttrOrderMap :: AttrOrderMap
                            _altsOnonterminals :: (Set Nonterminal)
                            _altsOo_rename :: Bool
                            _altsOtypeSyns :: TypeSyns
                            _altsOuniq :: Int
                            _altsIerrors :: (Seq Error)
                            _altsIoutput :: Alternatives
                            _altsIuniq :: Int
                            -- "DefaultRules.ag"(line 115, column 16)
                            _lhsOcollect_nts =
                                Set.singleton nt_
                            -- "DefaultRules.ag"(line 130, column 17)
                            _altsOinh =
                                inh_
                            -- "DefaultRules.ag"(line 131, column 17)
                            _altsOsyn =
                                syn_
                            -- "DefaultRules.ag"(line 132, column 17)
                            _altsOuseMap =
                                Map.findWithDefault Map.empty nt_ _lhsIuseMap
                            -- "DefaultRules.ag"(line 144, column 16)
                            _altsOnt =
                                nt_
                            -- use rule "DefaultRules.ag"(line 107, column 19)
                            _lhsOerrors =
                                _altsIerrors
                            -- self rule
                            _output =
                                Production nt_ inh_ syn_ _altsIoutput
                            -- self rule
                            _lhsOoutput =
                                _output
                            -- copy rule (up)
                            _lhsOuniq =
                                _altsIuniq
                            -- copy rule (down)
                            _altsOcr =
                                _lhsIcr
                            -- copy rule (down)
                            _altsOmanualAttrOrderMap =
                                _lhsImanualAttrOrderMap
                            -- copy rule (down)
                            _altsOnonterminals =
                                _lhsInonterminals
                            -- copy rule (down)
                            _altsOo_rename =
                                _lhsIo_rename
                            -- copy rule (down)
                            _altsOtypeSyns =
                                _lhsItypeSyns
                            -- copy rule (down)
                            _altsOuniq =
                                _lhsIuniq
                            ( _altsIerrors,_altsIoutput,_altsIuniq) =
                                (alts_ _altsOcr _altsOinh _altsOmanualAttrOrderMap _altsOnonterminals _altsOnt _altsOo_rename _altsOsyn _altsOtypeSyns _altsOuniq _altsOuseMap)
                        in  ( _lhsOcollect_nts,_lhsOerrors,_lhsOoutput,_lhsOuniq))))
-- Productions -------------------------------------------------
{-
   visit 0:
      inherited attributes:
         cr                   : Bool
         manualAttrOrderMap   : AttrOrderMap
         nonterminals         : Set Nonterminal
         o_rename             : Bool
         typeSyns             : TypeSyns
         useMap               : UseMap
      chained attribute:
         uniq                 : Int
      synthesized attributes:
         collect_nts          : Set Nonterminal
         errors               : Seq Error
         output               : SELF
   alternatives:
      alternative Cons:
         child hd             : Production
         child tl             : Productions
         visit 0:
            local output      : _
      alternative Nil:
         visit 0:
            local output      : _
-}
-- cata
sem_Productions :: Productions ->
                   T_Productions
sem_Productions list =
    (Prelude.foldr sem_Productions_Cons sem_Productions_Nil (Prelude.map sem_Production list))
-- semantic domain
newtype T_Productions = T_Productions (Bool ->
                                       AttrOrderMap ->
                                       (Set Nonterminal) ->
                                       Bool ->
                                       TypeSyns ->
                                       Int ->
                                       UseMap ->
                                       ( (Set Nonterminal),(Seq Error),Productions,Int))
data Inh_Productions = Inh_Productions {cr_Inh_Productions :: Bool,manualAttrOrderMap_Inh_Productions :: AttrOrderMap,nonterminals_Inh_Productions :: Set Nonterminal,o_rename_Inh_Productions :: Bool,typeSyns_Inh_Productions :: TypeSyns,uniq_Inh_Productions :: Int,useMap_Inh_Productions :: UseMap}
data Syn_Productions = Syn_Productions {collect_nts_Syn_Productions :: Set Nonterminal,errors_Syn_Productions :: Seq Error,output_Syn_Productions :: Productions,uniq_Syn_Productions :: Int}
wrap_Productions (T_Productions sem) (Inh_Productions _lhsIcr _lhsImanualAttrOrderMap _lhsInonterminals _lhsIo_rename _lhsItypeSyns _lhsIuniq _lhsIuseMap) =
    (let ( _lhsOcollect_nts,_lhsOerrors,_lhsOoutput,_lhsOuniq) =
             (sem _lhsIcr _lhsImanualAttrOrderMap _lhsInonterminals _lhsIo_rename _lhsItypeSyns _lhsIuniq _lhsIuseMap)
     in  (Syn_Productions _lhsOcollect_nts _lhsOerrors _lhsOoutput _lhsOuniq))
sem_Productions_Cons :: T_Production ->
                        T_Productions ->
                        T_Productions
sem_Productions_Cons (T_Production hd_) (T_Productions tl_) =
    (T_Productions (\ _lhsIcr
                      _lhsImanualAttrOrderMap
                      _lhsInonterminals
                      _lhsIo_rename
                      _lhsItypeSyns
                      _lhsIuniq
                      _lhsIuseMap ->
                        (let _lhsOcollect_nts :: (Set Nonterminal)
                             _lhsOerrors :: (Seq Error)
                             _lhsOoutput :: Productions
                             _lhsOuniq :: Int
                             _hdOcr :: Bool
                             _hdOmanualAttrOrderMap :: AttrOrderMap
                             _hdOnonterminals :: (Set Nonterminal)
                             _hdOo_rename :: Bool
                             _hdOtypeSyns :: TypeSyns
                             _hdOuniq :: Int
                             _hdOuseMap :: UseMap
                             _tlOcr :: Bool
                             _tlOmanualAttrOrderMap :: AttrOrderMap
                             _tlOnonterminals :: (Set Nonterminal)
                             _tlOo_rename :: Bool
                             _tlOtypeSyns :: TypeSyns
                             _tlOuniq :: Int
                             _tlOuseMap :: UseMap
                             _hdIcollect_nts :: (Set Nonterminal)
                             _hdIerrors :: (Seq Error)
                             _hdIoutput :: Production
                             _hdIuniq :: Int
                             _tlIcollect_nts :: (Set Nonterminal)
                             _tlIerrors :: (Seq Error)
                             _tlIoutput :: Productions
                             _tlIuniq :: Int
                             -- use rule "DefaultRules.ag"(line 113, column 47)
                             _lhsOcollect_nts =
                                 _hdIcollect_nts `Set.union` _tlIcollect_nts
                             -- use rule "DefaultRules.ag"(line 107, column 19)
                             _lhsOerrors =
                                 _hdIerrors Seq.<> _tlIerrors
                             -- self rule
                             _output =
                                 (:) _hdIoutput _tlIoutput
                             -- self rule
                             _lhsOoutput =
                                 _output
                             -- copy rule (up)
                             _lhsOuniq =
                                 _tlIuniq
                             -- copy rule (down)
                             _hdOcr =
                                 _lhsIcr
                             -- copy rule (down)
                             _hdOmanualAttrOrderMap =
                                 _lhsImanualAttrOrderMap
                             -- copy rule (down)
                             _hdOnonterminals =
                                 _lhsInonterminals
                             -- copy rule (down)
                             _hdOo_rename =
                                 _lhsIo_rename
                             -- copy rule (down)
                             _hdOtypeSyns =
                                 _lhsItypeSyns
                             -- copy rule (down)
                             _hdOuniq =
                                 _lhsIuniq
                             -- copy rule (down)
                             _hdOuseMap =
                                 _lhsIuseMap
                             -- copy rule (down)
                             _tlOcr =
                                 _lhsIcr
                             -- copy rule (down)
                             _tlOmanualAttrOrderMap =
                                 _lhsImanualAttrOrderMap
                             -- copy rule (down)
                             _tlOnonterminals =
                                 _lhsInonterminals
                             -- copy rule (down)
                             _tlOo_rename =
                                 _lhsIo_rename
                             -- copy rule (down)
                             _tlOtypeSyns =
                                 _lhsItypeSyns
                             -- copy rule (chain)
                             _tlOuniq =
                                 _hdIuniq
                             -- copy rule (down)
                             _tlOuseMap =
                                 _lhsIuseMap
                             ( _hdIcollect_nts,_hdIerrors,_hdIoutput,_hdIuniq) =
                                 (hd_ _hdOcr _hdOmanualAttrOrderMap _hdOnonterminals _hdOo_rename _hdOtypeSyns _hdOuniq _hdOuseMap)
                             ( _tlIcollect_nts,_tlIerrors,_tlIoutput,_tlIuniq) =
                                 (tl_ _tlOcr _tlOmanualAttrOrderMap _tlOnonterminals _tlOo_rename _tlOtypeSyns _tlOuniq _tlOuseMap)
                         in  ( _lhsOcollect_nts,_lhsOerrors,_lhsOoutput,_lhsOuniq))))
sem_Productions_Nil :: T_Productions
sem_Productions_Nil  =
    (T_Productions (\ _lhsIcr
                      _lhsImanualAttrOrderMap
                      _lhsInonterminals
                      _lhsIo_rename
                      _lhsItypeSyns
                      _lhsIuniq
                      _lhsIuseMap ->
                        (let _lhsOcollect_nts :: (Set Nonterminal)
                             _lhsOerrors :: (Seq Error)
                             _lhsOoutput :: Productions
                             _lhsOuniq :: Int
                             -- use rule "DefaultRules.ag"(line 113, column 47)
                             _lhsOcollect_nts =
                                 Set.empty
                             -- use rule "DefaultRules.ag"(line 107, column 19)
                             _lhsOerrors =
                                 Seq.empty
                             -- self rule
                             _output =
                                 []
                             -- self rule
                             _lhsOoutput =
                                 _output
                             -- copy rule (chain)
                             _lhsOuniq =
                                 _lhsIuniq
                         in  ( _lhsOcollect_nts,_lhsOerrors,_lhsOoutput,_lhsOuniq))))
-- Rule --------------------------------------------------------
{-
   visit 0:
      inherited attributes:
         con                  : Constructor
         nt                   : Nonterminal
      chained attribute:
         uniq                 : Int
      synthesized attributes:
         containsVars         : Bool
         definedAttrs         : Set (Name,Name)
         errors               : Seq Error
         locals               : Set Name
         output               : SELF
         outputs              : Rules
   alternatives:
      alternative Rule:
         child pattern        : Pattern
         child rhs            : {Expression}
         child owrt           : {Bool}
         child origin         : {String}
         visit 0:
            local _tup2       : {(Rules,Int)}
            local output      : _
-}
-- cata
sem_Rule :: Rule ->
            T_Rule
sem_Rule (Rule _pattern _rhs _owrt _origin) =
    (sem_Rule_Rule (sem_Pattern _pattern) _rhs _owrt _origin)
-- semantic domain
newtype T_Rule = T_Rule (Constructor ->
                         Nonterminal ->
                         Int ->
                         ( Bool,(Set (Name,Name)),(Seq Error),(Set Name),Rule,Rules,Int))
data Inh_Rule = Inh_Rule {con_Inh_Rule :: Constructor,nt_Inh_Rule :: Nonterminal,uniq_Inh_Rule :: Int}
data Syn_Rule = Syn_Rule {containsVars_Syn_Rule :: Bool,definedAttrs_Syn_Rule :: Set (Name,Name),errors_Syn_Rule :: Seq Error,locals_Syn_Rule :: Set Name,output_Syn_Rule :: Rule,outputs_Syn_Rule :: Rules,uniq_Syn_Rule :: Int}
wrap_Rule (T_Rule sem) (Inh_Rule _lhsIcon _lhsInt _lhsIuniq) =
    (let ( _lhsOcontainsVars,_lhsOdefinedAttrs,_lhsOerrors,_lhsOlocals,_lhsOoutput,_lhsOoutputs,_lhsOuniq) =
             (sem _lhsIcon _lhsInt _lhsIuniq)
     in  (Syn_Rule _lhsOcontainsVars _lhsOdefinedAttrs _lhsOerrors _lhsOlocals _lhsOoutput _lhsOoutputs _lhsOuniq))
sem_Rule_Rule :: T_Pattern ->
                 Expression ->
                 Bool ->
                 String ->
                 T_Rule
sem_Rule_Rule (T_Pattern pattern_) rhs_ owrt_ origin_ =
    (T_Rule (\ _lhsIcon
               _lhsInt
               _lhsIuniq ->
                 (let __tup2 :: ((Rules,Int))
                      _lhsOoutputs :: Rules
                      _lhsOuniq :: Int
                      _lhsOcontainsVars :: Bool
                      _lhsOdefinedAttrs :: (Set (Name,Name))
                      _lhsOerrors :: (Seq Error)
                      _lhsOlocals :: (Set Name)
                      _lhsOoutput :: Rule
                      _patternOcon :: Constructor
                      _patternOnt :: Nonterminal
                      _patternIcontainsVars :: Bool
                      _patternIcopy :: Pattern
                      _patternIdefinedAttrs :: (Set (Name,Name))
                      _patternIerrors :: (Seq Error)
                      _patternIlocals :: (Set Name)
                      _patternIoutput :: Pattern
                      -- "DefaultRules.ag"(line 420, column 11)
                      __tup2 =
                          multiRule _output     _lhsIuniq
                      -- "DefaultRules.ag"(line 420, column 11)
                      (_lhsOoutputs,_) =
                          __tup2
                      -- "DefaultRules.ag"(line 420, column 11)
                      (_,_lhsOuniq) =
                          __tup2
                      -- use rule "DefaultRules.ag"(line 391, column 46)
                      _lhsOcontainsVars =
                          _patternIcontainsVars
                      -- use rule "DefaultRules.ag"(line 371, column 23)
                      _lhsOdefinedAttrs =
                          _patternIdefinedAttrs
                      -- use rule "DefaultRules.ag"(line 107, column 19)
                      _lhsOerrors =
                          _patternIerrors
                      -- use rule "DefaultRules.ag"(line 370, column 23)
                      _lhsOlocals =
                          _patternIlocals
                      -- self rule
                      _output =
                          Rule _patternIoutput rhs_ owrt_ origin_
                      -- self rule
                      _lhsOoutput =
                          _output
                      -- copy rule (down)
                      _patternOcon =
                          _lhsIcon
                      -- copy rule (down)
                      _patternOnt =
                          _lhsInt
                      ( _patternIcontainsVars,_patternIcopy,_patternIdefinedAttrs,_patternIerrors,_patternIlocals,_patternIoutput) =
                          (pattern_ _patternOcon _patternOnt)
                  in  ( _lhsOcontainsVars,_lhsOdefinedAttrs,_lhsOerrors,_lhsOlocals,_lhsOoutput,_lhsOoutputs,_lhsOuniq))))
-- Rules -------------------------------------------------------
{-
   visit 0:
      inherited attributes:
         con                  : Constructor
         nt                   : Nonterminal
      chained attribute:
         uniq                 : Int
      synthesized attributes:
         definedAttrs         : Set (Name,Name)
         errors               : Seq Error
         locals               : Set Name
         output               : SELF
   alternatives:
      alternative Cons:
         child hd             : Rule
         child tl             : Rules
         visit 0:
            local output      : _
      alternative Nil:
         visit 0:
            local output      : _
-}
-- cata
sem_Rules :: Rules ->
             T_Rules
sem_Rules list =
    (Prelude.foldr sem_Rules_Cons sem_Rules_Nil (Prelude.map sem_Rule list))
-- semantic domain
newtype T_Rules = T_Rules (Constructor ->
                           Nonterminal ->
                           Int ->
                           ( (Set (Name,Name)),(Seq Error),(Set Name),Rules,Int))
data Inh_Rules = Inh_Rules {con_Inh_Rules :: Constructor,nt_Inh_Rules :: Nonterminal,uniq_Inh_Rules :: Int}
data Syn_Rules = Syn_Rules {definedAttrs_Syn_Rules :: Set (Name,Name),errors_Syn_Rules :: Seq Error,locals_Syn_Rules :: Set Name,output_Syn_Rules :: Rules,uniq_Syn_Rules :: Int}
wrap_Rules (T_Rules sem) (Inh_Rules _lhsIcon _lhsInt _lhsIuniq) =
    (let ( _lhsOdefinedAttrs,_lhsOerrors,_lhsOlocals,_lhsOoutput,_lhsOuniq) =
             (sem _lhsIcon _lhsInt _lhsIuniq)
     in  (Syn_Rules _lhsOdefinedAttrs _lhsOerrors _lhsOlocals _lhsOoutput _lhsOuniq))
sem_Rules_Cons :: T_Rule ->
                  T_Rules ->
                  T_Rules
sem_Rules_Cons (T_Rule hd_) (T_Rules tl_) =
    (T_Rules (\ _lhsIcon
                _lhsInt
                _lhsIuniq ->
                  (let _lhsOoutput :: Rules
                       _lhsOdefinedAttrs :: (Set (Name,Name))
                       _lhsOerrors :: (Seq Error)
                       _lhsOlocals :: (Set Name)
                       _lhsOuniq :: Int
                       _hdOcon :: Constructor
                       _hdOnt :: Nonterminal
                       _hdOuniq :: Int
                       _tlOcon :: Constructor
                       _tlOnt :: Nonterminal
                       _tlOuniq :: Int
                       _hdIcontainsVars :: Bool
                       _hdIdefinedAttrs :: (Set (Name,Name))
                       _hdIerrors :: (Seq Error)
                       _hdIlocals :: (Set Name)
                       _hdIoutput :: Rule
                       _hdIoutputs :: Rules
                       _hdIuniq :: Int
                       _tlIdefinedAttrs :: (Set (Name,Name))
                       _tlIerrors :: (Seq Error)
                       _tlIlocals :: (Set Name)
                       _tlIoutput :: Rules
                       _tlIuniq :: Int
                       -- "DefaultRules.ag"(line 416, column 10)
                       _lhsOoutput =
                           if _hdIcontainsVars then _hdIoutputs ++ _tlIoutput else _tlIoutput
                       -- use rule "DefaultRules.ag"(line 371, column 23)
                       _lhsOdefinedAttrs =
                           _hdIdefinedAttrs `Set.union` _tlIdefinedAttrs
                       -- use rule "DefaultRules.ag"(line 107, column 19)
                       _lhsOerrors =
                           _hdIerrors Seq.<> _tlIerrors
                       -- use rule "DefaultRules.ag"(line 370, column 23)
                       _lhsOlocals =
                           _hdIlocals `Set.union` _tlIlocals
                       -- self rule
                       _output =
                           (:) _hdIoutput _tlIoutput
                       -- copy rule (up)
                       _lhsOuniq =
                           _tlIuniq
                       -- copy rule (down)
                       _hdOcon =
                           _lhsIcon
                       -- copy rule (down)
                       _hdOnt =
                           _lhsInt
                       -- copy rule (down)
                       _hdOuniq =
                           _lhsIuniq
                       -- copy rule (down)
                       _tlOcon =
                           _lhsIcon
                       -- copy rule (down)
                       _tlOnt =
                           _lhsInt
                       -- copy rule (chain)
                       _tlOuniq =
                           _hdIuniq
                       ( _hdIcontainsVars,_hdIdefinedAttrs,_hdIerrors,_hdIlocals,_hdIoutput,_hdIoutputs,_hdIuniq) =
                           (hd_ _hdOcon _hdOnt _hdOuniq)
                       ( _tlIdefinedAttrs,_tlIerrors,_tlIlocals,_tlIoutput,_tlIuniq) =
                           (tl_ _tlOcon _tlOnt _tlOuniq)
                   in  ( _lhsOdefinedAttrs,_lhsOerrors,_lhsOlocals,_lhsOoutput,_lhsOuniq))))
sem_Rules_Nil :: T_Rules
sem_Rules_Nil  =
    (T_Rules (\ _lhsIcon
                _lhsInt
                _lhsIuniq ->
                  (let _lhsOdefinedAttrs :: (Set (Name,Name))
                       _lhsOerrors :: (Seq Error)
                       _lhsOlocals :: (Set Name)
                       _lhsOoutput :: Rules
                       _lhsOuniq :: Int
                       -- use rule "DefaultRules.ag"(line 371, column 23)
                       _lhsOdefinedAttrs =
                           Set.empty
                       -- use rule "DefaultRules.ag"(line 107, column 19)
                       _lhsOerrors =
                           Seq.empty
                       -- use rule "DefaultRules.ag"(line 370, column 23)
                       _lhsOlocals =
                           Set.empty
                       -- self rule
                       _output =
                           []
                       -- self rule
                       _lhsOoutput =
                           _output
                       -- copy rule (chain)
                       _lhsOuniq =
                           _lhsIuniq
                   in  ( _lhsOdefinedAttrs,_lhsOerrors,_lhsOlocals,_lhsOoutput,_lhsOuniq))))
-- TypeSig -----------------------------------------------------
{-
   visit 0:
      synthesized attribute:
         output               : SELF
   alternatives:
      alternative TypeSig:
         child name           : {Name}
         child tp             : {Type}
         visit 0:
            local output      : _
-}
-- cata
sem_TypeSig :: TypeSig ->
               T_TypeSig
sem_TypeSig (TypeSig _name _tp) =
    (sem_TypeSig_TypeSig _name _tp)
-- semantic domain
newtype T_TypeSig = T_TypeSig (( TypeSig))
data Inh_TypeSig = Inh_TypeSig {}
data Syn_TypeSig = Syn_TypeSig {output_Syn_TypeSig :: TypeSig}
wrap_TypeSig (T_TypeSig sem) (Inh_TypeSig ) =
    (let ( _lhsOoutput) =
             (sem )
     in  (Syn_TypeSig _lhsOoutput))
sem_TypeSig_TypeSig :: Name ->
                       Type ->
                       T_TypeSig
sem_TypeSig_TypeSig name_ tp_ =
    (T_TypeSig (let _lhsOoutput :: TypeSig
                    -- self rule
                    _output =
                        TypeSig name_ tp_
                    -- self rule
                    _lhsOoutput =
                        _output
                in  ( _lhsOoutput)))
-- TypeSigs ----------------------------------------------------
{-
   visit 0:
      synthesized attribute:
         output               : SELF
   alternatives:
      alternative Cons:
         child hd             : TypeSig
         child tl             : TypeSigs
         visit 0:
            local output      : _
      alternative Nil:
         visit 0:
            local output      : _
-}
-- cata
sem_TypeSigs :: TypeSigs ->
                T_TypeSigs
sem_TypeSigs list =
    (Prelude.foldr sem_TypeSigs_Cons sem_TypeSigs_Nil (Prelude.map sem_TypeSig list))
-- semantic domain
newtype T_TypeSigs = T_TypeSigs (( TypeSigs))
data Inh_TypeSigs = Inh_TypeSigs {}
data Syn_TypeSigs = Syn_TypeSigs {output_Syn_TypeSigs :: TypeSigs}
wrap_TypeSigs (T_TypeSigs sem) (Inh_TypeSigs ) =
    (let ( _lhsOoutput) =
             (sem )
     in  (Syn_TypeSigs _lhsOoutput))
sem_TypeSigs_Cons :: T_TypeSig ->
                     T_TypeSigs ->
                     T_TypeSigs
sem_TypeSigs_Cons (T_TypeSig hd_) (T_TypeSigs tl_) =
    (T_TypeSigs (let _lhsOoutput :: TypeSigs
                     _hdIoutput :: TypeSig
                     _tlIoutput :: TypeSigs
                     -- self rule
                     _output =
                         (:) _hdIoutput _tlIoutput
                     -- self rule
                     _lhsOoutput =
                         _output
                     ( _hdIoutput) =
                         (hd_ )
                     ( _tlIoutput) =
                         (tl_ )
                 in  ( _lhsOoutput)))
sem_TypeSigs_Nil :: T_TypeSigs
sem_TypeSigs_Nil  =
    (T_TypeSigs (let _lhsOoutput :: TypeSigs
                     -- self rule
                     _output =
                         []
                     -- self rule
                     _lhsOoutput =
                         _output
                 in  ( _lhsOoutput)))
