/* valacreationmethod.vala
 *
 * Copyright (C) 2007  Raffaele Sandrini, Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 *	Raffaele Sandrini <rasa@gmx.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valacreationmethod.h>
#include <vala/valasourcereference.h>
#include <vala/valavoidtype.h>
#include <vala/valasymbol.h>
#include <vala/valacodevisitor.h>
#include <vala/valaformalparameter.h>
#include <vala/valadatatype.h>
#include <vala/valablock.h>
#include <vala/valatypesymbol.h>

struct _ValaCreationMethodPrivate {
	char* _type_name;
	gint _n_construction_params;
};
#define VALA_CREATION_METHOD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CREATION_METHOD, ValaCreationMethodPrivate))
enum  {
	VALA_CREATION_METHOD_DUMMY_PROPERTY,
	VALA_CREATION_METHOD_TYPE_NAME,
	VALA_CREATION_METHOD_N_CONSTRUCTION_PARAMS
};
static void vala_creation_method_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_creation_method_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static char* vala_creation_method_real_get_default_cname (ValaMethod* base);
static gpointer vala_creation_method_parent_class = NULL;
static void vala_creation_method_dispose (GObject * obj);


/**
 * Creates a new method.
 *
 * @param name             method name
 * @param source_reference reference to source code
 * @return                 newly created method
 */
ValaCreationMethod* vala_creation_method_new (const char* type_name, const char* name, ValaSourceReference* source_reference) {
	ValaCreationMethod * self;
	ValaVoidType* _tmp0;
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	self = g_object_newv (VALA_TYPE_CREATION_METHOD, 0, NULL);
	_tmp0 = NULL;
	vala_method_set_return_type (VALA_METHOD (self), VALA_DATA_TYPE ((_tmp0 = vala_void_type_new ())));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	vala_creation_method_set_type_name (self, type_name);
	vala_symbol_set_name (VALA_SYMBOL (self), name);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	return self;
}


static void vala_creation_method_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaCreationMethod * self;
	self = VALA_CREATION_METHOD (base);
	g_return_if_fail (visitor == NULL || VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_creation_method (visitor, self);
}


static void vala_creation_method_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaCreationMethod * self;
	self = VALA_CREATION_METHOD (base);
	g_return_if_fail (visitor == NULL || VALA_IS_CODE_VISITOR (visitor));
	{
		GeeCollection* param_collection;
		GeeIterator* param_it;
		param_collection = vala_method_get_parameters (VALA_METHOD (self));
		param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			param = gee_iterator_get (param_it);
			{
				vala_code_node_accept (VALA_CODE_NODE (param), visitor);
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
		(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
	}
	{
		GeeCollection* error_domain_collection;
		GeeIterator* error_domain_it;
		error_domain_collection = vala_method_get_error_domains (VALA_METHOD (self));
		error_domain_it = gee_iterable_iterator (GEE_ITERABLE (error_domain_collection));
		while (gee_iterator_next (error_domain_it)) {
			ValaDataType* error_domain;
			error_domain = gee_iterator_get (error_domain_it);
			{
				vala_code_node_accept (VALA_CODE_NODE (error_domain), visitor);
				(error_domain == NULL ? NULL : (error_domain = (g_object_unref (error_domain), NULL)));
			}
		}
		(error_domain_collection == NULL ? NULL : (error_domain_collection = (g_object_unref (error_domain_collection), NULL)));
		(error_domain_it == NULL ? NULL : (error_domain_it = (g_object_unref (error_domain_it), NULL)));
	}
	if (vala_method_get_body (VALA_METHOD (self)) != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (vala_method_get_body (VALA_METHOD (self))), visitor);
	}
}


static char* vala_creation_method_real_get_default_cname (ValaMethod* base) {
	ValaCreationMethod * self;
	ValaSymbol* _tmp0;
	ValaSymbol* parent;
	self = VALA_CREATION_METHOD (base);
	_tmp0 = NULL;
	parent = (_tmp0 = vala_symbol_get_parent_symbol (VALA_SYMBOL (self)), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	g_assert (VALA_IS_TYPESYMBOL (parent));
	if (g_utf8_strlen (vala_symbol_get_name (VALA_SYMBOL (self)), -1) == g_utf8_strlen (".new", -1)) {
		char* _tmp1;
		char* _tmp2;
		char* _tmp3;
		_tmp1 = NULL;
		_tmp2 = NULL;
		_tmp3 = NULL;
		return (_tmp3 = (_tmp2 = g_strdup_printf ("%snew", (_tmp1 = vala_symbol_get_lower_case_cprefix (VALA_SYMBOL ((VALA_TYPESYMBOL (parent)))))), (_tmp1 = (g_free (_tmp1), NULL)), _tmp2), (parent == NULL ? NULL : (parent = (g_object_unref (parent), NULL))), _tmp3);
	} else {
		char* _tmp4;
		char* _tmp5;
		char* _tmp6;
		_tmp4 = NULL;
		_tmp5 = NULL;
		_tmp6 = NULL;
		return (_tmp6 = (_tmp5 = g_strdup_printf ("%snew_%s", (_tmp4 = vala_symbol_get_lower_case_cprefix (VALA_SYMBOL ((VALA_TYPESYMBOL (parent))))), g_utf8_offset_to_pointer (vala_symbol_get_name (VALA_SYMBOL (self)), g_utf8_strlen (".new.", -1))), (_tmp4 = (g_free (_tmp4), NULL)), _tmp5), (parent == NULL ? NULL : (parent = (g_object_unref (parent), NULL))), _tmp6);
	}
	(parent == NULL ? NULL : (parent = (g_object_unref (parent), NULL)));
}


char* vala_creation_method_get_type_name (ValaCreationMethod* self) {
	g_return_val_if_fail (VALA_IS_CREATION_METHOD (self), NULL);
	return self->priv->_type_name;
}


void vala_creation_method_set_type_name (ValaCreationMethod* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (VALA_IS_CREATION_METHOD (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_type_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_type_name = (g_free (self->priv->_type_name), NULL)), _tmp2);
}


gint vala_creation_method_get_n_construction_params (ValaCreationMethod* self) {
	g_return_val_if_fail (VALA_IS_CREATION_METHOD (self), 0);
	return self->priv->_n_construction_params;
}


void vala_creation_method_set_n_construction_params (ValaCreationMethod* self, gint value) {
	g_return_if_fail (VALA_IS_CREATION_METHOD (self));
	self->priv->_n_construction_params = value;
}


static void vala_creation_method_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCreationMethod * self;
	self = VALA_CREATION_METHOD (object);
	switch (property_id) {
		case VALA_CREATION_METHOD_TYPE_NAME:
		g_value_set_string (value, vala_creation_method_get_type_name (self));
		break;
		case VALA_CREATION_METHOD_N_CONSTRUCTION_PARAMS:
		g_value_set_int (value, vala_creation_method_get_n_construction_params (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_creation_method_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCreationMethod * self;
	self = VALA_CREATION_METHOD (object);
	switch (property_id) {
		case VALA_CREATION_METHOD_TYPE_NAME:
		vala_creation_method_set_type_name (self, g_value_get_string (value));
		break;
		case VALA_CREATION_METHOD_N_CONSTRUCTION_PARAMS:
		vala_creation_method_set_n_construction_params (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_creation_method_class_init (ValaCreationMethodClass * klass) {
	vala_creation_method_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCreationMethodPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_creation_method_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_creation_method_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_creation_method_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_creation_method_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_creation_method_real_accept_children;
	VALA_METHOD_CLASS (klass)->get_default_cname = vala_creation_method_real_get_default_cname;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CREATION_METHOD_TYPE_NAME, g_param_spec_string ("type-name", "type-name", "type-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CREATION_METHOD_N_CONSTRUCTION_PARAMS, g_param_spec_int ("n-construction-params", "n-construction-params", "n-construction-params", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_creation_method_init (ValaCreationMethod * self) {
	self->priv = VALA_CREATION_METHOD_GET_PRIVATE (self);
}


static void vala_creation_method_dispose (GObject * obj) {
	ValaCreationMethod * self;
	self = VALA_CREATION_METHOD (obj);
	(self->priv->_type_name = (g_free (self->priv->_type_name), NULL));
	G_OBJECT_CLASS (vala_creation_method_parent_class)->dispose (obj);
}


GType vala_creation_method_get_type (void) {
	static GType vala_creation_method_type_id = 0;
	if (G_UNLIKELY (vala_creation_method_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCreationMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_creation_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCreationMethod), 0, (GInstanceInitFunc) vala_creation_method_init };
		vala_creation_method_type_id = g_type_register_static (VALA_TYPE_METHOD, "ValaCreationMethod", &g_define_type_info, 0);
	}
	return vala_creation_method_type_id;
}




