/* valadelegatetype.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

using GLib;
using Gee;

/**
 * The type of an instance of a delegate.
 */
public class Vala.DelegateType : DataType {
	public Delegate delegate_symbol { get; set; }

	public DelegateType (construct Delegate delegate_symbol) {
	}

	public override bool is_invokable () {
		return true;
	}

	public override DataType get_return_type () {
		return delegate_symbol.return_type;
	}

	public override Collection<FormalParameter> get_parameters () {
		return delegate_symbol.get_parameters ();
	}

	public override string! to_string () {
		return delegate_symbol.get_full_name ();
	}

	public override DataType! copy () {
		return new DelegateType (delegate_symbol);
	}

	public override string get_cname (bool var_type = false, bool const_type = false) {
		return delegate_symbol.get_cname (const_type);
	}
}
