/* valaforeachstatement.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALAFOREACHSTATEMENT_H__
#define __VALA_VALAFOREACHSTATEMENT_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valablock.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_FOREACH_STATEMENT (vala_foreach_statement_get_type ())
#define VALA_FOREACH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatement))
#define VALA_FOREACH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatementClass))
#define VALA_IS_FOREACH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FOREACH_STATEMENT))
#define VALA_IS_FOREACH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FOREACH_STATEMENT))
#define VALA_FOREACH_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatementClass))

typedef struct _ValaForeachStatementPrivate ValaForeachStatementPrivate;

/**
 * Represents a foreach statement in the source code. Foreach statements iterate
 * over the elements of a collection.
 */
struct _ValaForeachStatement {
	ValaBlock parent_instance;
	ValaForeachStatementPrivate * priv;
};
struct _ValaForeachStatementClass {
	ValaBlockClass parent_class;
};

ValaForeachStatement* vala_foreach_statement_new (ValaDataType* type_reference, const char* variable_name, ValaExpression* collection, ValaBlock* body, ValaSourceReference* source_reference);
ValaDataType* vala_foreach_statement_get_type_reference (ValaForeachStatement* self);
void vala_foreach_statement_set_type_reference (ValaForeachStatement* self, ValaDataType* value);
char* vala_foreach_statement_get_variable_name (ValaForeachStatement* self);
void vala_foreach_statement_set_variable_name (ValaForeachStatement* self, const char* value);
ValaExpression* vala_foreach_statement_get_collection (ValaForeachStatement* self);
void vala_foreach_statement_set_collection (ValaForeachStatement* self, ValaExpression* value);
ValaBlock* vala_foreach_statement_get_body (ValaForeachStatement* self);
void vala_foreach_statement_set_body (ValaForeachStatement* self, ValaBlock* value);
ValaVariableDeclarator* vala_foreach_statement_get_variable_declarator (ValaForeachStatement* self);
void vala_foreach_statement_set_variable_declarator (ValaForeachStatement* self, ValaVariableDeclarator* value);
ValaVariableDeclarator* vala_foreach_statement_get_collection_variable_declarator (ValaForeachStatement* self);
void vala_foreach_statement_set_collection_variable_declarator (ValaForeachStatement* self, ValaVariableDeclarator* value);
ValaVariableDeclarator* vala_foreach_statement_get_iterator_variable_declarator (ValaForeachStatement* self);
void vala_foreach_statement_set_iterator_variable_declarator (ValaForeachStatement* self, ValaVariableDeclarator* value);
GType vala_foreach_statement_get_type (void);

G_END_DECLS

#endif
