/* valaswitchsection.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALASWITCHSECTION_H__
#define __VALA_VALASWITCHSECTION_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/collection.h>
#include <vala/valablock.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_SWITCH_SECTION (vala_switch_section_get_type ())
#define VALA_SWITCH_SECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SWITCH_SECTION, ValaSwitchSection))
#define VALA_SWITCH_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SWITCH_SECTION, ValaSwitchSectionClass))
#define VALA_IS_SWITCH_SECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SWITCH_SECTION))
#define VALA_IS_SWITCH_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SWITCH_SECTION))
#define VALA_SWITCH_SECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SWITCH_SECTION, ValaSwitchSectionClass))

typedef struct _ValaSwitchSectionPrivate ValaSwitchSectionPrivate;

/**
 * Represents a switch section in the source code.
 */
struct _ValaSwitchSection {
	ValaBlock parent_instance;
	ValaSwitchSectionPrivate * priv;
};
struct _ValaSwitchSectionClass {
	ValaBlockClass parent_class;
};

ValaSwitchSection* vala_switch_section_new (ValaSourceReference* source_reference);
void vala_switch_section_add_label (ValaSwitchSection* self, ValaSwitchLabel* label);
GeeCollection* vala_switch_section_get_labels (ValaSwitchSection* self);
gboolean vala_switch_section_has_default_label (ValaSwitchSection* self);
void vala_switch_section_add_statement (ValaSwitchSection* self, ValaStatement* stmt);
GeeCollection* vala_switch_section_get_statements (ValaSwitchSection* self);
GType vala_switch_section_get_type (void);

G_END_DECLS

#endif
