/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.6
 * August 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
//#define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb2/vdkb_frmlist.h>
#include <vdkb2/vdkb.h>
#include <vdkb2/vdkb_prjman.h>

/* XPM */
static const char *form_xpm[] = {
/* width height num_colors chars_per_pixel */
"    16    16        6            1",
/* colors */
". c #000000",
"# c #000080",
"a c #808080",
"b c #c0c0c0",
"c c #none",
"w c #ffffff",
/* pixels */
"cccccccccccccccc",
"aaaaaaaaaaaaaaaa",
"abbbbbbbbbbbbba.",
"ab############a.", 
"ab######c.c.c.a.",
"abaaaaaaaaaaaaa.",
"abwwwwwwwwwwwwa.",
"abwwwwwwwwwwwwa.",
"abwwwwwwwwwwwwa.",
"abwwwwwwwwwwwwa.",
"abwwwwwwwwwwwwa.",
"abwwwwwwwwwwwwa.",
"abwwwwwwwwwwwwa.",
"aaaaaaaaaaaaaaa.",
"................",
"cccccccccccccccc"
};

// treeview model data
enum
{
  ICON = 0,
  FORMNAME,
  MAX_COL
};

DEFINE_SIGNAL_MAP(VDKBFormListForm,VDKForm)
ON_SIGNAL(formCustomList,select_row_signal,OnformCustomListSelectRow),
ON_SIGNAL(formCustomList,realize_signal,OnformCustomListRealize),
ON_SIGNAL(formCustomList,row_activated_signal,OnformCustomListSelectRow),
ON_SIGNAL(selectButton,clicked_signal,OnformCustomListSelectRow),
ON_SIGNAL(closeButton,clicked_signal,OncloseButtonClick)
END_SIGNAL_MAP

/*
form constructor
*/
VDKBFormListForm::VDKBFormListForm(VDKForm* owner,
				   VDKBProjectManager *prjman,
				   char* title):
	VDKForm(owner,title),prjman(prjman)
{
}

/*
form destructor
*/
VDKBFormListForm::~VDKBFormListForm()
{
}

void
VDKBFormListForm::GUISetup(void)
{
  SetSize(222,295);
  Title = _("VDKBuilder");
  vbox4 = new VDKBox(this,v_box);
  vbox4->SetSize(220,291);
  Add(vbox4,0,1,1,0);
  VDKScrolled* scrolled = new VDKScrolled(this);
  formCustomList = new VDKTreeView(this,NULL,GTK_SELECTION_MULTIPLE);
  scrolled->AddWithoutViewport(formCustomList,l_justify,false,false,0);
  vbox4->Add(scrolled,0,1,1,2);

  separator2 = new VDKSeparator(this,h_separator);
  separator2->SetSize(232,2);
  vbox4->Add(separator2,0,0,0,0);
  hbox5 = new VDKBox(this,h_box);
  hbox5->SetSize(229,27);
  vbox4->Add(hbox5,0,0,0,0);
  hbox5->BorderWidth(0);
  selectButton = new VDKCustomButton(this,_("Edit"));
  hbox5->Add(selectButton,0,1,1,0);
  closeButton = new VDKCustomButton(this,_("Close"));
  closeButton->Relief = (GtkReliefStyle) 0;
  hbox5->Add(closeButton,0,1,1,0);
}

/*
 */
bool 
VDKBFormListForm::OnformCustomListRealize(VDKObject* sender)
{

  // makes model
  GType* types = new GType[MAX_COL];
  VDKTreeViewModel *model = NULL;
  types[0] = GDK_TYPE_PIXBUF;
  types[1] = G_TYPE_STRING;
  formCustomList->Model = (model = new VDKTreeViewModel(types,MAX_COL));
  delete[] types;
  if(model)
    {
      VDKTreeViewColumn* column = NULL;
      column = new VDKTreeViewColumn(formCustomList,ICON,NULL);
      column = new VDKTreeViewColumn(formCustomList,FORMNAME,_("Project forms list"));
    }
  else
    return true;
  // load list with project forms
  VDKBProject* project;
  if(prjman && (project = prjman->Project()) )
    {
      // accesses to prj manager unit list
      UnitListIterator li(project->Units());
      for(;li;li++)
	{
	  char *name,*gui;
	  VDKBUnit* unit = li.current();
	  name = (char*) unit->Name();
	  gui = unit->Gui();
	  if(!access(gui,F_OK))
	    {
	      VDKPixbuf* pixbuf = new VDKPixbuf(this,form_xpm);
	      GtkTreeIter iter;
	      model->AppendBlank(&iter,NULL);
	      model->SetData(&iter, 
		     ICON , pixbuf ? pixbuf->AsGdkPixbuf(): NULL, 
		     FORMNAME, name, -1);
	    }
	}
    }
  gtk_tree_view_set_rules_hint (GTK_TREE_VIEW(formCustomList->WrappedWidget()), TRUE);
  GtkTreeIter iter;
  if(model->Root(&iter))
    formCustomList->SelectNode(&iter);
  return true;
}
/*
form setup
*/
void
VDKBFormListForm::Setup(void)
{
	GUISetup(); // vdkb gui setup
// put your code below here
}

// signal response method 
bool
VDKBFormListForm::OnformCustomListSelectRow(VDKObject* sender)
{
  VDKBProject* project;
  formCustomList->GetSelections();
  if(formCustomList->Selections().size() != 1)
    return true;
  else if(prjman && (project = prjman->Project()) )
    {
      VDKTreeViewModel *model = formCustomList->Model;
      char* cell = model->GetCell(&(formCustomList->Selections()[0]),FORMNAME);
      VDKString name = cell;
      name += ".";
      name += FORM_EXT;
      delete[] cell;
      if(!access((char*) name,F_OK))
	{
	  // create a form parsing .frm file (or raise)
	  VDKBGuiForm* form = prjman->CreateForm((char*) name);
	  // make inspector
	  if(form)
	    {
	      if( !prjman->objInspector)
		{
		  prjman->objInspector = new VDKBObjectInspector(prjman,NULL);
		  prjman->objInspector->Setup();
		  prjman->objInspector->Show(); 
		}
	      else if(prjman->objInspector->Iconized)
		prjman->objInspector->Iconized = false;
	      else
		prjman->objInspector->Raise();
	      prjman->objInspector->LoadTree(form);
	      form->Raise();
	    }
	  // set automa
	  VDKBMainForm* mainform = dynamic_cast<VDKBMainForm*>( Owner());
	  if(mainform)
	    mainform->Automa(automa_edit_form_on); 
	}
      formCustomList->Selections().flush();
      Close();
    }
  return true;
}
// signal response method 
bool
VDKBFormListForm::OnselectButtonClick(VDKObject* sender)
{
return true;
}

// signal response method 
bool
VDKBFormListForm::OncloseButtonClick(VDKObject* sender)
{
Close();
return true;
}
