/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.apache.fop.apps.CommandLine;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.Version;
import org.apache.fop.layout.AreaTree;
import org.apache.fop.layout.Page;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.render.awt.AWTRenderer;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class PrintCommandLine
extends CommandLine {
    public PrintCommandLine(String[] stringArray) {
        super(stringArray);
    }

    public static void main(String[] stringArray) {
        XMLReader xMLReader;
        String string = Version.getVersion();
        MessageHandler.errorln(string);
        if (stringArray.length != 1) {
            MessageHandler.errorln("usage: java [-Dstart=i] [-Dend=i] [-Dcopies=i] [-Deven=true|false] org.apache.fop.apps.PrintCommandLine formatting-object-file");
            System.exit(1);
        }
        if ((xMLReader = CommandLine.createParser()) == null) {
            MessageHandler.errorln("ERROR: Unable to create SAX parser");
            System.exit(1);
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (SAXException sAXException) {
            MessageHandler.errorln("Error in setting up parser feature namespace-prefixes");
            MessageHandler.errorln("You need a parser which supports SAX version 2");
        }
        PrintRenderer printRenderer = new PrintRenderer();
        try {
            Driver driver = new Driver();
            driver.setRenderer(printRenderer);
            driver.addElementMapping("org.apache.fop.fo.StandardElementMapping");
            driver.addElementMapping("org.apache.fop.svg.SVGElementMapping");
            driver.addPropertyList("org.apache.fop.fo.StandardPropertyListMapping");
            driver.addPropertyList("org.apache.fop.svg.SVGPropertyListMapping");
            driver.buildFOTree(xMLReader, CommandLine.fileInputSource(stringArray[0]));
            driver.format();
            driver.render();
        }
        catch (Exception exception) {
            MessageHandler.errorln("FATAL ERROR: " + exception.getMessage());
            System.exit(1);
        }
        int n = PrintRenderer.getIntProperty("copies", 1);
        printRenderer.setCopies(n);
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPageable(printRenderer);
        printerJob.setCopies(n);
        try {
            printerJob.print();
        }
        catch (PrinterException printerException) {
            printerException.printStackTrace();
        }
    }

    static class PrintRenderer
    extends AWTRenderer {
        static int EVEN_AND_ALL = 0;
        static int EVEN = 1;
        static int ODD = 2;
        int startNumber;
        int endNumber;
        int mode;
        int copies;

        PrintRenderer() {
            block2: {
                super(null);
                this.mode = EVEN_AND_ALL;
                this.copies = 1;
                this.startNumber = PrintRenderer.getIntProperty("start", 1) - 1;
                this.endNumber = PrintRenderer.getIntProperty("end", -1);
                this.mode = EVEN_AND_ALL;
                String string = System.getProperty("even");
                if (string == null) break block2;
                try {
                    this.mode = Boolean.valueOf(string) != false ? EVEN : ODD;
                }
                catch (Exception exception) {}
            }
        }

        static int getIntProperty(String string, int n) {
            String string2 = System.getProperty(string);
            if (string2 != null) {
                try {
                    return Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    return n;
                }
            }
            return n;
        }

        private Vector getInvalidPageNumbers() {
            Vector<String> vector = new Vector<String>();
            int n = this.tree.getPages().size();
            int n2 = 0;
            while (n2 < n) {
                boolean bl = true;
                if (n2 < this.startNumber || n2 > this.endNumber) {
                    bl = false;
                } else if (this.mode != EVEN_AND_ALL) {
                    if (this.mode == EVEN && (n2 + 1) % 2 != 0) {
                        bl = false;
                    } else if (this.mode == ODD && (n2 + 1) % 2 != 1) {
                        bl = false;
                    }
                }
                if (!bl) {
                    vector.add(String.valueOf(n2));
                }
                ++n2;
            }
            return vector;
        }

        public void render(AreaTree areaTree, OutputStream outputStream) throws IOException {
            this.tree = areaTree;
            if (this.endNumber == -1) {
                this.endNumber = this.tree.getPages().size();
            }
            Vector vector = this.getInvalidPageNumbers();
            int n = vector.size() - 1;
            while (n > -1) {
                this.tree.getPages().removeElementAt(Integer.parseInt((String)vector.elementAt(n)));
                --n;
            }
        }

        public void renderPage(Page page) {
            this.pageWidth = (int)((float)page.getWidth() / 1000.0f);
            this.pageHeight = (int)((float)page.getHeight() / 1000.0f);
            super.renderPage(page);
        }

        void setCopies(int n) {
            this.copies = n;
            Vector vector = this.tree.getPages();
            int n2 = 1;
            while (n2 < this.copies) {
                this.tree.getPages().addAll(vector);
                ++n2;
            }
        }
    }
}

