/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.TextState;
import org.apache.fop.messaging.MessageHandler;

public class PageNumber
extends FObj {
    FontState fs;
    float red;
    float green;
    float blue;
    int wrapOption;
    int whiteSpaceCollapse;
    TextState ts;

    public PageNumber(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:page-number";
    }

    public Status layout(Area area) throws FOPException {
        String string;
        if (!(area instanceof BlockArea)) {
            MessageHandler.errorln("WARNING: page-number outside block area");
            return new Status(1);
        }
        if (this.marker == -1000) {
            string = this.properties.get("font-family").getString();
            String string2 = this.properties.get("font-style").getString();
            String string3 = this.properties.get("font-weight").getString();
            int n = this.properties.get("font-size").getLength().mvalue();
            int n2 = this.properties.get("font-variant").getEnum();
            this.fs = new FontState(area.getFontInfo(), string, string2, string3, n, n2);
            ColorType colorType = this.properties.get("color").getColorType();
            this.red = colorType.red();
            this.green = colorType.green();
            this.blue = colorType.blue();
            this.wrapOption = this.properties.get("wrap-option").getEnum();
            this.whiteSpaceCollapse = this.properties.get("white-space-collapse").getEnum();
            this.ts = new TextState();
            this.marker = 0;
            String string4 = this.properties.get("id").getString();
            area.getIDReferences().initializeID(string4, area);
        }
        string = Integer.toString(area.getPage().getNumber());
        this.marker = FOText.addText((BlockArea)area, this.fs, this.red, this.green, this.blue, this.wrapOption, null, this.whiteSpaceCollapse, string.toCharArray(), 0, string.length(), this.ts, 1);
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new PageNumber(fObj, propertyList);
        }
    }
}

