/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.analyser;

import java.io.BufferedInputStream;
import java.io.IOException;
import org.apache.fop.image.analyser.AbstractImageReader;

public class BMPReader
extends AbstractImageReader {
    protected static final int BMP_SIG_LENGTH = 26;
    protected byte[] header;

    public String getMimeType() {
        return "image/bmp";
    }

    protected void setDefaultHeader() throws IOException {
        this.header = new byte[26];
        try {
            this.imageStream.mark(27);
            this.imageStream.read(this.header);
            this.imageStream.reset();
        }
        catch (IOException iOException) {
            try {
                this.imageStream.reset();
            }
            catch (IOException iOException2) {}
            throw iOException;
        }
    }

    protected void setDimension() {
        int n = this.header[18] & 0xFF;
        int n2 = this.header[19] & 0xFF;
        int n3 = this.header[20] & 0xFF;
        int n4 = this.header[21] & 0xFF;
        long l = n4 << 24 | n3 << 16 | n2 << 8 | n;
        this.width = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        n = this.header[22] & 0xFF;
        n2 = this.header[23] & 0xFF;
        n3 = this.header[24] & 0xFF;
        n4 = this.header[25] & 0xFF;
        l = n4 << 24 | n3 << 16 | n2 << 8 | n;
        this.height = (int)(l & 0xFFFFFFFFFFFFFFFFL);
    }

    public boolean verifySignature(BufferedInputStream bufferedInputStream) throws IOException {
        boolean bl;
        this.imageStream = bufferedInputStream;
        this.setDefaultHeader();
        boolean bl2 = bl = this.header[0] == 66 && this.header[1] == 77;
        if (bl) {
            this.setDimension();
            return true;
        }
        return false;
    }
}

