/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools.anttasks;

import java.io.File;
import java.io.FileOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.Version;
import org.apache.fop.messaging.MessageHandler;
import org.apache.tools.ant.BuildException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Fop {
    String fofile;
    String pdffile;

    static XMLReader createParser() {
        String string = System.getProperty("org.xml.sax.parser");
        if (string == null) {
            string = "org.apache.xerces.parsers.SAXParser";
        }
        MessageHandler.logln("using SAX parser " + string);
        try {
            return (XMLReader)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            MessageHandler.errorln("Could not find " + string);
        }
        catch (InstantiationException instantiationException) {
            MessageHandler.errorln("Could not instantiate " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            MessageHandler.errorln("Could not access " + string);
        }
        catch (ClassCastException classCastException) {
            MessageHandler.errorln(String.valueOf(string) + " is not a SAX driver");
        }
        return null;
    }

    public void execute() throws BuildException {
        XMLReader xMLReader;
        Driver driver = new Driver();
        driver.setBaseDir(this.fofile);
        boolean bl = false;
        String string = Version.getVersion();
        MessageHandler.logln("=======================\nTask " + string + "\nconverting file " + this.fofile + " to " + this.pdffile);
        if (!new File(this.fofile).exists()) {
            bl = true;
            MessageHandler.errorln("Task Fop - ERROR: Formatting objects file " + this.fofile + " missing.");
        }
        if ((xMLReader = Fop.createParser()) == null) {
            MessageHandler.errorln("Task Fop - ERROR: Unable to create SAX parser");
            bl = true;
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (SAXException sAXException) {
            MessageHandler.errorln("Error in setting up parser feature namespace-prefixes");
            MessageHandler.errorln("You need a parser which supports SAX version 2");
            System.exit(1);
        }
        if (!bl) {
            try {
                driver.setRenderer("org.apache.fop.render.pdf.PDFRenderer", string);
                driver.addElementMapping("org.apache.fop.fo.StandardElementMapping");
                driver.addElementMapping("org.apache.fop.svg.SVGElementMapping");
                driver.addElementMapping("org.apache.fop.extensions.ExtensionElementMapping");
                driver.addPropertyList("org.apache.fop.fo.StandardPropertyListMapping");
                driver.addPropertyList("org.apache.fop.svg.SVGPropertyListMapping");
                driver.addPropertyList("org.apache.fop.extensions.ExtensionPropertyListMapping");
                driver.setOutputStream(new FileOutputStream(this.pdffile));
                driver.buildFOTree(xMLReader, Fop.fileInputSource(this.fofile));
                driver.format();
                driver.render();
            }
            catch (Exception exception) {
                MessageHandler.errorln("Task Fop - FATAL ERROR: " + exception.getMessage());
                System.exit(1);
            }
        }
        MessageHandler.logln("=======================\n");
    }

    protected static InputSource fileInputSource(String string) {
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        String string3 = System.getProperty("file.separator");
        if (string3 != null && string3.length() == 1) {
            string2 = string2.replace(string3.charAt(0), '/');
        }
        if (string2.length() > 0 && string2.charAt(0) != '/') {
            string2 = String.valueOf('/') + string2;
        }
        try {
            return new InputSource(new URL("file", null, string2).toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new Error("unexpected MalformedURLException");
        }
    }

    public void setFofile(String string) {
        this.fofile = string;
    }

    public void setPdffile(String string) {
        this.pdffile = string;
    }
}

