/*
	     Fullscreen & Video Mode support addon to GTK
 */

#ifndef GUIFULLSCREEN_H
#define GUIFULLSCREEN_H


/*
 *	Video Mode Flags:
 */
typedef enum {

	GDK_VIDEO_MODE_DEFAULT		= (1 << 0)

} GdkVideoModeFlags;

/*
 *	Video Mode Info:
 */
typedef struct _GdkVideoModeInfo	GdkVideoModeInfo;
struct _GdkVideoModeInfo {

	GdkVideoModeFlags	flags;

	guint		dotclock;

	gint		viewport_width,
			viewport_height;

	gint		total_width,
			total_height;

	gint		hsyncstart,
			hsyncend;

	gint		vsyncstart,
			vsyncend;
};
#define GDK_VIDEO_MODE_INFO(p)	((GdkVideoModeInfo *)(p))


extern gboolean gdk_video_mode_is_supported(void);

extern GdkVideoModeInfo *gdk_video_mode_new(void);
extern void gdk_video_mode_delete(GdkVideoModeInfo *m);

extern GList *gdk_video_modes_get(void);
extern void gdk_video_modes_delete(GList *glist);

extern GdkVideoModeInfo *gdk_video_mode_get_current(GList *glist);

extern gboolean gdk_video_mode_get_viewport(gint *x_rtn, gint *y_rtn);
extern void gdk_video_mode_set_viewport(gint x, gint y);

extern gboolean gdk_video_mode_switch(const GdkVideoModeInfo *m);


#endif	/* GUIFULLSCREEN_H */
