/*
			     Progress Dialog
 */

#ifndef PROGRESSDIALOG_H
#define PROGRESSDIALOG_H

#include <gtk/gtk.h>


extern gint ProgressDialogInit(void);
extern void ProgressDialogSetStyle(GtkRcStyle *rc_style);
extern void ProgressDialogSetTransientFor(GtkWidget *w);
extern void ProgressDialogSetWMIconData(const guint8 **icon_data);
extern gboolean ProgressDialogIsQuery(void);	/* Checks if mapped */
extern void ProgressDialogBreakQuery(gboolean allow_gtk_iteration);
extern gint ProgressDialogStopCount(void);
extern void ProgressDialogMap(
	const gchar *title,
	const gchar *label,
	const guint8 **icon_data,
	const gchar *stop_btn_label
);
extern void ProgressDialogMapAnimation(
	const gchar *title,
	const gchar *label,
	const gchar *stop_btn_label,
	guint8 ***start_icon_data, gint total_start_icon_datas,
	guint8 ***icon_data, gint total_icon_datas,
	guint8 ***end_icon_data, gint total_end_icon_datas,
	gulong animation_interval,	/* In ms, default is 500 ms */
	guint16 animation_increment	/* Positive value up to (guint16)-1 */
);
extern void ProgressDialogUpdate(
	const gchar *title,
	const gchar *label,
	const guint8 **icon_data,
	const gchar *stop_btn_label,
	gdouble position,		/* 0.0 to 1.0 */
	guint nblocks,			/* 0 for continuous */
	gboolean allow_gtk_iteration
);
extern void ProgressDialogUpdateUnknown(
	const gchar *title,
	const gchar *label,
	const guint8 **icon_data,
	const gchar *stop_btn_label,
	gboolean allow_gtk_iteration
);
extern void ProgressDialogUnmap(void);
extern void ProgressDialogShutdown(void);


#endif	/* PROGRESSDIALOG_H */
