/* -*- C++ -*-
 
  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
*/

#include <SchematicSizeWindow.h>

#include <Setup.h>
#include <Strings.h>
#include <Schematic.h>
#include <SmithView.h>
#include <MainWindow.h>

#include <qlabel.h>
#include <qlayout.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qapplication.h>

#include <iostream>

//----------------------------------------------------------------------------
SchematicSizeWindow::SchematicSizeWindow( QWidget* parent, const char* name )
    : QDialog(parent, name, TRUE),
    topLayout_(0),
    schematicSize_(0),
    name_(0)
{
  setCaption( name );

  topLayout_ = new QVBoxLayout( this );
  QGridLayout* gridLayout = new QGridLayout ( 0 );
  QHBoxLayout* buttonLayout = new QHBoxLayout( 0 );

  topLayout_->addSpacing( 10 );
  topLayout_->addItem( gridLayout );
  topLayout_->addSpacing( 10 );
  topLayout_->addItem( buttonLayout );

  QString okLabel = Strings::translate( Strings::LabelOk );
  QString cancelLabel = Strings::translate( Strings::LabelCancel );
  QPushButton* ok = new QPushButton( okLabel, this );
  QPushButton* cancel = new QPushButton( cancelLabel, this );

  buttonLayout->addWidget( ok );
  buttonLayout->addWidget( cancel );

  connect ( ok, SIGNAL( clicked() ),
            this, SLOT( ok() ) );
  connect ( cancel, SIGNAL( clicked() ),
            this, SLOT( cancel() ) );

  QString sizeLabelText = Strings::translate( Strings::LabelSchematicSize);
  QString smallSizeText = Strings::translate( Strings::LabelSmall);
  QString mediumSizeText = Strings::translate( Strings::LabelMedium);
  QString largeSizeText = Strings::translate( Strings::LabelLarge);

  gridLayout->expand( 4, 2 );
  gridLayout->addColSpacing( 0, 30 );
  gridLayout->addColSpacing( 1, 100 );
  gridLayout->addColSpacing( 2, 10 );
  gridLayout->addColSpacing( 3, 100 );
  gridLayout->addColSpacing( 4, 30 );
  gridLayout->addRowSpacing( 0, 35 );

  QLabel* sizeLabel = new QLabel( sizeLabelText, this );
  schematicSize_ = new QComboBox( this );
  gridLayout->addWidget( sizeLabel, 0, 1 );
  gridLayout->addWidget( schematicSize_, 0, 3 );

  schematicSize_->insertItem( smallSizeText, Schematic::smallSize );
  schematicSize_->insertItem( mediumSizeText, Schematic::mediumSize );
  schematicSize_->insertItem( largeSizeText, Schematic::largeSize );

  resize( topLayout_->sizeHint() );
}

//----------------------------------------------------------------------------
SchematicSizeWindow::~SchematicSizeWindow()
{
  delete topLayout_;
}

//----------------------------------------------------------------------------
void SchematicSizeWindow::setSchematicName( const QString& name )
{
  name_ = name;
}

//----------------------------------------------------------------------------
void SchematicSizeWindow::setSchematicSize( Schematic::SchematicSize size )
{
  schematicSize_->setCurrentItem((int) size);
}

//----------------------------------------------------------------------------
void SchematicSizeWindow::ok()
{
  Schematic::SchematicSize size = (Schematic::SchematicSize)schematicSize_->currentItem();
  MainWindow::instance()->setSchematicSize( name_, size );
  close();
}

//----------------------------------------------------------------------------
void SchematicSizeWindow::cancel()
{
  close();
}

