// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1996
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        tioinetsrc_a.h
// 
// Purpose:     
// 
// Created:     18 Jun 96   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// $Id: tioinetsrc_a.h,v 1.6 1997/02/12 23:13:11 jfasch Exp $
// 
// $Log: tioinetsrc_a.h,v $
// Revision 1.6  1997/02/12 23:13:11  jfasch
// moved from HgDcCommon
//
// Revision 1.5  1997/02/12 22:19:26  jfasch
// made the return value a common TransparentIO, but added
// TIOINETAttributes to it instead.
//
// Revision 1.4  1996/12/18 15:43:00  jfasch
// added the more specific
//    virtual void cancel (const TIOSourceActiveUser_INET*) ;
//
// Revision 1.3  1996/12/12 15:02:13  jfasch
// added the more specific
// TIOSourceActive::Make TIOSourceActive_INET::make (TransparentINETSocketIOPtr&,
//                                                   TIOSourceActiveUser*,
//                                                   TIOSourceActiveUser_INET*) ;
//
// Revision 1.2  1996/07/22  08:18:19  jfasch
// *** empty log message ***
//
// Revision 1.1  1996/07/08 13:16:36  jfasch
// Initial revision
//
// 
// </file> 
#ifndef hg_dispatch_tioinetsrc_a_h
#define hg_dispatch_tioinetsrc_a_h

#include "tif.h"
#include "tioinetattr.h"
#include "tiosrc_a.h"

class TIOSourceActive_INET ;

class TIOSourceActiveUser_INET {
public:
   virtual void tioSrcAINETError (const TIOSourceActive_INET*) = 0 ;
   virtual void tioSrcAINETReady (const TIOSourceActive_INET*, 
                                  const TransparentIOPtr&, const TIOINETAttributes&) = 0 ;
} ;

class TIOSourceActive_INET : public TIOSourceActive, public TIOINETFactoryUser {
public:
   enum { INFINITE_TIMEOUT = -1 } ;

public:
   TIOSourceActive_INET (const INETAddress&, long timeout=INFINITE_TIMEOUT) ;
   virtual ~TIOSourceActive_INET() ;
   
   virtual TIOSourceActive::Make make (TransparentIOPtr&, TIOSourceActiveUser*) ;
   virtual TIOSourceActive::Make make (TransparentIOPtr&, TIOINETAttributes&,
                                       TIOSourceActiveUser*, TIOSourceActiveUser_INET*) ;

   // cancel the whole request. if there are 2 users registered, they
   // will have to talk to each other outside the scope of this class.
   virtual void cancel (const TIOSourceActiveUser*) ;
   virtual void cancel (const TIOSourceActiveUser_INET*) ;

private:
   // TIOINETFactoryUser callback (the only one)
   virtual void tioInetResponse (const TIOINETResponsePtr&) ;

   // utilities
   TIOSourceActive::Make make_(TransparentIOPtr& io, TIOINETAttributes& attr, 
                               TIOSourceActiveUser* u, TIOSourceActiveUser_INET* ui) ;
   void cancel_(const TIOSourceActiveUser*, const TIOSourceActiveUser_INET*) ;

   const INETAddress addr_ ;
   const long timeout_ ;
   
   class TIO_INET_Lookup* requests_ ;

public:
   static const char* version2 ;
} ;
static const char* hg_dc_common_TIOSourceActive_INET_version = TIOSourceActive_INET::version2 ;

SmartPtrdeclare (TIOSourceActive_INETPtr, TIOSourceActive_INET) ;

#endif
