//<copyright>
//
// Copyright (c) 1992
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
// This file is part of VRweb.
//
// VRweb is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// VRweb is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VRweb; see the file LICENCE. If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// Note that the GNU General Public License does not permit incorporating
// the Software into proprietary or commercial programs. Such usage
// requires a separate license from IICM.
//
//</copyright>

/*
 * File    :  memleak.h
 *
 * Author  :  Keith Andrews, IICM, TU Graz, Austria
 *
 * Created :  27 Jan 92
 *
 * Changed :  26 Mar 92
 *
 */





#ifndef memleak_h
#define memleak_h


#ifdef MEMLEAK


#include <stddef.h>

#define New ::new(__FILE__,__LINE__)
#define Delete __debugpos(__FILE__,__LINE__), ::delete


void __debugpos( const char* filename, unsigned line ) ;

void* operator new( size_t size, char* file, unsigned line ) ;
void  operator delete( void* p ) ;

void MemLeakBegin( int verbose = 1 ) ;
void MemLeakEnd() ;

#else

#define New new
#define Delete delete

#endif




#endif
