// -*- C++ -*-

//<copyright>
//
// Copyright (c) 1995,96
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
// This file is part of VRweb.
//
// VRweb is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// VRweb is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VRweb; see the file LICENCE. If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// Note that the GNU General Public License does not permit incorporating
// the Software into proprietary or commercial programs. Such usage
// requires a separate license from IICM.
//
//</copyright>

//<file>
//
// Name:        urlserver.h
//
// Purpose:     server for fetching texture images and inline scenes from the Web
//              fetches URL via HTTP protocol
//              (compare with ImageServer doing the same job with Harmony)
//
// Created:     29 Nov 1995   Michael Pichler
//
// Changed:     23 May 1997   Michael Pichler
//
// $Id: urlserver.h,v 1.7 1997/05/26 17:32:20 mpichler Exp $
//
//</file>



#ifndef harmony_scene_urlserver_h
#define harmony_scene_urlserver_h


#include "slist.h"


class SceneWindow;
class QvTexture2;
class QvWWWInline;
class URLReader;
class URLRequest;



// URLServer
// keeps a list of URL request, which are handled sequentially
// does not contain caching at the moment


class URLServer
{
  public:
    URLServer (                         // constructor
      SceneWindow* scene                //   current scene (non nil)
    );
    ~URLServer ();

    void clearAllRequests ();           // cancel all current requests

    void appendRequest (                // request either WWWInline or Texture2
      QvWWWInline* nodeI,               //   VRML inline node
      QvTexture2* nodeT,                //   texture node
      const char* url,                  //   requested URL (of data to be fetched)
      const char* docurl                //   URL of requesting document (for relative URLs)
    );

    void handleRequests (int texturesalso);  // handle next request

    void readerFinished ();             // current reader finished, handle next request

    static void sendUserAgent (int ua)  // whether User-Agent field shall be sent on requests
    { senduseragent_ = ua; }

    SceneWindow* scene ()  { return scene_; }

  private:
    int handleRequest (URLRequest*);

    SceneWindow* scene_;
    int reqtextures_;
    static int senduseragent_;

    slist inlinerequests_;  // URLRequest*
    slist texturerequests_;  // URLRequest*

    URLReader* activereader_;

}; // URLServer


#endif
