/* vim: set sw=8: -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * vsdump: test program to dump and parse content of vsd file
 *
 * Copyright (C) 2006-2007	Valek Filippov (frob@df.ru)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 3 or later of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 *
 */
#include <gsf/gsf-input.h>
#include "vsdump.h"
#include "vsd_utils.h"
#include "vsd_dump_stream_c.h"

int
vsd_dump_stream_c(GByteArray *decomp, char *dirname, int *numfrgn)
{
		guint j;
		char *tmpstr;
		FILE *fimage;
		
		/* EMF always starts with '01 00 00 00' (RecordType dword)*/
		/* WMF always starts with '01 00 09 00' (FileType and HeaderSize words) */
		if(9 == decomp->data[6]){
			tmpstr = g_strdup_printf ("file%05d.wmf", *numfrgn);
		}else{
			tmpstr = g_strdup_printf ("file%05d.emf", *numfrgn);
		} 
 					
 		fimage = vsd_openfd (dirname, tmpstr);

/* 'Magic numbers'. 4 -- skip header (length of decompressed stream dword) */
		for(j = 4; j < decomp->len; j++){
			fputc(decomp->data[j],fimage);
		}
		(*numfrgn)++;
		fclose(fimage);
		
		return 0;
}
