#include "mapobj.h"
#include "misc.h"

/////////////////////////////////////////////////////////////////
// MapObj
/////////////////////////////////////////////////////////////////
MapObj::MapObj ()
{
	//qWarning ( "Const MapObj (): Please set scene somehow!!!");
	scene=NULL;
    init ();
}

MapObj::MapObj (QGraphicsScene *s)
{
//  cout << "Const MapObj\n";
    scene=s;
    init ();
}


MapObj::MapObj (MapObj* mo)
{
//    cout << "CopyConst MapObj\n";
    copy (mo);
}

MapObj::~MapObj ()
{
//    cout << "Destr MapObj\n";
}

void MapObj::init ()
{
    absPos=QPointF(0,0);
    visible=true;
}

void MapObj::copy(MapObj* other)
{
//    scene=other->scene;	// already set in constr. of child, use that one...
    absPos=other->absPos;
	bbox.setX (other->bbox.x() );
	bbox.setY (other->bbox.y() );
	bbox.setSize (QSizeF(other->bbox.width(), other->bbox.height() ) );
}

QGraphicsScene* MapObj::getScene()
{
	return scene;
}

qreal MapObj::x() 
{
    return absPos.x();
}

qreal MapObj::y() 
{
    return absPos.y();
}

qreal MapObj::width() 
{
    return bbox.width();
}

qreal MapObj::height() 
{
    return bbox.height();
}

QPointF MapObj::getAbsPos() 
{
    return absPos;
}

QString MapObj::getPos()
{
	return qpointfToString(absPos);
}

void MapObj::move (double x, double y) 
{
    absPos.setX( x);
    absPos.setY( y);
    bbox.moveTo(QPointF(x,y));
    clickBox.moveTo(QPointF(x,y));
}

void MapObj::move (QPointF p)
{
	absPos=p;
	bbox.moveTo (p);
	clickBox.moveTo (p);
}

void MapObj::moveBy (double x, double y) 
{
    MapObj::move (x+absPos.x(),y+absPos.y() );
	bbox.moveTo (bbox.x()+x,bbox.y()+y);
	clickBox.moveTo (clickBox.x()+x,clickBox.y()+y);
}

bool MapObj::inBox(const QPointF &p)
{
    if (p.x() >= clickBox.left() && p.x() <= clickBox.right()  
	&& p.y() <= clickBox.bottom() && p.y() >= clickBox.top() )
		return true;
    return false;	
}

QRectF MapObj::getBBox()
{
    return bbox;
}

QRectF MapObj::addBBox(QRectF r1, QRectF r2)
{	
	// Find smallest QRectF containing given rectangles

	QRectF n;
	// Set left border
	if (r1.left() <= r2.left() )
		n.setLeft(r1.left() );
	else
		n.setLeft(r2.left() );
		
	// Set top border		
	if (r1.top() <= r2.top() )
		n.setTop(r1.top() );
	else
		n.setTop(r2.top() );
		
	// Set right border
	if (r1.right() <= r2.right() )
		n.setRight(r2.right() );
	else
		n.setRight(r1.right() );
		
	// Set bottom 
	if (r1.bottom() <= r2.bottom() )
		n.setBottom(r2.bottom() );
	else
		n.setBottom(r1.bottom() );
	return n;
}

QSizeF MapObj::getSize()
{
    return bbox.size();
}


bool MapObj::isVisibleObj()
{
    return visible;
}

void MapObj::setVisibility(bool v)
{
    visible=v;
}

void MapObj::animate()
{
}
