// Displays the page magnifier
function webdeveloper_displayPageMagnifier(element)
{
    var canvas = document.getElementById("webdeveloper-page-magnifier");

    // If the canvas is not set or has no context
    if(!canvas || !canvas.getContext)
    {
        window.openDialog("chrome://webdeveloper/content/message/message.xul", "webdeveloper-message-dialog", "centerscreen,chrome,modal", document.getElementById("webdeveloper-string-bundle").getString("webdeveloper_firefox15Required"));
    }
    else
    {
        var checked       = false;
        var container     = document.getElementById("webdeveloper-page-magnifier-container");

        // If the element is set
        if(element)
        {
            checked = element.getAttribute("checked");
        }

        webdeveloper_configureElement(document.getElementById("webdeveloper-page-magnifier-toolbar"), "hidden", !checked);

        // If displaying page validation
        if(checked)
        {
            var browserBoxObject = webdeveloper_getSelectedBrowser().boxObject;

            document.getElementById("webdeveloper.magnification.level").value = webdeveloper_getStringPreference("webdeveloper.magnification.level", true);
            webdeveloper_updatePageMagnifier(0, 0);

            container.addEventListener("DOMMouseScroll", webdeveloper_scrollPageMagnifier, true);
            window.addEventListener("mousemove", webdeveloper_movePageMagnifier, false);

            container.style.left = (browserBoxObject.x + 10) + "px";
            container.style.top  = (browserBoxObject.y + 10) + "px";
            container.hidden     = false;
        }
        else
        {
            // Try to remove the event listener
            try
            {
                container.removeEventListener("DOMMouseScroll", webdeveloper_scrollPageMagnifier, true);
            }
            catch(exception)
            {
                // Do nothing
            }

            // Try to remove the event listener
            try
            {
                window.removeEventListener("mousemove", webdeveloper_movePageMagnifier, false);
            }
            catch(exception)
            {
                // Do nothing
            }

            container.hidden = true;
        }

        webdeveloper_toggleAppliedStyle(element, "webdeveloper-display-page-magnifier");
    }
}

// Called when the page magnifier is moved
function webdeveloper_movePageMagnifier(event)
{
    var canvas      = document.getElementById("webdeveloper-page-magnifier");
    var eventTarget = event.target;

    // If the canvas and event target are set and the canvas is the event target
    if(canvas && eventTarget && canvas == eventTarget)
    {
        var container = document.getElementById("webdeveloper-page-magnifier-container");

        // If the container is set
        if(container)
        {
            var browserBoxObject   = webdeveloper_getSelectedBrowser().boxObject;
            var browserXPosition   = browserBoxObject.x;
            var browserYPosition   = browserBoxObject.y;
            var canvasHalfHeight   = canvas.height / 2;
            var canvasHalfWidth    = canvas.width / 2;
            var containerXPosition = event.clientX - canvasHalfWidth;
            var containerYPosition = event.clientY - canvasHalfHeight;
            var documentElement    = webdeveloper_getContentDocument().documentElement;
            var magnificationLevel = parseFloat(webdeveloper_getStringPreference("webdeveloper.magnification.level", true));
            var magnifierXPosition = event.clientX - browserXPosition - (canvasHalfWidth / magnificationLevel) + documentElement.scrollLeft;
            var magnifierYPosition = event.clientY - browserYPosition - (canvasHalfHeight / magnificationLevel) + documentElement.scrollTop;

            // If the container X position is less than the browser X position
            if(containerXPosition < browserXPosition)
            {
                containerXPosition = browserXPosition;
            }

            // If the container Y position is less than the browser Y position
            if(containerYPosition < browserYPosition)
            {
                containerYPosition = browserYPosition;
            }

            // If the magnifier X position is less than 0
            if(magnifierXPosition < 0)
            {
                magnifierXPosition = 0;
            }

            // If the magnifier Y position is less than 0
            if(magnifierYPosition < 0)
            {
                magnifierYPosition = 0;
            }

            container.style.left = containerXPosition + "px";
            container.style.top  = containerYPosition + "px";

            webdeveloper_updatePageMagnifier(magnifierXPosition, magnifierYPosition);
        }
    }
}

// Called when the page magnifier is scrolled with the mouse wheel
function webdeveloper_scrollPageMagnifier(event)
{
    var eventDetail = event.detail;

    // If the event detail is set
    if(eventDetail)
    {
        var magnificationLevel = parseFloat(webdeveloper_getStringPreference("webdeveloper.magnification.level", true));

        // If the event detail is greater than zero (scroll down)
        if(eventDetail > 0)
        {
            // If the magnification level is greater than one
            if(magnificationLevel > 1)
            {
                magnificationLevel -= 1;
            }
        }
        else
        {
            magnificationLevel += 1;
        }

        document.getElementById("webdeveloper.magnification.level").value = magnificationLevel;

        webdeveloper_setStringPreference("webdeveloper.magnification.level", magnificationLevel);
        webdeveloper_updatePageMagnifier(0, 0);

        event.stopPropagation();
        event.preventDefault();
    }
}

// Updates the magnification level
function webdeveloper_updateMagnificationLevel(element)
{
    var magnificationLevel = element.value;
    var stringBundle       = document.getElementById("webdeveloper-string-bundle");

    // If the magnification level is empty or not a number or less than zero
    if(!magnificationLevel || parseFloat(magnificationLevel) != magnificationLevel || magnificationLevel <= 0)
    {
        webdeveloper_error(stringBundle.getString("webdeveloper_invalidWidth"));
    }
    else
    {
        webdeveloper_setStringPreference("webdeveloper.magnification.level", magnificationLevel);
        webdeveloper_updatePageMagnifier(0, 0);
    }
}

// Updates the page magnifier
function webdeveloper_updatePageMagnifier(xPosition, yPosition)
{
    var canvas = document.getElementById("webdeveloper-page-magnifier");

    // If the canvas was found
    if(canvas)
    {
        var context            = canvas.getContext("2d");
        var height             = canvas.height;
        var magnificationLevel = parseFloat(webdeveloper_getStringPreference("webdeveloper.magnification.level", true));
        var width              = canvas.width;

        context.save();
        context.scale(magnificationLevel, magnificationLevel);
        context.drawWindow(webdeveloper_getContentWindow(), xPosition, yPosition, (xPosition + width) / magnificationLevel, (yPosition + height) / magnificationLevel, "rgb(255, 255, 255)");
        context.restore();
    }
}