// Outlines all block level element names
function webdeveloper_outlineBlockLevelElementNames(element)
{
    webdeveloper_removeStyleSheet("webdeveloper-outline-block-level-elements-before");
    webdeveloper_removeStyleSheet("webdeveloper-outline-block-level-elements-before-tooltips");

    // If the show outlined element names preference is set
    if(webdeveloper_getBooleanPreference("webdeveloper.outline.show.element.names", true))
    {
        webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_block_level_elements_before.css", "webdeveloper-outline-block-level-elements-before");
        webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-outline-block-level-elements-before-tooltips", "*:before");
    }
}

// Outlines all block level elements
function webdeveloper_outlineBlockLevelElements(element)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_block_level_elements.css", "webdeveloper-outline-block-level-elements");
    webdeveloper_outlineBlockLevelElementNames(element);
}

// Outlines the current element
function webdeveloper_outlineCurrentElement(element)
{
    var checked        = element.getAttribute("checked");
    var documentList   = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength = documentList.length;
    var pageDocument   = null;

    webdeveloper_configureElement(document.getElementById("webdeveloper-information-text-toolbar"), "hidden", !checked);

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument = documentList[i];

        // If outlining the element
        if(checked)
        {
            pageDocument.addEventListener("keypress", webdeveloper_outlineCurrentElementKeyPress, false);
            pageDocument.addEventListener("mousemove", webdeveloper_outlineCurrentElementMouseMove, false);
            pageDocument.addEventListener("mouseover", webdeveloper_outlineCurrentElementMouseOver, false);
        }
        else
        {
            // Try to remove the event listener
            try
            {
                pageDocument.removeEventListener("keypress", webdeveloper_outlineCurrentElementKeyPress, false);
            }
            catch(exception)
            {
                // Do nothing
            }

            // Try to remove the event listener
            try
            {
                pageDocument.removeEventListener("mousemove", webdeveloper_outlineCurrentElementMouseMove, false);
            }
            catch(exception)
            {
                // Do nothing
            }

            // Try to remove the event listener
            try
            {
                pageDocument.removeEventListener("mouseover", webdeveloper_outlineCurrentElementMouseOver, false);
            }
            catch(exception)
            {
                // Do nothing
            }

            webdeveloper_removeElementOutline(webdeveloper_outlineElement);
        }
    }

    // If not outlining the element
    if(!checked)
    {
        webdeveloper_outlineElement = null;
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_current_element.css", "webdeveloper-outline-current-element");
}

// Keypress event for outline current element
function webdeveloper_outlineCurrentElementKeyPress(event)
{
    webdeveloper_copyElementAncestors(event);
}

// Mouseover event for outline current element
function webdeveloper_outlineCurrentElementMouseMove(event)
{
    var outlineElement = webdeveloper_addElementOutline(event, webdeveloper_outlineElement);

    // If the outline element is set
    if(outlineElement)
    {
        webdeveloper_outlineElement = outlineElement;
    }
}

// Mouseover event for outline current element
function webdeveloper_outlineCurrentElementMouseOver(event)
{
    webdeveloper_displayElementAncestors(event);
}

// Outlines the given element
function webdeveloper_outlineCustomElements(element)
{
    webdeveloper_outlinedElements = new Array();

    // If the menu is checked
    if(element.getAttribute("checked"))
    {
        window.openDialog("chrome://webdeveloper/content/dialogs/outline_elements.xul", "webdeveloper-outline-elements-dialog", "centerscreen,chrome,modal", webdeveloper_outlinedElements);

        // If the user clicked cancel in the dialog
        if(webdeveloper_outlinedElements.length == 0)
        {
           element.removeAttribute("checked");
        }
    }

    webdeveloper_outlineElements(element, true);
}

// Outlines all deprecated element names
function webdeveloper_outlineDeprecatedElementNames(element)
{
    webdeveloper_removeStyleSheet("webdeveloper-outline-deprecated-elements-before");
    webdeveloper_removeStyleSheet("webdeveloper-outline-deprecated-elements-before-tooltips");

    // If the show outlined element names preference is set
    if(webdeveloper_getBooleanPreference("webdeveloper.outline.show.element.names", true))
    {
        webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_deprecated_elements_before.css", "webdeveloper-outline-deprecated-elements-before");
        webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-outline-deprecated-elements-before-tooltips", "*:before");
    }
}

// Outlines all deprecated elements
function webdeveloper_outlineDeprecatedElements(element)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_deprecated_elements.css", "webdeveloper-outline-deprecated-elements");
    webdeveloper_outlineDeprecatedElementNames(element);
}

// Outlines the given element
function webdeveloper_outlineElements(element)
{
    // If the menu is checked
    if(element.getAttribute("checked") && webdeveloper_outlinedElements.length > 0)
    {
        var documentList             = webdeveloper_getDocuments(webdeveloper_getContentWindow());
        var documentLength           = documentList.length;
        var outlineColor             = null;
        var outlineColorPreference   = null;
        var outlineElement           = null;
        var outlineElementLength     = null;
        var outlineElementList       = null;
        var outlineElementPreference = null;
        var outlineElementValue      = null;
        var pageDocument             = null;
        var styleElement             = null;

        // Loop through the documents
        for(var i = 0; i < documentLength; i++)
        {
            pageDocument = documentList[i];
            styleElement = pageDocument.createElement("style");

            styleElement.setAttribute("id", "webdeveloper-outline-custom-elements");
            styleElement.setAttribute("type", "text/css");

            // Loop through outline colors and elements
            for(var j = 0; j <= 5; j++)
            {
                outlineColor             = "webdeveloper.custom." + j + ".color";
                outlineColorPreference   = webdeveloper_getStringPreference(outlineColor, true);
                outlineElement           = "webdeveloper.custom." + j + ".element";
                outlineElementPreference = webdeveloper_getStringPreference(outlineElement, true);

                // If the color and element are set and not blank
                if(outlineColorPreference && outlineElementPreference)
                {
                    outlineElementList   = outlineElementPreference.split(",");
                    outlineElementLength = outlineElementList.length;

                    // Loop through the elements
                    for(var k = 0; k < outlineElementLength; k++)
                    {
                        outlineElementValue = outlineElementList[k];

                        styleElement.appendChild(pageDocument.createTextNode(outlineElementValue + " { -moz-outline: 1px solid " + outlineColorPreference + " !important; outline: 1px solid " + outlineColorPreference + " !important; }"));

                        // If the show outlined element names preference is set
                        if(webdeveloper_getBooleanPreference("webdeveloper.outline.show.element.names", true))
                        {
                            styleElement.appendChild(pageDocument.createTextNode(outlineElementValue + ":before { content: \"<" + outlineElementValue + ">\" !important; }"));
                        }
                    }
                }
            }

            webdeveloper_getDocumentHeadElement(pageDocument).appendChild(styleElement);
        }

        webdeveloper_addAppliedStyle("webdeveloper-outline-custom-elements");
    }
    else
    {
        webdeveloper_removeStyleSheet("webdeveloper-outline-custom-elements", true);
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/imports/before.css", "webdeveloper-outline-custom-elements-before");
    webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-outline-custom-elements-before-tooltips", "*:before");
}

// Outlines all external links
function webdeveloper_outlineExternalLinks(element)
{
    // If the menu is checked
    if(element.getAttribute("checked"))
    {
        var documentList   = webdeveloper_getDocuments(webdeveloper_getContentWindow());
        var documentLength = documentList.length;
        var location       = null;
        var pageDocument   = null;
        var protocol       = null;
        var styleElement   = null;

        // Loop through the documents
        for(var i = 0; i < documentLength; i++)
        {
            pageDocument    = documentList[i];
            location        = pageDocument.location;
            protocol        = location.protocol.replace(new RegExp(":", "gi"), "\\:");
            styleElement    = pageDocument.createElement("style");

            styleElement.setAttribute("id", "webdeveloper-outline-external-links");
            styleElement.setAttribute("type", "text/css");
            styleElement.appendChild(pageDocument.createTextNode("a:not([href^=" + protocol + "\\/\\/" + location.hostname.replace(new RegExp("\\.", "gi"), "\\.") + "]) { -moz-outline: 1px solid #ff0000 !important; outline: 1px solid #ff0000 !important; }"));
            styleElement.appendChild(pageDocument.createTextNode("a:not([href^=" + protocol + "]) { -moz-outline-style: none !important; outline-style: none !important; }"));

            webdeveloper_getDocumentHeadElement(pageDocument).appendChild(styleElement);
        }

        webdeveloper_addAppliedStyle("webdeveloper-outline-external-links");
    }
    else
    {
        webdeveloper_removeStyleSheet("webdeveloper-outline-external-links", true);
    }
}

// Outlines all floated elements
function webdeveloper_outlineFloatedElements(element)
{
    var checked        = element.getAttribute("checked");
    var className      = null;
    var documentList   = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength = documentList.length;
    var floatValue     = null;
    var pageDocument   = null;
    var pageElement    = null;
    var treeWalker     = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument = documentList[i];
        treeWalker   = pageDocument.createTreeWalker(pageDocument, NodeFilter.SHOW_ELEMENT, null, false);

        // While the tree walker has more nodes
        while((pageElement = treeWalker.nextNode()) != null)
        {
            // If the element is checked
            if(checked)
            {
                floatValue = pageElement.ownerDocument.defaultView.getComputedStyle(pageElement, null).getPropertyCSSValue("float").cssText;

                // If this element is floated and it is not set to none
                if(floatValue && floatValue != "none")
                {
                    pageElement.className += " webdeveloper-floated-element";
                }
            }
            else
            {
                className = pageElement.className;

                // If the element has a class name and it contains webdeveloper-floated-element
                if(className && className.indexOf("webdeveloper-floated-element") != -1)
                {
                    pageElement.className = webdeveloper_removeSubstring(className, "webdeveloper-floated-element");
                }
            }
        }
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_floated_elements.css", "webdeveloper-outline-floated-elements");
}

// Outlines all frames
function webdeveloper_outlineFrames(element)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_frames.css", "webdeveloper-outline-frames");
}

// Outlines all heading names
function webdeveloper_outlineHeadingNames(element)
{
    webdeveloper_removeStyleSheet("webdeveloper-outline-headings-before");
    webdeveloper_removeStyleSheet("webdeveloper-outline-headings-before-tooltips");

    // If the show outlined element names preference is set
    if(webdeveloper_getBooleanPreference("webdeveloper.outline.show.element.names", true))
    {
        webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_headings_before.css", "webdeveloper-outline-headings-before");
        webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-outline-headings-before-tooltips", "*:before");
    }
}

// Outlines all headings
function webdeveloper_outlineHeadings(element)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_headings.css", "webdeveloper-outline-headings");
    webdeveloper_outlineHeadingNames(element);
}

// Outlines all the links with ping attributes
function webdeveloper_outlineLinksWithPingAttributes(element)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_links_with_ping_attributes.css", "webdeveloper-outline-links-with-ping-attributes");
}

// Outlines all the links without title attributes
function webdeveloper_outlineLinksWithoutTitleAttributes(element)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_links_without_title_attributes.css", "webdeveloper-outline-links-without-title-attributes");
}

// Outlines all positioned elements of the specified position on the page
function webdeveloper_outlinePositionedElements(position, element)
{
    var attributeName  = "webdeveloper-" + position + "-positioned-element";
    var checked        = element.getAttribute("checked");
    var className      = null;
    var documentList   = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength = documentList.length;
    var pageDocument   = null;
    var pageElement    = null;
    var positionValue  = null;
    var treeWalker     = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument = documentList[i];
        treeWalker   = pageDocument.createTreeWalker(pageDocument, NodeFilter.SHOW_ELEMENT, null, false);

        // While the tree walker has more nodes
        while((pageElement = treeWalker.nextNode()) != null)
        {
            // If the element is checked
            if(checked)
            {
                positionValue = pageElement.ownerDocument.defaultView.getComputedStyle(pageElement, null).getPropertyCSSValue("position").cssText;

                // If this element is positioned and it is the specified position
                if(positionValue && positionValue == position)
                {
                    pageElement.className += " " + attributeName;
                }
            }
            else if(pageElement.className.indexOf(attributeName) != -1)
            {
                pageElement.className = webdeveloper_removeSubstring(pageElement.className, attributeName);
            }
        }
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_positioned_elements.css", "webdeveloper-outline-" + position + "-positioned-elements");
}

// Outlines all table captions
function webdeveloper_outlineTableCaptions(element)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_table_captions.css", "webdeveloper-outline-table-captions");
}

// Outlines all table cells
function webdeveloper_outlineTableCells(element)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_table_cells.css", "webdeveloper-outline-table-cells");
    webdeveloper_outlineTableCellNames(element);
}

// Outlines all table cell names
function webdeveloper_outlineTableCellNames(element)
{
    webdeveloper_removeStyleSheet("webdeveloper-outline-table-cells-before");
    webdeveloper_removeStyleSheet("webdeveloper-outline-table-cells-before-tooltips");

    // If the show outlined element names preference is set
    if(webdeveloper_getBooleanPreference("webdeveloper.outline.show.element.names", true))
    {
        webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_table_cells_before.css", "webdeveloper-outline-table-cells-before");
        webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-outline-table-cells-before-tooltips", "*:before");
    }
}

// Outlines all tables
function webdeveloper_outlineTables(element)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_tables.css", "webdeveloper-outline-all-tables");
}

// Toggle showing of element names when outlining
function webdeveloper_toggleShowElementNamesWhenOutlining(element)
{
    var menu = document.getElementById("webdeveloper-outline-block-level-elements-menu");

    webdeveloper_enablePreference(element, "webdeveloper.outline.show.element.names");

    webdeveloper_configureElementByAppliedStyle(menu, "checked", "webdeveloper-outline-block-level-elements");
    webdeveloper_outlineBlockLevelElementNames(menu, true);

    menu = document.getElementById("webdeveloper-outline-deprecated-elements-menu");
    webdeveloper_configureElementByAppliedStyle(menu, "checked", "webdeveloper-outline-deprecated-elements");
    webdeveloper_outlineDeprecatedElementNames(menu, true);

    menu = document.getElementById("webdeveloper-outline-headings-menu");
    webdeveloper_configureElementByAppliedStyle(menu, "checked", "webdeveloper-outline-headings");
    webdeveloper_outlineHeadingNames(menu, true);

    menu = document.getElementById("webdeveloper-outline-table-cells-menu");
    webdeveloper_configureElementByAppliedStyle(menu, "checked", "webdeveloper-outline-table-cells");
    webdeveloper_outlineTableCellNames(menu, true);
}

// Updates the outline menu
function webdeveloper_updateOutlineMenu(suffix)
{
    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-outline-block-level-elements-" + suffix), "checked", "webdeveloper-outline-block-level-elements");
    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-outline-current-element-" + suffix), "checked", "webdeveloper-outline-current-element");
    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-outline-custom-elements-" + suffix), "checked", "webdeveloper-outline-custom-elements");
    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-outline-deprecated-elements-" + suffix), "checked", "webdeveloper-outline-deprecated-elements");
    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-outline-frames-" + suffix), "checked", "webdeveloper-outline-frames");
    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-outline-headings-" + suffix), "checked", "webdeveloper-outline-headings");
    webdeveloper_configureElement(document.getElementById("webdeveloper-outline-show-element-names-" + suffix), "checked", webdeveloper_getBooleanPreference("webdeveloper.outline.show.element.names", true));
}

// Updates the outline links menu
function webdeveloper_updateOutlineLinksMenu(suffix)
{
    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-outline-external-links-" + suffix), "checked", "webdeveloper-outline-external-links");
    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-outline-links-with-ping-attributes-" + suffix), "checked", "webdeveloper-outline-links-with-ping-attributes");
    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-outline-links-without-title-attributes-" + suffix), "checked", "webdeveloper-outline-links-without-title-attributes");
}

// Updates the outline positioned elements menu
function webdeveloper_updateOutlinePositionedElementsMenu(suffix)
{
    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-outline-absolute-positioned-elements-" + suffix), "checked", "webdeveloper-outline-absolute-positioned-elements");
    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-outline-fixed-positioned-elements-" + suffix), "checked", "webdeveloper-outline-fixed-positioned-elements");
    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-outline-floated-elements-" + suffix), "checked", "webdeveloper-outline-floated-elements");
    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-outline-relative-positioned-elements-" + suffix), "checked", "webdeveloper-outline-relative-positioned-elements");
}

// Updates the outline tables menu
function webdeveloper_updateOutlineTablesMenu(suffix)
{
    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-outline-table-captions-" + suffix), "checked", "webdeveloper-outline-table-captions");
    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-outline-table-cells-" + suffix), "checked", "webdeveloper-outline-table-cells");
    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-outline-all-tables-" + suffix), "checked", "webdeveloper-outline-all-tables");
}
