/**************************************************************************
* Generic, native, relational database
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef ITERATORCORE_H
#define ITERATORCORE_H

#include "tabledata.h"

namespace RDB
{

class IndexIteratorCore
{
public:
    IndexIteratorCore( TableData* data );
    ~IndexIteratorCore();

public:
    bool next();

    Row* get() const { return m_bucket->m_row; }
    
private:
    TableData* m_data;

    uint m_hash;
    TableData::Bucket* m_bucket;
};

class ForeignIteratorCore
{
public:
    ForeignIteratorCore( TableData* data, int key );
    ~ForeignIteratorCore();

public:
    bool next();

    Row* get() const { return m_bucket->m_row; }
    
private:
    TableData* m_data;
    int m_key;

    TableData::Bucket* m_bucket;
};

}

#endif
