/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "finddialog.h"

#include <QLayout>
#include <QLabel>
#include <QLineEdit>
#include <QCheckBox>
#include <QDialogButtonBox>
#include <QPushButton>

using namespace WebIssues;

FindDialog::FindDialog( QWidget* parent ) : QDialog( parent ),
    m_enabled( false )
{
    setWindowTitle( tr( "Find" ) );

    QVBoxLayout* mainLayout = new QVBoxLayout( this );

    QHBoxLayout* editLayout = new QHBoxLayout();
    mainLayout->addLayout( editLayout );

    QLabel* label = new QLabel( tr( "Find &what:" ), this );
    editLayout->addWidget( label );

    m_edit = new QLineEdit( this );
    m_edit->setMinimumWidth( 250 );
    editLayout->addWidget( m_edit );

    label->setBuddy( m_edit );

    connect( m_edit, SIGNAL( textChanged( const QString& ) ), this, SLOT( textChanged( const QString& ) ) );

    m_wordCheckBox = new QCheckBox( tr( "&Match whole words only" ), this );
    mainLayout->addWidget( m_wordCheckBox );

    m_caseCheckBox = new QCheckBox( tr( "M&atch case" ), this );
    mainLayout->addWidget( m_caseCheckBox );

    m_buttonBox = new QDialogButtonBox( QDialogButtonBox::Ok | QDialogButtonBox::Close,
        Qt::Horizontal, this );
    mainLayout->addWidget( m_buttonBox );

    m_buttonBox->button( QDialogButtonBox::Ok )->setText( tr( "&Find" ) );
    m_buttonBox->button( QDialogButtonBox::Close )->setText( tr( "&Close" ) );

    connect( m_buttonBox, SIGNAL( accepted() ), this, SIGNAL( findClicked() ) );
    connect( m_buttonBox, SIGNAL( rejected() ), this, SLOT( close() ) );

    m_buttonBox->button( QDialogButtonBox::Ok )->setEnabled( false );

    setMaximumHeight( sizeHint().height() );
}

FindDialog::~FindDialog()
{
}

void FindDialog::setText( const QString& text )
{
    m_edit->setText( text );
}

QString FindDialog::text() const
{
    return m_edit->text();
}

void FindDialog::setFlags( QTextDocument::FindFlags flags )
{
    m_wordCheckBox->setChecked( flags & QTextDocument::FindWholeWords );
    m_caseCheckBox->setChecked( flags & QTextDocument::FindCaseSensitively );
}

QTextDocument::FindFlags FindDialog::flags() const
{
    QTextDocument::FindFlags flags = 0;
    if ( m_wordCheckBox->isChecked() )
        flags |= QTextDocument::FindWholeWords;
    if ( m_caseCheckBox->isChecked() )
        flags |= QTextDocument::FindCaseSensitively;
    return flags;
}

void FindDialog::showEvent( QShowEvent* event )
{
    QDialog::showEvent( event );

    m_edit->setFocus();
}

void FindDialog::textChanged( const QString& text )
{
    m_enabled = !text.isEmpty();

    m_buttonBox->button( QDialogButtonBox::Ok )->setEnabled( m_enabled );

    emit findEnabled( m_enabled );
}

#include "finddialog.moc"
