/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "searcheditbox.h"

#include <QLayout>
#include <QToolButton>
#include <QLineEdit>
#include <QLabel>

#include "iconloader.h"

using namespace WebIssues;

SearchEditBox::SearchEditBox( QWidget* parent ) : QWidget( parent )
{
    QHBoxLayout* layout = new QHBoxLayout( this );
    layout->setMargin( 0 );

    m_button = new QToolButton( this );
    m_button->setIcon( IconLoader::icon( "clear-right" ) );
    m_button->setToolTip( tr( "Clear" ) );
    m_button->setAutoRaise( true );
    layout->addWidget( m_button );

    QLabel* label = new QLabel( tr( "&Quick Search:" ), this );
    layout->addWidget( label );

    m_edit = new QLineEdit( this );
    m_edit->setMinimumWidth( 150 );
    layout->addWidget( m_edit );

    label->setBuddy( m_edit );

    m_button->setEnabled( false );

    connect( m_edit, SIGNAL( textChanged( const QString& ) ), this, SLOT( slotTextChanged( const QString& ) ) );
    connect( m_button, SIGNAL( clicked() ), this, SLOT( buttonClicked() ) );
}

SearchEditBox::~SearchEditBox()
{
}

void SearchEditBox::setText( const QString& text )
{
    m_edit->setText( text );

    m_button->setEnabled( !text.isEmpty() );
}

QString SearchEditBox::text() const
{
    return m_edit->text();
}

void SearchEditBox::clear()
{
    m_edit->clear();

    m_button->setEnabled( false );
}

void SearchEditBox::slotTextChanged( const QString& text )
{
    m_button->setEnabled( !text.isEmpty() );

    emit textChanged( text );
}

void SearchEditBox::buttonClicked()
{
    clear();

    m_edit->setFocus();
}

#include "searcheditbox.moc"
