/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef _WFLOGS_FILTER_H
#define _WFLOGS_FILTER_H

#include <string>
#include <iostream>

#include "wflogentry.h"
#include "filter.h"

/**
 * 
 */
class wflogs_filter {
 public:
  wflogs_filter();
  virtual ~wflogs_filter();
  // wflogs_filter(const wflogs_filter&) {} default copy constructor

  bool set(const string& expr);

  void count_reset();
  unsigned int count_get() const;
  bool operator() (const wf_logentry* entry);

  ostream& print(ostream& os) const;

 private:
  exprnode* _tree;
  unsigned int _count;
};

#endif
