#!/bin/sh
#set -x

RPM_SRC_LIST="rpm RPM redhat packages"

unset MKRPM_SRC
for i in $RPM_SRC_LIST ; do 
   if test -d /usr/src/$i/SOURCES ; then
      MKRPM_SRC=/usr/src/$i/SOURCES
   fi
done
if test "$MKRPM_SRC" = "" ; then
   echo -n non of typical rpm source directories 1>&2
   for i in $RPM_SRC_LIST ; do 
       echo -n " " /usr/src/$i/SOURCES 1>&2 
   done
   echo " " found 1>&2 
   echo extend variable RPM_SRC_LIST in $0 for your system 1>&2
   exit 1
fi

VERSION=`sh ../../batch/getversion.sh`
(cd ../../.. && cp -r white_dune-$VERSION /tmp && \
cd /tmp/white_dune-$VERSION && make realclean && rm -rf desktop/macosx desktop/irix) && \
(cd /tmp && tar -cpf - white_dune-$VERSION) | \
gzip -c > $MKRPM_SRC/white_dune-$VERSION.tar.gz

RPM_BUILD_ROOT='$RPM_BUILD_ROOT'
RPM_OPT_FLAGS='$RPM_OPT_FLAGS'

rm -f /tmp/white_dune-$VERSION.spec
cat > /tmp/white_dune-$VERSION.spec << EOT 
Summary: A graphical VRML97 editor, simple NURBS 3D modeller and animation tool in development
Name: white_dune
Version: $VERSION
Release: 1
Copyright: GPL
Group: Applications/Multimedia
Source: http://www.csv.ica.uni-stuttgart.de/vrml/dune/white_dune-$VERSION.tar.gz
BuildRoot: /var/tmp/%{name}-buildroot

%description
The white_dune program is a graphical VRML97 editor, simple NURBS 3D modeller 
and animation tool.
VRML97 (Virtual Reality Modelling Language) is the ISO standard for
displaying 3D data over the web. It has support for animation, realtime
interaction and multimedia (image, movie, sound). VRML97 can be written
by popular programs like maya, catia, 3D Studio MAX, cinema4D and others. 
Dune can read VRML97 files, display and let the user change the 
scenegraph/fields. 
Some documentation how to use dune is included.
White_dune has only 3D modelling features via support for the VRML97
Amendment1 style NURBS nodes. This is mainly convenient for building some 
rounded shapes.
For artistic work, the usage of a static 3D modeller with VRML97 export 
features may be useful.
Examples for free (speech) static 3D modellers available under Linux are 
wings3d or art of illusion.
%prep
%setup -q

%build
./configure --with-optimization --with-buginlesstif --without-devil --with-vrmlbrowser=mozilla --with-helpurl="/usr/share/doc/white_dune-$VERSION/docs/index.html"  --with-vrml97am1url="/usr/share/doc/white_dune-$VERSION/docs/vrml97Amendment1"  --with-x3ddrafturl="/usr/share/doc/white_dune-$VERSION/docs/x3dDraft" --with-scriptednodesurl="/usr/share/doc/white_dune-$VERSION/docs/scriptedNodes"
make RPM_OPT_FLAGS="$RPM_OPT_FLAGS" 

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/usr/X11R6/bin
mkdir -p $RPM_BUILD_ROOT/usr/bin
mkdir -p $RPM_BUILD_ROOT/usr/share/man/man1
mkdir -p $RPM_BUILD_ROOT/usr/share/misc/white_dune
mkdir -p $RPM_BUILD_ROOT/usr/share/applications
mkdir -p $RPM_BUILD_ROOT/usr/share/icons/Bluecurve/48x48/apps

install -s -m 755 bin/dune $RPM_BUILD_ROOT/usr/X11R6/bin/dune
install -m 755 bin/dune4kids $RPM_BUILD_ROOT/usr/X11R6/bin/dune4kids
install -m 755 bin/illegal2vrml $RPM_BUILD_ROOT/usr/bin/illegal2vrml
install -m 644 desktop/kde/redhat/dune.desktop $RPM_BUILD_ROOT/usr/share/applications/dune.desktop
install -m 644 desktop/kde/dune.png $RPM_BUILD_ROOT/usr/share/icons/Bluecurve/48x48/apps/dune.png
install -m 644 desktop/kde/redhat/dune4kids.desktop $RPM_BUILD_ROOT/usr/share/applications/dune4kids.desktop
install -m 644 desktop/kde/dune4kids.png $RPM_BUILD_ROOT/usr/share/icons/Bluecurve/48x48/apps/dune4kids.png
install -m 644 man/dune.1 $RPM_BUILD_ROOT/usr/share/man/man1/dune.1
install -m 644 man/illegal2vrml.1 $RPM_BUILD_ROOT/usr/share/man/man1/illegal2vrml.1

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc README COPYING docs

/usr/X11R6/bin/dune
/usr/X11R6/bin/dune4kids
/usr/bin/illegal2vrml
/usr/share/applications/dune.desktop
/usr/share/icons/Bluecurve/48x48/apps/dune.png
/usr/share/applications/dune4kids.desktop
/usr/share/icons/Bluecurve/48x48/apps/dune4kids.png
/usr/share/man/man1/dune.1*
/usr/share/man/man1/illegal2vrml.1*
EOT

if rpm -ba /tmp/white_dune-$VERSION.spec ; then
   echo > /dev/null
else
   rpmbuild -ba /tmp/white_dune-$VERSION.spec
fi
