(* This file was originally generated by why.
   It can be modified; only the generated parts will be overwritten. *)

Require Import Why.
Require Import Sumbool.

Require Export Match.
Require Export Next.
Require Import ZArithRing.
Require Import Omega.
Require Export Lex.

Ltac Omega' := abstract omega.

Parameter A : Set.
Axiom A_eq_dec : forall x y:A, {x = y} + {x <> y}.
Definition A_eq_bool (x y:A) := bool_of_sumbool (A_eq_dec x y).

(*Why*) Parameter M : Z.
Axiom M_positive : (0 <= M)%Z.

Proof.
intuition.
Qed.

Proof.
intros; exact lexZ_well_founded.
Qed.

Proof.
intuition.
Qed.

Proof.
intuition.
Qed.

Proof.
intuition.
Qed.

Proof.
intuition.
subst i2 j2.
apply match_right_extension.
replace (i1 + 1 - (j1 + 1))%Z with (i1 - j1)%Z.
 assumption.
 Omega'.
  Omega'.
 Omega'.
  ring (i1 + 1 - (j1 + 1) + j1)%Z.
 ring (0 + j1)%Z.
 assumption.
  absurd (match_ p (i1 + 1 - (z - 1)) p 0 (z - 1)).
  red; apply H11; Omega'.
  apply match_right_weakening with (n := z).
  replace (i1 + 1 - (z - 1))%Z with (i1 + 1 + 1 - z)%Z.
  subst i2; assumption.
 Omega'.
 Omega'.
  elim (Z_lt_ge_dec k (i1 + 1)); intro Hk'.
    subst next2; rewrite store_def_2.
  apply H13; Omega'.
 Omega'.
 Omega'.
 Omega'.
  cut ((i1 + 1)%Z = k).
 intro Heq.
   subst next2 i2; rewrite Heq.
 rewrite store_def_1.
  rewrite <- Heq.
 apply Next_cons.
 Omega'.
  subst j2; replace (i1 + 1 - (j1 + 1))%Z with (i1 - j1)%Z.
  apply match_right_extension; Omega' || (try assumption).
  ring (i1 - j1 + j1)%Z; ring (0 + j1)%Z; assumption.
 Omega'.
  intros z Hz.
   red; apply H11; Omega'.
  Omega'.
 Omega'.
  ArraySubst next2.
unfold lexZ, lex, Zwf, pairZ; left; Omega'.
Qed.

Proof.
intuition.
Qed.

Proof.
intuition.
  rewrite Test4.
  apply match_empty.
 Omega'.
 Omega'.
  elim (Z_lt_ge_dec (j1 + 2) z); intro.
  absurd (match_ p (i1 + 1 - (z - 1)) p 0 (z - 1)).
  red; apply H11; Omega'.
  apply match_right_weakening with (n := z).
  subst i2.
  replace (i1 + 1 - (z - 1))%Z with (i1 + 1 + 1 - z)%Z;
   [ assumption | Omega' ].
 Omega'.
  absurd (access p i1 = access p j1); [ assumption | idtac ].
  decompose [match_] H18.
  replace i1 with (i1 + 1 + 1 - 2 + j1)%Z; [ idtac | Omega' ].
  replace (access p j1) with (access p (0 + j1));
   [ idtac | ring (0 + j1)%Z; reflexivity ].
  cut (z = 2%Z); [ intro Heq | Omega' ].
  rewrite <- Heq.
 rewrite <- Post5; apply H22; Omega'.
  elim (Z_lt_ge_dec k (i1 + 1)); intro.
  subst next2.
 AccessOther.
  apply H13; Omega'.
   cut ((i1 + 1)%Z = k); [ intro Heq | Omega' ].
  rewrite Post6; rewrite Post5; rewrite Heq.
 AccessSame.
  rewrite <- Heq.
 apply Next_cons.
 Omega'.
  apply match_empty; Omega'.
  intros z Hz.
  elim (Z_lt_ge_dec 1 z); intro.
  (* 1 < z  *)
  red; apply H11; Omega'.
  (* z = 1 *)
  red; intro.
  absurd (access p i1 = access p j1); [ assumption | rewrite Test4 ].
  decompose [match_] H17.
  replace 0%Z with (0 + 0)%Z; [ idtac | Omega' ].
  replace i1 with (i1 + 1 - z + 0)%Z; [ idtac | Omega' ].
  apply H22; Omega'.
  ArraySubst next2.
unfold lexZ, lex, Zwf, pairZ.
 left; Omega'.
Qed.

Proof.
intuition.
Qed.

Proof.
intuition cut (j1 <> 0%Z); [ clear Test3; intro Test3 | assumption ].
  subst j2.
  elim (H15 j1); Omega'.
  elim (H15 j1); Omega'.
  elim (H15 j1); Omega'.
  subst j2.
  apply match_trans with (t2 := p) (i2 := (j1 - access next1 j1)%Z).
  apply match_left_weakening with (n := j1).
  replace (i1 - access next1 j1 - (j1 - access next1 j1))%Z with
   (i1 - j1)%Z; [ idtac | Omega' ].
  replace (j1 - access next1 j1 - (j1 - access next1 j1))%Z with 0%Z;
   [ assumption | Omega' ].
  elim (H15 j1); Omega'.
 elim (H15 j1); auto; Omega'.

  elim (Z_lt_ge_dec (j1 + 1) z); intro.
  (* j0+1 < z < i0+1 *)
  apply (H13 z); assumption || Omega'.
  elim (Z_ge_lt_dec z (j1 + 1)); intro.
  (* z = j0+1 *)
  absurd (access p i1 = access p j1); [ assumption | idtac ].
  decompose [match_] H18.
  replace i1 with (i1 + 1 - z + j1)%Z; [ idtac | Omega' ].
  replace j1 with (0 + j1)%Z; [ idtac | Omega' ].
  apply H22; Omega'.
  (* next[j0]+1 < z < j0+1 *)
  absurd (match_ p (j1 - (z - 1)) p 0 (z - 1)).
  decompose [match_] H18.
  elim (H15 j1); Omega' || intros.
  apply H25; Omega'.
  apply match_trans with (t2 := p) (i2 := (i1 - (z - 1))%Z).
  apply match_sym.
  apply match_left_weakening with (n := j1).
  replace (i1 - (z - 1) - (j1 - (z - 1)))%Z with (i1 - j1)%Z;
   [ idtac | Omega' ].
  ring (j1 - (z - 1) - (j1 - (z - 1)))%Z.
 assumption.
  Omega'.
  apply match_right_weakening with (n := z).
  replace (i1 - (z - 1))%Z with (i1 + 1 - z)%Z; [ assumption | Omega' ].
  Omega'.
unfold lexZ, lex, Zwf, pairZ.
 elim (H15 j1); [ intros | Omega' ].
right.
 Omega'.
Qed.

Proof.
intuition.
rewrite Pre13; assumption.
Qed.

Proof.
intuition.
subst i j.
apply match_empty; Omega'.
replace k with 1%Z; [ subst next0; rewrite store_def_1 | Omega' ].
apply next_1_0; Omega'.
Omega'.
ArraySubst next0.
Qed.

Proof.
intuition.
Qed.

Proof.
intuition.
absurd (0 < j)%Z; Omega'.
Qed.


(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma initnext_po_1 : 
  forall (next: (array Z)),
  forall (p: (array A)),
  forall (HW_1: (array_length p) = M /\ (array_length next) = M),
  forall (HW_2: 1 < M),
  0 <= 1 /\ 1 < (array_length next).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma initnext_po_2 : 
  forall (next: (array Z)),
  forall (p: (array A)),
  forall (HW_1: (array_length p) = M /\ (array_length next) = M),
  forall (HW_2: 1 < M),
  forall (HW_3: 0 <= 1 /\ 1 < (array_length next)),
  forall (next0: (array Z)),
  forall (HW_4: next0 = (update next 1 0)),
  (well_founded lexZ).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma initnext_po_3 : 
  forall (next: (array Z)),
  forall (p: (array A)),
  forall (HW_1: (array_length p) = M /\ (array_length next) = M),
  forall (HW_2: 1 < M),
  forall (HW_3: 0 <= 1 /\ 1 < (array_length next)),
  forall (next0: (array Z)),
  forall (HW_4: next0 = (update next 1 0)),
  (0 <= 0 /\ 0 <= M) /\ (0 < 1 /\ 1 <= M) /\ (match_ p (1 - 0) p 0 0) /\
  (forall (z:Z),
   ((0 + 1) < z /\ z < (1 + 1) -> ~(match_ p (1 + 1 - z) p 0 z))) /\
  (forall (k:Z), (0 < k /\ k <= 1 -> (Next p k (access next0 k)))) /\
  (array_length next0) = M.
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma initnext_po_4 : 
  forall (next: (array Z)),
  forall (p: (array A)),
  forall (HW_1: (array_length p) = M /\ (array_length next) = M),
  forall (HW_2: 1 < M),
  forall (HW_3: 0 <= 1 /\ 1 < (array_length next)),
  forall (next0: (array Z)),
  forall (HW_4: next0 = (update next 1 0)),
  forall (HW_5: (0 <= 0 /\ 0 <= M) /\ (0 < 1 /\ 1 <= M) /\
                (match_ p (1 - 0) p 0 0) /\
                (forall (z:Z),
                 ((0 + 1) < z /\ z < (1 + 1) -> ~(match_ p (1 + 1 - z) p 0 z))) /\
                (forall (k:Z),
                 (0 < k /\ k <= 1 -> (Next p k (access next0 k)))) /\
                (array_length next0) = M),
  forall (i: Z),
  forall (j: Z),
  forall (next1: (array Z)),
  forall (HW_6: (0 <= j /\ j <= M) /\ (j < i /\ i <= M) /\
                (match_ p (i - j) p 0 j) /\
                (forall (z:Z),
                 ((j + 1) < z /\ z < (i + 1) -> ~(match_ p (i + 1 - z) p 0 z))) /\
                (forall (k:Z),
                 (0 < k /\ k <= i -> (Next p k (access next1 k)))) /\
                (array_length next1) = M),
  forall (HW_7: i < (M - 1)),
  0 <= i /\ i < (array_length p).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma initnext_po_5 : 
  forall (next: (array Z)),
  forall (p: (array A)),
  forall (HW_1: (array_length p) = M /\ (array_length next) = M),
  forall (HW_2: 1 < M),
  forall (HW_3: 0 <= 1 /\ 1 < (array_length next)),
  forall (next0: (array Z)),
  forall (HW_4: next0 = (update next 1 0)),
  forall (HW_5: (0 <= 0 /\ 0 <= M) /\ (0 < 1 /\ 1 <= M) /\
                (match_ p (1 - 0) p 0 0) /\
                (forall (z:Z),
                 ((0 + 1) < z /\ z < (1 + 1) -> ~(match_ p (1 + 1 - z) p 0 z))) /\
                (forall (k:Z),
                 (0 < k /\ k <= 1 -> (Next p k (access next0 k)))) /\
                (array_length next0) = M),
  forall (i: Z),
  forall (j: Z),
  forall (next1: (array Z)),
  forall (HW_6: (0 <= j /\ j <= M) /\ (j < i /\ i <= M) /\
                (match_ p (i - j) p 0 j) /\
                (forall (z:Z),
                 ((j + 1) < z /\ z < (i + 1) -> ~(match_ p (i + 1 - z) p 0 z))) /\
                (forall (k:Z),
                 (0 < k /\ k <= i -> (Next p k (access next1 k)))) /\
                (array_length next1) = M),
  forall (HW_7: i < (M - 1)),
  forall (HW_8: 0 <= i /\ i < (array_length p)),
  forall (result: A),
  forall (HW_9: result = (access p i)),
  0 <= j /\ j < (array_length p).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma initnext_po_6 : 
  forall (next: (array Z)),
  forall (p: (array A)),
  forall (HW_1: (array_length p) = M /\ (array_length next) = M),
  forall (HW_2: 1 < M),
  forall (HW_3: 0 <= 1 /\ 1 < (array_length next)),
  forall (next0: (array Z)),
  forall (HW_4: next0 = (update next 1 0)),
  forall (HW_5: (0 <= 0 /\ 0 <= M) /\ (0 < 1 /\ 1 <= M) /\
                (match_ p (1 - 0) p 0 0) /\
                (forall (z:Z),
                 ((0 + 1) < z /\ z < (1 + 1) -> ~(match_ p (1 + 1 - z) p 0 z))) /\
                (forall (k:Z),
                 (0 < k /\ k <= 1 -> (Next p k (access next0 k)))) /\
                (array_length next0) = M),
  forall (i: Z),
  forall (j: Z),
  forall (next1: (array Z)),
  forall (HW_6: (0 <= j /\ j <= M) /\ (j < i /\ i <= M) /\
                (match_ p (i - j) p 0 j) /\
                (forall (z:Z),
                 ((j + 1) < z /\ z < (i + 1) -> ~(match_ p (i + 1 - z) p 0 z))) /\
                (forall (k:Z),
                 (0 < k /\ k <= i -> (Next p k (access next1 k)))) /\
                (array_length next1) = M),
  forall (HW_7: i < (M - 1)),
  forall (HW_8: 0 <= i /\ i < (array_length p)),
  forall (result: A),
  forall (HW_9: result = (access p i)),
  forall (HW_10: 0 <= j /\ j < (array_length p)),
  forall (result0: A),
  forall (HW_11: result0 = (access p j)),
  forall (HW_12: result = result0),
  forall (i0: Z),
  forall (HW_13: i0 = (i + 1)),
  forall (j0: Z),
  forall (HW_14: j0 = (j + 1)),
  0 <= i0 /\ i0 < (array_length next1).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma initnext_po_7 : 
  forall (next: (array Z)),
  forall (p: (array A)),
  forall (HW_1: (array_length p) = M /\ (array_length next) = M),
  forall (HW_2: 1 < M),
  forall (HW_3: 0 <= 1 /\ 1 < (array_length next)),
  forall (next0: (array Z)),
  forall (HW_4: next0 = (update next 1 0)),
  forall (HW_5: (0 <= 0 /\ 0 <= M) /\ (0 < 1 /\ 1 <= M) /\
                (match_ p (1 - 0) p 0 0) /\
                (forall (z:Z),
                 ((0 + 1) < z /\ z < (1 + 1) -> ~(match_ p (1 + 1 - z) p 0 z))) /\
                (forall (k:Z),
                 (0 < k /\ k <= 1 -> (Next p k (access next0 k)))) /\
                (array_length next0) = M),
  forall (i: Z),
  forall (j: Z),
  forall (next1: (array Z)),
  forall (HW_6: (0 <= j /\ j <= M) /\ (j < i /\ i <= M) /\
                (match_ p (i - j) p 0 j) /\
                (forall (z:Z),
                 ((j + 1) < z /\ z < (i + 1) -> ~(match_ p (i + 1 - z) p 0 z))) /\
                (forall (k:Z),
                 (0 < k /\ k <= i -> (Next p k (access next1 k)))) /\
                (array_length next1) = M),
  forall (HW_7: i < (M - 1)),
  forall (HW_8: 0 <= i /\ i < (array_length p)),
  forall (result: A),
  forall (HW_9: result = (access p i)),
  forall (HW_10: 0 <= j /\ j < (array_length p)),
  forall (result0: A),
  forall (HW_11: result0 = (access p j)),
  forall (HW_12: result = result0),
  forall (i0: Z),
  forall (HW_13: i0 = (i + 1)),
  forall (j0: Z),
  forall (HW_14: j0 = (j + 1)),
  forall (HW_15: 0 <= i0 /\ i0 < (array_length next1)),
  forall (next2: (array Z)),
  forall (HW_16: next2 = (update next1 i0 j0)),
  ((0 <= j0 /\ j0 <= M) /\ (j0 < i0 /\ i0 <= M) /\
  (match_ p (i0 - j0) p 0 j0) /\
  (forall (z:Z),
   ((j0 + 1) < z /\ z < (i0 + 1) -> ~(match_ p (i0 + 1 - z) p 0 z))) /\
  (forall (k:Z), (0 < k /\ k <= i0 -> (Next p k (access next2 k)))) /\
  (array_length next2) = M) /\ (lexZ (pairZ (M - i0) j0) (pairZ (M - i) j)).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma initnext_po_8 : 
  forall (next: (array Z)),
  forall (p: (array A)),
  forall (HW_1: (array_length p) = M /\ (array_length next) = M),
  forall (HW_2: 1 < M),
  forall (HW_3: 0 <= 1 /\ 1 < (array_length next)),
  forall (next0: (array Z)),
  forall (HW_4: next0 = (update next 1 0)),
  forall (HW_5: (0 <= 0 /\ 0 <= M) /\ (0 < 1 /\ 1 <= M) /\
                (match_ p (1 - 0) p 0 0) /\
                (forall (z:Z),
                 ((0 + 1) < z /\ z < (1 + 1) -> ~(match_ p (1 + 1 - z) p 0 z))) /\
                (forall (k:Z),
                 (0 < k /\ k <= 1 -> (Next p k (access next0 k)))) /\
                (array_length next0) = M),
  forall (i: Z),
  forall (j: Z),
  forall (next1: (array Z)),
  forall (HW_6: (0 <= j /\ j <= M) /\ (j < i /\ i <= M) /\
                (match_ p (i - j) p 0 j) /\
                (forall (z:Z),
                 ((j + 1) < z /\ z < (i + 1) -> ~(match_ p (i + 1 - z) p 0 z))) /\
                (forall (k:Z),
                 (0 < k /\ k <= i -> (Next p k (access next1 k)))) /\
                (array_length next1) = M),
  forall (HW_7: i < (M - 1)),
  forall (HW_8: 0 <= i /\ i < (array_length p)),
  forall (result: A),
  forall (HW_9: result = (access p i)),
  forall (HW_10: 0 <= j /\ j < (array_length p)),
  forall (result0: A),
  forall (HW_11: result0 = (access p j)),
  forall (HW_17: ~result = result0),
  forall (HW_18: j = 0),
  forall (i0: Z),
  forall (HW_19: i0 = (i + 1)),
  0 <= i0 /\ i0 < (array_length next1).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma initnext_po_9 : 
  forall (next: (array Z)),
  forall (p: (array A)),
  forall (HW_1: (array_length p) = M /\ (array_length next) = M),
  forall (HW_2: 1 < M),
  forall (HW_3: 0 <= 1 /\ 1 < (array_length next)),
  forall (next0: (array Z)),
  forall (HW_4: next0 = (update next 1 0)),
  forall (HW_5: (0 <= 0 /\ 0 <= M) /\ (0 < 1 /\ 1 <= M) /\
                (match_ p (1 - 0) p 0 0) /\
                (forall (z:Z),
                 ((0 + 1) < z /\ z < (1 + 1) -> ~(match_ p (1 + 1 - z) p 0 z))) /\
                (forall (k:Z),
                 (0 < k /\ k <= 1 -> (Next p k (access next0 k)))) /\
                (array_length next0) = M),
  forall (i: Z),
  forall (j: Z),
  forall (next1: (array Z)),
  forall (HW_6: (0 <= j /\ j <= M) /\ (j < i /\ i <= M) /\
                (match_ p (i - j) p 0 j) /\
                (forall (z:Z),
                 ((j + 1) < z /\ z < (i + 1) -> ~(match_ p (i + 1 - z) p 0 z))) /\
                (forall (k:Z),
                 (0 < k /\ k <= i -> (Next p k (access next1 k)))) /\
                (array_length next1) = M),
  forall (HW_7: i < (M - 1)),
  forall (HW_8: 0 <= i /\ i < (array_length p)),
  forall (result: A),
  forall (HW_9: result = (access p i)),
  forall (HW_10: 0 <= j /\ j < (array_length p)),
  forall (result0: A),
  forall (HW_11: result0 = (access p j)),
  forall (HW_17: ~result = result0),
  forall (HW_18: j = 0),
  forall (i0: Z),
  forall (HW_19: i0 = (i + 1)),
  forall (HW_20: 0 <= i0 /\ i0 < (array_length next1)),
  forall (next2: (array Z)),
  forall (HW_21: next2 = (update next1 i0 0)),
  ((0 <= j /\ j <= M) /\ (j < i0 /\ i0 <= M) /\ (match_ p (i0 - j) p 0 j) /\
  (forall (z:Z),
   ((j + 1) < z /\ z < (i0 + 1) -> ~(match_ p (i0 + 1 - z) p 0 z))) /\
  (forall (k:Z), (0 < k /\ k <= i0 -> (Next p k (access next2 k)))) /\
  (array_length next2) = M) /\ (lexZ (pairZ (M - i0) j) (pairZ (M - i) j)).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma initnext_po_10 : 
  forall (next: (array Z)),
  forall (p: (array A)),
  forall (HW_1: (array_length p) = M /\ (array_length next) = M),
  forall (HW_2: 1 < M),
  forall (HW_3: 0 <= 1 /\ 1 < (array_length next)),
  forall (next0: (array Z)),
  forall (HW_4: next0 = (update next 1 0)),
  forall (HW_5: (0 <= 0 /\ 0 <= M) /\ (0 < 1 /\ 1 <= M) /\
                (match_ p (1 - 0) p 0 0) /\
                (forall (z:Z),
                 ((0 + 1) < z /\ z < (1 + 1) -> ~(match_ p (1 + 1 - z) p 0 z))) /\
                (forall (k:Z),
                 (0 < k /\ k <= 1 -> (Next p k (access next0 k)))) /\
                (array_length next0) = M),
  forall (i: Z),
  forall (j: Z),
  forall (next1: (array Z)),
  forall (HW_6: (0 <= j /\ j <= M) /\ (j < i /\ i <= M) /\
                (match_ p (i - j) p 0 j) /\
                (forall (z:Z),
                 ((j + 1) < z /\ z < (i + 1) -> ~(match_ p (i + 1 - z) p 0 z))) /\
                (forall (k:Z),
                 (0 < k /\ k <= i -> (Next p k (access next1 k)))) /\
                (array_length next1) = M),
  forall (HW_7: i < (M - 1)),
  forall (HW_8: 0 <= i /\ i < (array_length p)),
  forall (result: A),
  forall (HW_9: result = (access p i)),
  forall (HW_10: 0 <= j /\ j < (array_length p)),
  forall (result0: A),
  forall (HW_11: result0 = (access p j)),
  forall (HW_17: ~result = result0),
  forall (HW_22: j <> 0),
  0 <= j /\ j < (array_length next1).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma initnext_po_11 : 
  forall (next: (array Z)),
  forall (p: (array A)),
  forall (HW_1: (array_length p) = M /\ (array_length next) = M),
  forall (HW_2: 1 < M),
  forall (HW_3: 0 <= 1 /\ 1 < (array_length next)),
  forall (next0: (array Z)),
  forall (HW_4: next0 = (update next 1 0)),
  forall (HW_5: (0 <= 0 /\ 0 <= M) /\ (0 < 1 /\ 1 <= M) /\
                (match_ p (1 - 0) p 0 0) /\
                (forall (z:Z),
                 ((0 + 1) < z /\ z < (1 + 1) -> ~(match_ p (1 + 1 - z) p 0 z))) /\
                (forall (k:Z),
                 (0 < k /\ k <= 1 -> (Next p k (access next0 k)))) /\
                (array_length next0) = M),
  forall (i: Z),
  forall (j: Z),
  forall (next1: (array Z)),
  forall (HW_6: (0 <= j /\ j <= M) /\ (j < i /\ i <= M) /\
                (match_ p (i - j) p 0 j) /\
                (forall (z:Z),
                 ((j + 1) < z /\ z < (i + 1) -> ~(match_ p (i + 1 - z) p 0 z))) /\
                (forall (k:Z),
                 (0 < k /\ k <= i -> (Next p k (access next1 k)))) /\
                (array_length next1) = M),
  forall (HW_7: i < (M - 1)),
  forall (HW_8: 0 <= i /\ i < (array_length p)),
  forall (result: A),
  forall (HW_9: result = (access p i)),
  forall (HW_10: 0 <= j /\ j < (array_length p)),
  forall (result0: A),
  forall (HW_11: result0 = (access p j)),
  forall (HW_17: ~result = result0),
  forall (HW_22: j <> 0),
  forall (HW_23: 0 <= j /\ j < (array_length next1)),
  forall (result1: Z),
  forall (HW_24: result1 = (access next1 j)),
  forall (j0: Z),
  forall (HW_25: j0 = result1),
  ((0 <= j0 /\ j0 <= M) /\ (j0 < i /\ i <= M) /\
  (match_ p (i - j0) p 0 j0) /\
  (forall (z:Z),
   ((j0 + 1) < z /\ z < (i + 1) -> ~(match_ p (i + 1 - z) p 0 z))) /\
  (forall (k:Z), (0 < k /\ k <= i -> (Next p k (access next1 k)))) /\
  (array_length next1) = M) /\ (lexZ (pairZ (M - i) j0) (pairZ (M - i) j)).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma initnext_po_12 : 
  forall (next: (array Z)),
  forall (p: (array A)),
  forall (HW_1: (array_length p) = M /\ (array_length next) = M),
  forall (HW_2: 1 < M),
  forall (HW_3: 0 <= 1 /\ 1 < (array_length next)),
  forall (next0: (array Z)),
  forall (HW_4: next0 = (update next 1 0)),
  forall (HW_5: (0 <= 0 /\ 0 <= M) /\ (0 < 1 /\ 1 <= M) /\
                (match_ p (1 - 0) p 0 0) /\
                (forall (z:Z),
                 ((0 + 1) < z /\ z < (1 + 1) -> ~(match_ p (1 + 1 - z) p 0 z))) /\
                (forall (k:Z),
                 (0 < k /\ k <= 1 -> (Next p k (access next0 k)))) /\
                (array_length next0) = M),
  forall (i: Z),
  forall (j: Z),
  forall (next1: (array Z)),
  forall (HW_6: (0 <= j /\ j <= M) /\ (j < i /\ i <= M) /\
                (match_ p (i - j) p 0 j) /\
                (forall (z:Z),
                 ((j + 1) < z /\ z < (i + 1) -> ~(match_ p (i + 1 - z) p 0 z))) /\
                (forall (k:Z),
                 (0 < k /\ k <= i -> (Next p k (access next1 k)))) /\
                (array_length next1) = M),
  forall (HW_26: i >= (M - 1)),
  (array_length next1) = M /\
  (forall (j:Z), (0 < j /\ j < M -> (Next p j (access next1 j)))).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma initnext_po_13 : 
  forall (next: (array Z)),
  forall (p: (array A)),
  forall (HW_1: (array_length p) = M /\ (array_length next) = M),
  forall (HW_27: 1 >= M),
  (array_length next) = M /\
  (forall (j:Z), (0 < j /\ j < M -> (Next p j (access next j)))).
Proof.
(* FILL PROOF HERE *)
Save.

(*Why*) Parameter N : Z.
Axiom N_positive : (0 <= N)%Z.


Proof.
intuition.
Qed.

Proof.
intros; exact lexZ_well_founded.
Qed.

Proof.
intuition simple induction result1; tauto.
Qed.

Proof.
simple induction result1; intuition; discriminate Post5.
Qed.

Proof.
intuition.
Qed.

Proof.
intuition.
Qed.

Proof.
intuition discriminate H18 || auto with *.
subst j2 i2.
  apply match_right_extension.
  replace (i1 + 1 - (j1 + 1))%Z with (i1 - j1)%Z.
 assumption.
 Omega'.
  Omega'.
 Omega'.
  ring (i1 + 1 - (j1 + 1) + j1)%Z.
 ring (0 + j1)%Z.
 assumption.
  replace (i1 + 1 - (j1 + 1))%Z with (i1 - j1)%Z.
   apply (H18 k); assumption || Omega'.
  Omega'.
  unfold lexZ, lex, Zwf, pairZ.
 left; Omega'.
Qed.

Proof.
intuition discriminate H18 || auto with *.
  subst j1.
  apply match_empty.
 Omega'.
 Omega'.
  elim (Z_le_lt_eq_dec k (i1 - j1)).
  intro.
 apply (H18 k); assumption || Omega'.
  intro.
 generalize H19.
 apply match_contradiction_at_first.
 Omega'.
  rewrite b.
 subst j1.
 ring (i1 - 0)%Z.
 assumption.
  Omega'.
unfold lexZ, lex, Zwf, pairZ.
 left; Omega'.
Qed.

Proof.
intuition.
Qed.

Proof.
intuition assert (j1 <> 0%Z); auto with *.
  (* invariant *)
  elim (H5 j1); intros.
 Omega'.
  Omega'.
  elim (H5 j1); intros; Omega'.
  elim (H5 j1); intros; Omega'.
  apply next_iteration with (j := j1).
  Omega'.
  Omega'.
  assumption.
  subst j2; apply (H5 j1); Omega'.
  (* ~(match a k p `0` M) *)
  elim (Z_lt_ge_dec k (i1 - j1)); intro Hck.
  (* k < i0-j0 *)
  apply (H20 k); assumption || Omega'.
  elim (Z_ge_lt_dec (i1 - j1) k); intro Hck'.
  (* k = i0-j0 *)
  generalize H21.
 replace k with (i1 - j1)%Z.
  apply match_contradiction_at_i with (i := j1).
  Omega'.
 Omega'.
 ring (i1 - j1 + j1)%Z.
 ring (0 + j1)%Z.
 assumption.
 Omega'.
   (* i0-j0 < k *)
  generalize H21.
 rewrite <- H.
  apply next_is_maximal with (i := i1) (j := j1) (n := access next0 j1).
   Omega'.
 Omega'.
 Omega'.
  assumption.
  apply (H5 j1); Omega'.
  unfold lexZ, lex, Zwf, pairZ.
   elim (H5 j1).
 intros.
  right.
 Omega'.
 Omega'.
Qed.

Proof.
intuition; rewrite Pre13; assumption.
Qed.

Definition first_occur (p a:array A) (r:Z) :=
  ((0 <= r < array_length a)%Z -> match_ a r p 0 (array_length p)) /\
  (forall k:Z, (0 <= k < r)%Z -> ~ match_ a k p 0 (array_length p)).

Proof.
intuition.
generalize M_positive; Omega'.
generalize N_positive; Omega'.
subst i j.
apply match_empty.
generalize N_positive; Omega'.
 generalize M_positive; Omega'.
Qed.

Proof.
intros.
decompose [and] Inv.
unfold first_occur.
 split.
 intro.
 rewrite <- Test10.
  replace (array_length p) with j1.
 assumption.
 Omega'.
replace (i1 - M)%Z with (i1 - j1)%Z.
 replace (array_length p) with M.
 assumption.
 Omega'.
Omega'.
Qed.

Proof.
intros.
 unfold first_occur.
 decompose [and] Inv.
split.
 intro.
 absurd (i1 < N)%Z; Omega'.
intros k Hk.
 elim (Z_lt_ge_dec k (i1 - j1)); intro Hk'.
replace (array_length p) with M.
apply H6; Omega'.
 Omega'.
red; intro.
 decompose [match_] H4.
absurd (k <= N - M)%Z; Omega'.
Qed.


(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma kmp_po_1 : 
  forall (a: (array A)),
  forall (next: (array Z)),
  forall (p: (array A)),
  forall (HW_1: (array_length p) = M /\ (array_length next) = M /\
                (array_length a) = N),
  (array_length p) = M /\ (array_length next) = M.
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma kmp_po_2 : 
  forall (a: (array A)),
  forall (next: (array Z)),
  forall (p: (array A)),
  forall (HW_1: (array_length p) = M /\ (array_length next) = M /\
                (array_length a) = N),
  forall (HW_2: (array_length p) = M /\ (array_length next) = M),
  forall (next0: (array Z)),
  forall (HW_3: (array_length next0) = M /\
                (forall (j:Z),
                 (0 < j /\ j < M -> (Next p j (access next0 j))))),
  (well_founded lexZ).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma kmp_po_3 : 
  forall (a: (array A)),
  forall (next: (array Z)),
  forall (p: (array A)),
  forall (HW_1: (array_length p) = M /\ (array_length next) = M /\
                (array_length a) = N),
  forall (HW_2: (array_length p) = M /\ (array_length next) = M),
  forall (next0: (array Z)),
  forall (HW_3: (array_length next0) = M /\
                (forall (j:Z),
                 (0 < j /\ j < M -> (Next p j (access next0 j))))),
  (0 <= 0 /\ 0 <= M) /\ (0 <= 0 /\ 0 <= N) /\ (match_ a (0 - 0) p 0 0) /\
  (forall (k:Z), (0 <= k /\ k < (0 - 0) -> ~(match_ a k p 0 M))).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma kmp_po_4 : 
  forall (a: (array A)),
  forall (next: (array Z)),
  forall (p: (array A)),
  forall (HW_1: (array_length p) = M /\ (array_length next) = M /\
                (array_length a) = N),
  forall (HW_2: (array_length p) = M /\ (array_length next) = M),
  forall (next0: (array Z)),
  forall (HW_3: (array_length next0) = M /\
                (forall (j:Z),
                 (0 < j /\ j < M -> (Next p j (access next0 j))))),
  forall (HW_4: (0 <= 0 /\ 0 <= M) /\ (0 <= 0 /\ 0 <= N) /\
                (match_ a (0 - 0) p 0 0) /\
                (forall (k:Z), (0 <= k /\ k < (0 - 0) -> ~(match_ a k p 0 M)))),
  forall (i: Z),
  forall (j: Z),
  forall (HW_5: (0 <= j /\ j <= M) /\ (j <= i /\ i <= N) /\
                (match_ a (i - j) p 0 j) /\
                (forall (k:Z), (0 <= k /\ k < (i - j) -> ~(match_ a k p 0 M)))),
  forall (HW_6: j < M),
  forall (HW_7: i < N),
  0 <= i /\ i < (array_length a).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma kmp_po_5 : 
  forall (a: (array A)),
  forall (next: (array Z)),
  forall (p: (array A)),
  forall (HW_1: (array_length p) = M /\ (array_length next) = M /\
                (array_length a) = N),
  forall (HW_2: (array_length p) = M /\ (array_length next) = M),
  forall (next0: (array Z)),
  forall (HW_3: (array_length next0) = M /\
                (forall (j:Z),
                 (0 < j /\ j < M -> (Next p j (access next0 j))))),
  forall (HW_4: (0 <= 0 /\ 0 <= M) /\ (0 <= 0 /\ 0 <= N) /\
                (match_ a (0 - 0) p 0 0) /\
                (forall (k:Z), (0 <= k /\ k < (0 - 0) -> ~(match_ a k p 0 M)))),
  forall (i: Z),
  forall (j: Z),
  forall (HW_5: (0 <= j /\ j <= M) /\ (j <= i /\ i <= N) /\
                (match_ a (i - j) p 0 j) /\
                (forall (k:Z), (0 <= k /\ k < (i - j) -> ~(match_ a k p 0 M)))),
  forall (HW_6: j < M),
  forall (HW_7: i < N),
  forall (HW_8: 0 <= i /\ i < (array_length a)),
  forall (result: A),
  forall (HW_9: result = (access a i)),
  0 <= j /\ j < (array_length p).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma kmp_po_6 : 
  forall (a: (array A)),
  forall (next: (array Z)),
  forall (p: (array A)),
  forall (HW_1: (array_length p) = M /\ (array_length next) = M /\
                (array_length a) = N),
  forall (HW_2: (array_length p) = M /\ (array_length next) = M),
  forall (next0: (array Z)),
  forall (HW_3: (array_length next0) = M /\
                (forall (j:Z),
                 (0 < j /\ j < M -> (Next p j (access next0 j))))),
  forall (HW_4: (0 <= 0 /\ 0 <= M) /\ (0 <= 0 /\ 0 <= N) /\
                (match_ a (0 - 0) p 0 0) /\
                (forall (k:Z), (0 <= k /\ k < (0 - 0) -> ~(match_ a k p 0 M)))),
  forall (i: Z),
  forall (j: Z),
  forall (HW_5: (0 <= j /\ j <= M) /\ (j <= i /\ i <= N) /\
                (match_ a (i - j) p 0 j) /\
                (forall (k:Z), (0 <= k /\ k < (i - j) -> ~(match_ a k p 0 M)))),
  forall (HW_6: j < M),
  forall (HW_7: i < N),
  forall (HW_8: 0 <= i /\ i < (array_length a)),
  forall (result: A),
  forall (HW_9: result = (access a i)),
  forall (HW_10: 0 <= j /\ j < (array_length p)),
  forall (result0: A),
  forall (HW_11: result0 = (access p j)),
  forall (HW_12: result = result0),
  forall (i0: Z),
  forall (HW_13: i0 = (i + 1)),
  forall (j0: Z),
  forall (HW_14: j0 = (j + 1)),
  ((0 <= j0 /\ j0 <= M) /\ (j0 <= i0 /\ i0 <= N) /\
  (match_ a (i0 - j0) p 0 j0) /\
  (forall (k:Z), (0 <= k /\ k < (i0 - j0) -> ~(match_ a k p 0 M)))) /\
  (lexZ (pairZ (N - i0) j0) (pairZ (N - i) j)).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma kmp_po_7 : 
  forall (a: (array A)),
  forall (next: (array Z)),
  forall (p: (array A)),
  forall (HW_1: (array_length p) = M /\ (array_length next) = M /\
                (array_length a) = N),
  forall (HW_2: (array_length p) = M /\ (array_length next) = M),
  forall (next0: (array Z)),
  forall (HW_3: (array_length next0) = M /\
                (forall (j:Z),
                 (0 < j /\ j < M -> (Next p j (access next0 j))))),
  forall (HW_4: (0 <= 0 /\ 0 <= M) /\ (0 <= 0 /\ 0 <= N) /\
                (match_ a (0 - 0) p 0 0) /\
                (forall (k:Z), (0 <= k /\ k < (0 - 0) -> ~(match_ a k p 0 M)))),
  forall (i: Z),
  forall (j: Z),
  forall (HW_5: (0 <= j /\ j <= M) /\ (j <= i /\ i <= N) /\
                (match_ a (i - j) p 0 j) /\
                (forall (k:Z), (0 <= k /\ k < (i - j) -> ~(match_ a k p 0 M)))),
  forall (HW_6: j < M),
  forall (HW_7: i < N),
  forall (HW_8: 0 <= i /\ i < (array_length a)),
  forall (result: A),
  forall (HW_9: result = (access a i)),
  forall (HW_10: 0 <= j /\ j < (array_length p)),
  forall (result0: A),
  forall (HW_11: result0 = (access p j)),
  forall (HW_15: ~result = result0),
  forall (HW_16: j = 0),
  forall (i0: Z),
  forall (HW_17: i0 = (i + 1)),
  ((0 <= j /\ j <= M) /\ (j <= i0 /\ i0 <= N) /\ (match_ a (i0 - j) p 0 j) /\
  (forall (k:Z), (0 <= k /\ k < (i0 - j) -> ~(match_ a k p 0 M)))) /\
  (lexZ (pairZ (N - i0) j) (pairZ (N - i) j)).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma kmp_po_8 : 
  forall (a: (array A)),
  forall (next: (array Z)),
  forall (p: (array A)),
  forall (HW_1: (array_length p) = M /\ (array_length next) = M /\
                (array_length a) = N),
  forall (HW_2: (array_length p) = M /\ (array_length next) = M),
  forall (next0: (array Z)),
  forall (HW_3: (array_length next0) = M /\
                (forall (j:Z),
                 (0 < j /\ j < M -> (Next p j (access next0 j))))),
  forall (HW_4: (0 <= 0 /\ 0 <= M) /\ (0 <= 0 /\ 0 <= N) /\
                (match_ a (0 - 0) p 0 0) /\
                (forall (k:Z), (0 <= k /\ k < (0 - 0) -> ~(match_ a k p 0 M)))),
  forall (i: Z),
  forall (j: Z),
  forall (HW_5: (0 <= j /\ j <= M) /\ (j <= i /\ i <= N) /\
                (match_ a (i - j) p 0 j) /\
                (forall (k:Z), (0 <= k /\ k < (i - j) -> ~(match_ a k p 0 M)))),
  forall (HW_6: j < M),
  forall (HW_7: i < N),
  forall (HW_8: 0 <= i /\ i < (array_length a)),
  forall (result: A),
  forall (HW_9: result = (access a i)),
  forall (HW_10: 0 <= j /\ j < (array_length p)),
  forall (result0: A),
  forall (HW_11: result0 = (access p j)),
  forall (HW_15: ~result = result0),
  forall (HW_18: j <> 0),
  0 <= j /\ j < (array_length next0).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma kmp_po_9 : 
  forall (a: (array A)),
  forall (next: (array Z)),
  forall (p: (array A)),
  forall (HW_1: (array_length p) = M /\ (array_length next) = M /\
                (array_length a) = N),
  forall (HW_2: (array_length p) = M /\ (array_length next) = M),
  forall (next0: (array Z)),
  forall (HW_3: (array_length next0) = M /\
                (forall (j:Z),
                 (0 < j /\ j < M -> (Next p j (access next0 j))))),
  forall (HW_4: (0 <= 0 /\ 0 <= M) /\ (0 <= 0 /\ 0 <= N) /\
                (match_ a (0 - 0) p 0 0) /\
                (forall (k:Z), (0 <= k /\ k < (0 - 0) -> ~(match_ a k p 0 M)))),
  forall (i: Z),
  forall (j: Z),
  forall (HW_5: (0 <= j /\ j <= M) /\ (j <= i /\ i <= N) /\
                (match_ a (i - j) p 0 j) /\
                (forall (k:Z), (0 <= k /\ k < (i - j) -> ~(match_ a k p 0 M)))),
  forall (HW_6: j < M),
  forall (HW_7: i < N),
  forall (HW_8: 0 <= i /\ i < (array_length a)),
  forall (result: A),
  forall (HW_9: result = (access a i)),
  forall (HW_10: 0 <= j /\ j < (array_length p)),
  forall (result0: A),
  forall (HW_11: result0 = (access p j)),
  forall (HW_15: ~result = result0),
  forall (HW_18: j <> 0),
  forall (HW_19: 0 <= j /\ j < (array_length next0)),
  forall (result1: Z),
  forall (HW_20: result1 = (access next0 j)),
  forall (j0: Z),
  forall (HW_21: j0 = result1),
  ((0 <= j0 /\ j0 <= M) /\ (j0 <= i /\ i <= N) /\
  (match_ a (i - j0) p 0 j0) /\
  (forall (k:Z), (0 <= k /\ k < (i - j0) -> ~(match_ a k p 0 M)))) /\
  (lexZ (pairZ (N - i) j0) (pairZ (N - i) j)).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma kmp_po_10 : 
  forall (a: (array A)),
  forall (next: (array Z)),
  forall (p: (array A)),
  forall (HW_1: (array_length p) = M /\ (array_length next) = M /\
                (array_length a) = N),
  forall (HW_2: (array_length p) = M /\ (array_length next) = M),
  forall (next0: (array Z)),
  forall (HW_3: (array_length next0) = M /\
                (forall (j:Z),
                 (0 < j /\ j < M -> (Next p j (access next0 j))))),
  forall (HW_4: (0 <= 0 /\ 0 <= M) /\ (0 <= 0 /\ 0 <= N) /\
                (match_ a (0 - 0) p 0 0) /\
                (forall (k:Z), (0 <= k /\ k < (0 - 0) -> ~(match_ a k p 0 M)))),
  forall (i: Z),
  forall (j: Z),
  forall (HW_5: (0 <= j /\ j <= M) /\ (j <= i /\ i <= N) /\
                (match_ a (i - j) p 0 j) /\
                (forall (k:Z), (0 <= k /\ k < (i - j) -> ~(match_ a k p 0 M)))),
  forall (HW_6: j < M),
  forall (HW_22: i >= N),
  forall (HW_23: j = M),
  (first_occur p a (i - M)).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma kmp_po_11 : 
  forall (a: (array A)),
  forall (next: (array Z)),
  forall (p: (array A)),
  forall (HW_1: (array_length p) = M /\ (array_length next) = M /\
                (array_length a) = N),
  forall (HW_2: (array_length p) = M /\ (array_length next) = M),
  forall (next0: (array Z)),
  forall (HW_3: (array_length next0) = M /\
                (forall (j:Z),
                 (0 < j /\ j < M -> (Next p j (access next0 j))))),
  forall (HW_4: (0 <= 0 /\ 0 <= M) /\ (0 <= 0 /\ 0 <= N) /\
                (match_ a (0 - 0) p 0 0) /\
                (forall (k:Z), (0 <= k /\ k < (0 - 0) -> ~(match_ a k p 0 M)))),
  forall (i: Z),
  forall (j: Z),
  forall (HW_5: (0 <= j /\ j <= M) /\ (j <= i /\ i <= N) /\
                (match_ a (i - j) p 0 j) /\
                (forall (k:Z), (0 <= k /\ k < (i - j) -> ~(match_ a k p 0 M)))),
  forall (HW_6: j < M),
  forall (HW_22: i >= N),
  forall (HW_24: j <> M),
  (first_occur p a i).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma kmp_po_12 : 
  forall (a: (array A)),
  forall (next: (array Z)),
  forall (p: (array A)),
  forall (HW_1: (array_length p) = M /\ (array_length next) = M /\
                (array_length a) = N),
  forall (HW_2: (array_length p) = M /\ (array_length next) = M),
  forall (next0: (array Z)),
  forall (HW_3: (array_length next0) = M /\
                (forall (j:Z),
                 (0 < j /\ j < M -> (Next p j (access next0 j))))),
  forall (HW_4: (0 <= 0 /\ 0 <= M) /\ (0 <= 0 /\ 0 <= N) /\
                (match_ a (0 - 0) p 0 0) /\
                (forall (k:Z), (0 <= k /\ k < (0 - 0) -> ~(match_ a k p 0 M)))),
  forall (i: Z),
  forall (j: Z),
  forall (HW_5: (0 <= j /\ j <= M) /\ (j <= i /\ i <= N) /\
                (match_ a (i - j) p 0 j) /\
                (forall (k:Z), (0 <= k /\ k < (i - j) -> ~(match_ a k p 0 M)))),
  forall (HW_25: j >= M),
  forall (HW_26: j = M),
  (first_occur p a (i - M)).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma kmp_po_13 : 
  forall (a: (array A)),
  forall (next: (array Z)),
  forall (p: (array A)),
  forall (HW_1: (array_length p) = M /\ (array_length next) = M /\
                (array_length a) = N),
  forall (HW_2: (array_length p) = M /\ (array_length next) = M),
  forall (next0: (array Z)),
  forall (HW_3: (array_length next0) = M /\
                (forall (j:Z),
                 (0 < j /\ j < M -> (Next p j (access next0 j))))),
  forall (HW_4: (0 <= 0 /\ 0 <= M) /\ (0 <= 0 /\ 0 <= N) /\
                (match_ a (0 - 0) p 0 0) /\
                (forall (k:Z), (0 <= k /\ k < (0 - 0) -> ~(match_ a k p 0 M)))),
  forall (i: Z),
  forall (j: Z),
  forall (HW_5: (0 <= j /\ j <= M) /\ (j <= i /\ i <= N) /\
                (match_ a (i - j) p 0 j) /\
                (forall (k:Z), (0 <= k /\ k < (i - j) -> ~(match_ a k p 0 M)))),
  forall (HW_25: j >= M),
  forall (HW_27: j <> M),
  (first_occur p a i).
Proof.
(* FILL PROOF HERE *)
Save.

