import os
import sys
import resource
import commands

UMASK = 0
if os.getuid() == 0:
	WORKDIR = '/'
else:
	WORKDIR = os.getcwd()
MAXFD = 1024

if (hasattr(os, 'devnull')):
	REDIRECT_TO = os.devnull
else:
	REDIRECT_TO = '/dev/null'

def createDaemon():
	try:
		pid = os.fork()
	except OSError, e:
		raise Exception, '%s [%d]' % (e.strerror, e.errno)

	if (pid == 0):
		os.setsid()
		try:
			pid = os.fork()
		except OSError, e:
			raise Exception, '%s [%d]' % (e.strerror, e.errno)

		if (pid == 0):
			os.chdir(WORKDIR)
			os.umask(UMASK)
		else:
			os._exit(0)
	else:
		os._exit(0)

	maxfd = resource.getrlimit(resource.RLIMIT_NOFILE)[1]
	if (maxfd == resource.RLIM_INFINITY):
		maxfd = MAXFD
  
	for fd in range(0, maxfd):
		try:
			os.close(fd)
		except OSError:
			pass

	userinfo = commands.getoutput('getent passwd willowng')
	if len(userinfo):
		uid = int(userinfo.split(':')[2])
		gid = int(userinfo.split(':')[3])
		pidfile = open('/var/run/willowng.pid', 'w')
		pidfile.write(str(os.getpid()))
		pidfile.close()
		os.setgid(gid)
		os.setuid(uid)

	os.open(REDIRECT_TO, os.O_RDWR)
	os.dup2(0, 1)
	os.dup2(0, 2)
	return (0)
