/*
 * Create the main window.
 */

#include <gtk/gtk.h>
#include "config.h"
#include "defines.h"
#include "variables.h"
#include "mainwindow.h"
#include "actions.h"


static GtkWidget *edit;
static GtkWidget *set;
static GtkWidget *remove;

static gint list_sel_cb (GtkCList *clist,
                         gint row,
                         gint column,
                         GdkEventButton *event,
                         void *data)
{
        selected_row = row;
        gtk_widget_set_sensitive(edit, TRUE);
        gtk_widget_set_sensitive(set, TRUE);
        gtk_widget_set_sensitive(remove, TRUE);
        return TRUE;
}


gint list_unsel_cb (GtkCList *clist,
                    gint row,
                    gint column,
                    GdkEventButton *event,
                    void *data)
{
        selected_row = -1;
        gtk_widget_set_sensitive(edit, FALSE);
        gtk_widget_set_sensitive(set, FALSE);
        gtk_widget_set_sensitive(remove, FALSE);
        return TRUE;
}


void create_mainwindow()
{
        GtkWidget *main_vbox;
        GtkWidget *buttons_hbox;
        GtkWidget *left_vbox;
        GtkWidget *right_vbox;
        GtkWidget *bouton;
        GtkWidget *scrolled_window;
        GtkWidget *vbox;
        GtkWidget *label;
        GtkWidget *frame;
        GtkWidget *table;
        GtkWidget *notebook;
        gchar *clist_titles[COLS] = {
                " D ",
                " Box Type   ",
                " Mail Box   ",
                " Username   ",
                " Password   ",
                " Folder     "};


        /*** FENTRE PRINCIPALE ***/
        application = gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_window_set_title(GTK_WINDOW(application), PACKAGE"-config");
        /*-- Connexion aux signaux --*/
        gtk_signal_connect(GTK_OBJECT(application), "delete_event",
                           GTK_SIGNAL_FUNC(quit_app), NULL);
        gtk_signal_connect(GTK_OBJECT(application), "destroy",
                           GTK_SIGNAL_FUNC(quit_app), "WM destroy");
        /*-- Taille de la fentre --*/
        gtk_widget_set_usize(GTK_WIDGET(application), WIN_WIDTH, WIN_HEIGHT);
        gtk_widget_realize(application);

        /*** Zone principale de placement des widgets***/
        main_vbox = gtk_vbox_new(FALSE, 1);
        gtk_container_border_width(GTK_CONTAINER(main_vbox), 1);
        gtk_container_add(GTK_CONTAINER(application), main_vbox);
        gtk_widget_show(main_vbox);



        /*** WIDGETS DE DONNES ***/
        notebook = gtk_notebook_new();

        /*-- Zones des donnes simples --*/
        left_vbox = gtk_vbox_new(FALSE, 1);


        /*--- Frame 1 ---*/
        frame = gtk_frame_new(NULL);
        gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_IN);
        gtk_box_pack_start(GTK_BOX(left_vbox), frame, FALSE, TRUE, 1);
        gtk_widget_show(frame);

        vbox = gtk_vbox_new(FALSE, 1);
        gtk_container_add(GTK_CONTAINER(frame), vbox);
        gtk_widget_show(vbox);

        wid_backlight = gtk_check_button_new_with_label("Back light");
        gtk_box_pack_start(GTK_BOX(vbox), wid_backlight, FALSE, TRUE, 1);
        gtk_widget_show(wid_backlight);

        wid_blink = gtk_check_button_new_with_label("Blink");
        gtk_box_pack_start(GTK_BOX(vbox), wid_blink, FALSE, TRUE, 1);
        gtk_widget_show(wid_blink);

        wid_testsize = gtk_check_button_new_with_label("Check size");
        gtk_box_pack_start(GTK_BOX(vbox), wid_testsize, FALSE, TRUE, 1);
        gtk_widget_show(wid_testsize);

        /*--- Frame 2 ---*/
        frame = gtk_frame_new(NULL);
        gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_IN);
        gtk_box_pack_start(GTK_BOX(left_vbox), frame, FALSE, TRUE, 1);
        gtk_widget_show(frame);

        table = gtk_table_new(2, 3, FALSE);
        gtk_container_set_border_width(GTK_CONTAINER(table), 2);
        gtk_container_add(GTK_CONTAINER(frame), table);
        gtk_widget_show(table);

        label = gtk_label_new("Interval : ");
        gtk_misc_set_alignment(GTK_MISC(label), 0.0f, 0.5f);
        gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 0, 1);
        gtk_widget_show(label);

        wid_interval = gtk_entry_new();
        gtk_table_attach_defaults(GTK_TABLE(table), wid_interval, 1, 2, 0, 1);
        gtk_widget_show(wid_interval);

        label = gtk_label_new("Check delay : ");
        gtk_misc_set_alignment(GTK_MISC(label), 0.0f, 0.5f);
        gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 1, 2);
        gtk_widget_show(label);

        wid_checkdelay = gtk_entry_new();
        gtk_table_attach_defaults(GTK_TABLE(table), wid_checkdelay, 1, 2, 1, 2);
        gtk_widget_show(wid_checkdelay);

        label = gtk_label_new("Color : ");
        gtk_misc_set_alignment(GTK_MISC(label), 0.0f, 0.5f);
        gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 2, 3);
        gtk_widget_show(label);

        wid_color = gtk_entry_new();
        gtk_table_attach_defaults(GTK_TABLE(table), wid_color, 1, 2, 2, 3);
        gtk_widget_show(wid_color);

        /*--- Frame 3 ---*/
        frame = gtk_frame_new(NULL);
        gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_IN);
        gtk_box_pack_start(GTK_BOX(left_vbox), frame, FALSE, FALSE, 1);
        gtk_widget_show(frame);

        table = gtk_table_new(3, 2, FALSE);
        gtk_container_set_border_width(GTK_CONTAINER(table), 2);
        gtk_container_add(GTK_CONTAINER(frame), table);
        gtk_widget_show(table);

        label = gtk_label_new("Command : ");
        gtk_misc_set_alignment(GTK_MISC(label), 0.0f, 0.5f);
        gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 0, 1);
        gtk_widget_show(label);

        wid_command = gtk_entry_new();
        gtk_table_attach_defaults(GTK_TABLE(table), wid_command, 1, 2, 0, 1);
        gtk_widget_show(wid_command);

        label = gtk_label_new("Notify : ");
        gtk_misc_set_alignment(GTK_MISC(label), 0.0f, 0.5f);
        gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 1, 2);
        gtk_widget_show(label);

        wid_notify = gtk_entry_new();
        gtk_table_attach_defaults(GTK_TABLE(table), wid_notify, 1, 2, 1, 2);
        gtk_widget_show(wid_notify);

        wid_runonce = gtk_check_button_new_with_label("Run once");
        gtk_table_attach_defaults(GTK_TABLE(table), wid_runonce, 0, 2, 2, 3);
        gtk_widget_show(wid_runonce);


        label = gtk_label_new(" Misc options ");
        gtk_misc_set_alignment(GTK_MISC(label), 0.0f, 0.5f);
        gtk_notebook_append_page(GTK_NOTEBOOK(notebook), left_vbox, label);
        gtk_widget_show(label);
        gtk_widget_show(left_vbox);


        /*-- Liste des boites --*/
        right_vbox = gtk_vbox_new(FALSE, 1);


        scrolled_window = gtk_scrolled_window_new(NULL, NULL);
        gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window),
                                       GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

        filelist = gtk_clist_new_with_titles(COLS, clist_titles);
        selected_row = -1;
        gtk_signal_connect(GTK_OBJECT(filelist), "select-row",
                           GTK_SIGNAL_FUNC(list_sel_cb), NULL);
        gtk_signal_connect(GTK_OBJECT(filelist), "unselect-row",
                           GTK_SIGNAL_FUNC(list_unsel_cb), NULL);
        gtk_container_add(GTK_CONTAINER(scrolled_window), filelist);
        gtk_clist_set_auto_sort(GTK_CLIST(filelist), FALSE);
        gtk_widget_show(filelist);

        gtk_box_pack_start(GTK_BOX(right_vbox), scrolled_window, TRUE, TRUE, 1);
        gtk_widget_show(scrolled_window);

        /*--- Frame 4 ---*/
        frame = gtk_frame_new(NULL);
        gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_IN);
        gtk_box_pack_start(GTK_BOX(right_vbox), frame, FALSE, TRUE, 1);
        gtk_widget_show(frame);

        table = gtk_table_new(1, 3, FALSE);
        gtk_container_set_border_width(GTK_CONTAINER(table), 2);
        gtk_container_add(GTK_CONTAINER(frame), table);
        gtk_widget_show(table);

        bouton = gtk_button_new_with_label(" Edit entry ");
        gtk_signal_connect(GTK_OBJECT(bouton), "clicked",
                           GTK_SIGNAL_FUNC(edit_entry), NULL);
        gtk_table_attach_defaults(GTK_TABLE(table), bouton, 0, 1, 0, 1);
        gtk_widget_set_sensitive(bouton, FALSE);
        gtk_widget_show(bouton);
        edit = bouton;

        bouton = gtk_button_new_with_label(" Set default ");
        gtk_signal_connect(GTK_OBJECT(bouton), "clicked",
                           GTK_SIGNAL_FUNC(set_default), NULL);
        gtk_table_attach_defaults(GTK_TABLE(table), bouton, 1, 2, 0, 1);
        gtk_widget_set_sensitive(bouton, FALSE);
        gtk_widget_show(bouton);
        set = bouton;

        bouton = gtk_button_new_with_label(" Remove box ");
        gtk_signal_connect(GTK_OBJECT(bouton), "clicked",
                           GTK_SIGNAL_FUNC(remove_box), NULL);
        gtk_table_attach_defaults(GTK_TABLE(table), bouton, 2, 3, 0, 1);
        gtk_widget_set_sensitive(bouton, FALSE);
        gtk_widget_show(bouton);
        remove = bouton;

        /*--- Frame 5 ---*/
        frame = gtk_frame_new(NULL);
        gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_IN);
        gtk_box_pack_start(GTK_BOX(right_vbox), frame, FALSE, TRUE, 1);
        gtk_widget_show(frame);

        table = gtk_table_new(3, 2, FALSE);
        gtk_container_set_border_width(GTK_CONTAINER(table), 2);
        gtk_container_add(GTK_CONTAINER(frame), table);
        gtk_widget_show(table);

        bouton = gtk_button_new_with_label(" Add Mbox ");
        gtk_signal_connect(GTK_OBJECT(bouton), "clicked",
                           GTK_SIGNAL_FUNC(add_mbox), NULL);
        gtk_table_attach_defaults(GTK_TABLE(table), bouton, 0, 1, 0, 1);
        gtk_widget_show(bouton);

        bouton = gtk_button_new_with_label(" Add Maildir ");
        gtk_signal_connect(GTK_OBJECT(bouton), "clicked",
                           GTK_SIGNAL_FUNC(add_maildir), NULL);
        gtk_table_attach_defaults(GTK_TABLE(table), bouton, 0, 1, 1, 2);
        gtk_widget_show(bouton);

        bouton = gtk_button_new_with_label(" Add MH ");
        gtk_signal_connect(GTK_OBJECT(bouton), "clicked",
                           GTK_SIGNAL_FUNC(add_mh), NULL);
        gtk_table_attach_defaults(GTK_TABLE(table), bouton, 0, 1, 2, 3);
        gtk_widget_show(bouton);

        bouton = gtk_button_new_with_label(" Add POP3 ");
        gtk_signal_connect(GTK_OBJECT(bouton), "clicked",
                           GTK_SIGNAL_FUNC(add_pop3), NULL);
        gtk_table_attach_defaults(GTK_TABLE(table), bouton, 1, 2, 0, 1);
        gtk_widget_show(bouton);

        bouton = gtk_button_new_with_label(" Add IMAP ");
        gtk_signal_connect(GTK_OBJECT(bouton), "clicked",
                           GTK_SIGNAL_FUNC(add_imap), NULL);
        gtk_table_attach_defaults(GTK_TABLE(table), bouton, 1, 2, 1, 2);
        gtk_widget_show(bouton);

        bouton = gtk_button_new_with_label(" Add Hotmail ");
        gtk_signal_connect(GTK_OBJECT(bouton), "clicked",
                           GTK_SIGNAL_FUNC(add_hotmail), NULL);
        gtk_table_attach_defaults(GTK_TABLE(table), bouton, 1, 2, 2, 3);
        gtk_widget_show(bouton);


        label = gtk_label_new(" Mail boxes ");
        gtk_misc_set_alignment(GTK_MISC(label), 0.0f, 0.5f);
        gtk_notebook_append_page(GTK_NOTEBOOK(notebook), right_vbox, label);
        gtk_widget_show(label);
        gtk_widget_show(right_vbox);


        gtk_box_pack_start(GTK_BOX(main_vbox), notebook, TRUE, TRUE, 1);
        gtk_widget_show(notebook);



        /*** BOUTONS DE SAUVEGARDE ET ANNULATION ***/
        buttons_hbox = gtk_hbox_new(FALSE, 1);
        gtk_box_pack_start(GTK_BOX(main_vbox), buttons_hbox, FALSE, TRUE, 1);
        gtk_widget_show(buttons_hbox);


        bouton = gtk_button_new_with_label(" Save ");
        gtk_signal_connect(GTK_OBJECT(bouton), "clicked",
                           GTK_SIGNAL_FUNC(save_datas), NULL);
        gtk_signal_connect(GTK_OBJECT(bouton), "clicked",
                           GTK_SIGNAL_FUNC(quit_app), NULL);
        gtk_box_pack_start(GTK_BOX(buttons_hbox), bouton, TRUE, TRUE, 0);
        GTK_WIDGET_SET_FLAGS(GTK_WIDGET(bouton), GTK_CAN_DEFAULT);
        gtk_widget_grab_default(GTK_WIDGET(bouton));
        gtk_widget_draw_default(GTK_WIDGET(bouton));
        gtk_widget_show(bouton);

        bouton = gtk_button_new_with_label(" Cancel ");
        gtk_signal_connect(GTK_OBJECT(bouton), "clicked",
                           GTK_SIGNAL_FUNC(quit_app), NULL);
        gtk_box_pack_start(GTK_BOX(buttons_hbox), bouton, TRUE, TRUE, 0);
        GTK_WIDGET_SET_FLAGS(GTK_WIDGET(bouton), GTK_CAN_DEFAULT);
        gtk_widget_show(bouton);



        /*** AFFICHAGE DE LA FENTRE ***/
        gtk_widget_show(application);
}
