/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000-2004 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/



#include "QClipper.h"

#include <qglobal.h>

#ifdef HAVE_KDELIBS2
#include <kapp.h>
#else
#include <qapplication.h>
#endif

QClipper::QClipper() : QObject() {
	last="";

	intervalo_actual=1000;
	timer = new QTimer(this, "timer");
    connect(timer, SIGNAL(timeout()),
            this, SLOT(chequea()));
	start();
}

QClipper::~QClipper() {
	delete timer;
}

void QClipper::chequea() {
#if QT_VERSION >= 300
	qApp->clipboard()->setSelectionMode(TRUE);
#endif

	QString clipData = qApp->clipboard()->text();

	if (clipData.length() > 50) {
		clipData.truncate(50);
	}

	if(clipData != last) {		
		last = clipData.copy();
        if (clipData.isEmpty() || clipData.stripWhiteSpace().isEmpty()) {
			return;
        }
		emit clipboardChanged( clipData );
	}
}

void QClipper::start() {
	timer->start(intervalo_actual, FALSE);
}

void QClipper::stop() {
	timer->stop();
}

void QClipper::changeInterval( int msec ) {
	//debug("QClipper::changeInterval: %d", msec );
	intervalo_actual=msec;

	if (timer->isActive()) {
		//debug("timer activo, cambiando intervalo");
		timer->changeInterval( intervalo_actual );
	}
}

#include "QClipper.moc.cpp"
