/* dirbookmarkop.hh
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2007 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef DIRBOOKMARKOP_HH
#define DIRBOOKMARKOP_HH

#include "wdefines.h"
#include "functionproto.h"
#include <string>
#include <list>

class DirBookmarkOp : public FunctionProto
{
public:
    DirBookmarkOp();
    ~DirBookmarkOp();
    DirBookmarkOp( const DirBookmarkOp &other );
    DirBookmarkOp &operator=( const DirBookmarkOp &other );
    
    DirBookmarkOp *duplicate() const;
    virtual bool isName(const char *);
    virtual const char *getName();
    
    using FunctionProto::run;
    int run( WPUContext*, ActionMessage* );
    virtual const char *getDescription();
    
    static const char *name;
private:
    static class BookmarkDB *bookmarks;
    static int bookmarks_count;
};

#endif
