/* goftpop.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2005 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: goftpop.h,v 1.2 2005/10/19 18:04:42 ralf Exp $ */

#ifndef GOFTPOP_H
#define GOFTPOP_H

#include "wdefines.h"
#include "functionproto.h"
#include <string>
#include <vector>

class GoFTPOp:public FunctionProto
{
public:
  GoFTPOp();
  virtual ~GoFTPOp();
  GoFTPOp( const GoFTPOp &other );
  GoFTPOp &operator=( const GoFTPOp &other );

  virtual GoFTPOp *duplicate() const;
  virtual bool isName(const char *);
  virtual const char *getName();
#if ! ( defined ( __GNUC__ ) && ( __GNUC__ < 3 ) )
  using FunctionProto::run;
#endif
  virtual int run( WPUContext *wpu, ActionMessage* );
  virtual bool save(Datei*);
  virtual const char *getDescription();
  virtual int configure();
  
  int doconfigure(int mode);
  
  void setRequestFlags( bool );
  void setDontEnterFTP( bool );
  void setHost( std::string );
  void setUser( std::string );
  void setPass( std::string );
  void setAlwaysStorePW( bool );
  void setAVFSModule( const std::string & );
  static const char *name;
protected:
  // Infos to save

  bool requestflags, dontenterftp, always_store_pw;
  std::string host, user, pass;
  std::string avfs_module;
  
  // temp variables
  //  Lister *startlister,*endlister;
  
  bool tdontenterftp, talways_store_pw;
  std::string thost, tuser, tpass;
  std::string tavfs_module;

  bool pw_stored;

  std::vector<std::string> getAvailModules();
};

#endif
