/* pdatei.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2002-2006 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: pdatei.cc,v 1.9 2006/03/05 22:37:01 ralf Exp $ */

#include "pdatei.h"
#include <aguix/lowlevelfunc.h>
#include "worker_lfs.h"

PDatei::PDatei()
{
  type = PDATEI_UNKNOWN;
  fd = -1;
  name = "";
}

PDatei::~PDatei()
{
  if ( fd >=0 ) {
    close();
  }
}

int PDatei::open( const char *filename )
{
  char tbuf[5];
  unsigned char tbuf2[2];
  int r;
  enum pdatei_handler candidate = PDATEI_UNKNOWN;
  int basefd;

  close();

  if ( filename == NULL ) return 1;

  basefd = ::worker_open( filename, O_RDONLY, 0 );
  if ( basefd < 0 ) return 1;
  
  // identify type
  r = ::worker_read( basefd, tbuf, 4 );
  if ( r == 4 ) {
    if ( ( tbuf[0] == 'X' ) &&
	 ( tbuf[1] == 'P' ) &&
	 ( tbuf[2] == 'K' ) &&
	 ( tbuf[3] == 'F' ) ) {
      candidate = PDATEI_XPK;
    } else if ( ( tbuf[0] == 'B' ) &&
		( tbuf[1] == 'Z' ) &&
		( tbuf[2] == 'h' ) ) {
      candidate = PDATEI_BZIP2;
    } else {
      memcpy( tbuf2, tbuf, 2 );
      if ( ( tbuf2[0] == 0x1f ) &&
	   ( tbuf2[1] == 0x8b ) ) {
	candidate = PDATEI_GZIP;
      }
    }
  }
  ::worker_close( basefd );
  
  // try to open file
  if ( candidate == PDATEI_XPK ) {
    std::string vfsname = filename;
    vfsname += "#uxpkfile/CONTENT";
    fd = ::worker_open( vfsname.c_str(), O_RDONLY, 0 );
    if ( fd >= 0 ) {
      type = PDATEI_XPK;
      name = filename;
    }
  } else if ( candidate == PDATEI_BZIP2 ) {
    std::string vfsname = filename;
    vfsname += "#ubz2";
    fd = ::worker_open( vfsname.c_str(), O_RDONLY, 0 );
    if ( fd >= 0 ) {
      type = PDATEI_BZIP2;
      name = filename;
    }
  } else if ( candidate == PDATEI_GZIP ) {
    std::string vfsname = filename;
    vfsname += "#ugz";
    fd = ::worker_open( vfsname.c_str(), O_RDONLY, 0 );
    if ( fd >= 0 ) {
      type = PDATEI_GZIP;
      name = filename;
    }
  }
  if ( fd < 0 ) {
    fd = ::worker_open( filename, O_RDONLY, 0 );
    if ( fd >= 0 ) {
      type = PDATEI_NORMAL;
      name = filename;
    }
  }
  if ( fd < 0 ) return 1;
  return 0;
}

int PDatei::read( void *buf, int size )
{
  if ( fd < 0 || buf == NULL || size < 0 ) return -1;

  return ::worker_read( fd, buf, size );
}

void PDatei::close()
{
  if ( fd >= 0 ) {
    ::worker_close( fd );
    fd = -1;
    type = PDATEI_UNKNOWN;
    name = "";
  }
}

enum PDatei::pdatei_handler PDatei::getCruncher( const char *filename )
{
  PDatei p;
  enum pdatei_handler erg = PDATEI_UNKNOWN;

  if ( p.open( filename ) == 0 ) {
    erg = p.getHandler();
  }
  return erg;
}

enum PDatei::pdatei_handler PDatei::getHandler()
{
  return type;
}
