/* wconfig_colordef.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2006 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "wconfig.h"

WConfig::ColorDef::ColorDef()
{
    setTextViewTextColor( 1 );
    setTextViewBackground( 0 );
    setTextViewHighlightedFG( 1 );
    setTextViewHighlightedBG( 2 );
}
    
WConfig::ColorDef::~ColorDef()
{
}

WConfig::ColorDef &WConfig::ColorDef::operator=( const WConfig::ColorDef &other )
{
    if ( this != &other ) {
        setTextViewTextColor( other.getTextViewTextColor() );
        setTextViewBackground( other.getTextViewBackground() );
        setTextViewHighlightedFG( other.getTextViewHighlightedFG() );
        setTextViewHighlightedBG( other.getTextViewHighlightedBG() );
    }
    return *this;
}

void WConfig::ColorDef::setTextViewTextColor( int col )
{
    if ( col >= 0 ) {
        _textview_colors.textcolor = col;
        AGUIX::setColorForName( "TextView::textcolor", col );
    }
}
    
int WConfig::ColorDef::getTextViewTextColor() const
{
    return _textview_colors.textcolor;
}
    
void WConfig::ColorDef::setTextViewBackground( int col )
{
    if ( col >= 0 ) {
        _textview_colors.background = col;
        AGUIX::setColorForName( "TextView::background", col );
    }
}
    
int WConfig::ColorDef::getTextViewBackground() const
{
    return _textview_colors.background;
}
    
void WConfig::ColorDef::setTextViewHighlightedFG( int col )
{
    if ( col >= 0 ) {
        _textview_colors.highlightedfg = col;
        AGUIX::setColorForName( "TextView::highlightedfg", col );
    }
}
    
int WConfig::ColorDef::getTextViewHighlightedFG() const
{
    return _textview_colors.highlightedfg;
}
    
void WConfig::ColorDef::setTextViewHighlightedBG( int col )
{
    if ( col >= 0 ) {
        _textview_colors.highlightedbg = col;
        AGUIX::setColorForName( "TextView::highlightedbg", col );
    }
}
    
int WConfig::ColorDef::getTextViewHighlightedBG() const
{
    return _textview_colors.highlightedbg;
}
