/* wconfig_filetype.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2006 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "wconfig_filetype.hh"
#include "wconfig.h"
#include "worker.h"
#include "wcfiletype.hh"

FiletypePanel::FiletypePanel( AWindow &basewin, WConfig &baseconfig ) : WConfigPanel( basewin, baseconfig )
{
  cutft = NULL;
  l1 = NULL;
  tempconfig = _baseconfig.duplicate();
  allowRemoveUnique = false;
}

FiletypePanel::~FiletypePanel()
{
  if ( cutft != NULL ) delete cutft;
  if ( l1 != NULL ) delete l1;
  delete tempconfig;
}

int FiletypePanel::create()
{
  int res;
  
  res = Panel::create();

  AContainer *ac1 = setContainer( new AContainer( this, 1, 3 ), true );
  ac1->setMinSpace( 5 );
  ac1->setMaxSpace( 5 );
  
  addMultiLineText( catalog.getLocale( 683 ),
                    *ac1,
                    0, 0,
                    NULL, NULL );

  lv = (FieldListView*)ac1->add( new FieldListView( _aguix, 0, 0, 100, 150, 0 ), 0, 1, AContainer::CMIN );
  lv->setHBarState( 2 );
  lv->setVBarState( 2 );
  lv->setAcceptFocus( true );
  lv->setDisplayFocus( true );

  AContainer *ac1_1 = ac1->add( new AContainer( this, 1, 3 ), 0, 2 );
  ac1_1->setBorderWidth( 0 );
  ac1_1->setMinSpace( 5 );
  ac1_1->setMaxSpace( 5 );

  AContainer *ac1_1_1 = ac1_1->add( new AContainer( this, 3, 1 ), 0, 0 );
  ac1_1_1->setBorderWidth( 0 );
  ac1_1_1->setMinSpace( 0 );
  ac1_1_1->setMaxSpace( 0 );

  newb = (Button*)ac1_1_1->add( new Button( _aguix, 0, 0, catalog.getLocale( 85 ), 1, 0, 0 ), 0, 0, AContainer::CINCW );
  newb->connect( this );
  newchildb = (Button*)ac1_1_1->add( new Button( _aguix, 0, 0, catalog.getLocale( 596 ), 1, 0, 0 ), 1, 0, AContainer::CINCW );
  newchildb->connect( this );
  dupb = (Button*)ac1_1_1->add( new Button( _aguix, 0, 0, catalog.getLocale( 86 ), 1, 0, 0 ), 2, 0, AContainer::CINCW );
  dupb->connect( this );

  AContainer *ac1_1_2 = ac1_1->add( new AContainer( this, 2, 1 ), 0, 1 );
  ac1_1_2->setBorderWidth( 0 );
  ac1_1_2->setMinSpace( 5 );
  ac1_1_2->setMaxSpace( 5 );

  editb = (Button*)ac1_1_2->add( new Button( _aguix, 0, 0, catalog.getLocale( 88 ), 1, 0, 0 ), 0, 0, AContainer::CINCW );
  editb->connect( this );
  delb = (Button*)ac1_1_2->add( new Button( _aguix, 0, 0, catalog.getLocale( 87 ), 1, 0, 0 ), 1, 0, AContainer::CINCW );
  delb->connect( this );

  AContainer *ac1_1_3 = ac1_1->add( new AContainer( this, 3, 1 ), 0, 2 );
  ac1_1_3->setBorderWidth( 0 );
  ac1_1_3->setMinSpace( 0 );
  ac1_1_3->setMaxSpace( 0 );

  cutb = (Button*)ac1_1_3->add( new Button( _aguix, 0, 0, catalog.getLocale( 598 ), 1, 0, 0 ), 0, 0, AContainer::CINCW );
  cutb->connect( this );
  pasteb = (Button*)ac1_1_3->add( new Button( _aguix, 0, 0, catalog.getLocale( 599 ), 1, 0, 0 ), 1, 0, AContainer::CINCW );
  pasteb->connect( this );
  pastechildb = (Button*)ac1_1_3->add( new Button( _aguix, 0, 0, catalog.getLocale( 600 ), 1, 0, 0 ), 2, 0, AContainer::CINCW );
  pastechildb->connect( this );

  tempconfig->getFiletypes()->sort( WCFiletype::sortfunction, 0 );
  l1 = FlatTypeList::getFlatTypeList( tempconfig->getFiletypes() );

  FlatTypeList::buildLV( lv, l1, NULL );

  contMaximize( true );
  return 0;
}

int FiletypePanel::saveValues()
{
  _baseconfig.setFiletypes( tempconfig->getFiletypes() );
  return 0;
}

void FiletypePanel::run( Widget *elem, AGMessage &msg )
{
  List *filetypes = tempconfig->getFiletypes();
  int row;
  std::string s1;
  WCFiletype *pft;
  bool rem;

  if ( _need_recreate == true ) return;

  if ( msg.type == AG_BUTTONCLICKED ) {
    if ( msg.button.button == newb ) {
      WCFiletype *tf1 = new WCFiletype();
      if ( tempconfig->configureFiletype( tf1 ) == true ) {
	filetypes->addElement( tf1 );
	updateConf( filetypes, &l1, lv, tf1 );
      } else {
	delete tf1;
      }
    } else if ( msg.button.button == newchildb ) {
      row = lv->getActiveRow();
      if ( ( lv->isValidRow( row ) == true ) &&
	   ( row < (int)l1->size() ) ) {
	if ( (*l1)[ row ].filetype != NULL ) {
	  WCFiletype *tf1 = (*l1)[ row ].filetype;
	  if( tf1->getinternID() == NORMALTYPE ) {
	    WCFiletype *tf2 = new WCFiletype();
	    if ( tempconfig->configureFiletype( tf2 ) == true ) {
	      tf1->addSubType( tf2 );
	      updateConf( filetypes, &l1, lv, tf2 );
	    } else {
	      delete tf2;
	    }
	  }
	}
      }
    } else if ( msg.button.button == dupb ) {
      row = lv->getActiveRow();
      if ( ( lv->isValidRow( row ) == true ) &&
	   ( row < (int)l1->size() ) ) {
	if ( (*l1)[ row ].filetype != NULL ) {
	  WCFiletype *tf1 = (*l1)[ row ].filetype;
	  WCFiletype *tf2 = tf1->duplicate();
	  tf2->setinternID( NORMALTYPE );
	  pft = findParent( l1, row );
	  if ( pft == NULL ) {
	    // no parent
	    filetypes->addElement( tf2 );
	  } else {
	    pft->addSubType( tf2 );
	  }
	  updateConf( filetypes, &l1, lv, tf2 );
	}
      }
    } else if ( msg.button.button == delb ) {
      row = lv->getActiveRow();
      if ( ( lv->isValidRow( row ) == true ) &&
	   ( row < (int)l1->size() ) ) {
	if ( (*l1)[ row ].filetype != NULL ) {
	  WCFiletype *tf1 = (*l1)[ row ].filetype;
	  if( ( tf1->getinternID() == NORMALTYPE ) ||
	      ( allowRemoveUnique == true ) ) {
	    rem = true;
	    if ( tf1->getSubTypeList() != NULL ) {
	      if ( tf1->getSubTypeList()->size() > 0 ) {
		s1 = catalog.getLocale( 11 );
		s1 += "|";
		s1 += catalog.getLocale( 8 );
		int erg = request( catalog.getLocale( 123 ),
                                   catalog.getLocale( 597 ),
                                   s1.c_str() );
		if ( erg != 0 ) rem = false;
	      }
	    }
	    if ( rem == true ) {
	      pft = findParent( l1, row );
	      if ( pft == NULL ) {
		// no parent
		filetypes->removeElement( tf1 );
	      } else {
		pft->removeSubType( tf1 );
	      }
	      delete tf1;
	      
	      updateConf( filetypes, &l1, lv, NULL );
	    }
	  }
	}
      }
    } else if ( msg.button.button == cutb ) {
      row = lv->getActiveRow();
      if ( ( lv->isValidRow( row ) == true ) &&
	   ( row < (int)l1->size() ) ) {
	if ( (*l1)[ row ].filetype != NULL ) {
	  WCFiletype *tf1 = (*l1)[ row ].filetype;
	  if( ( tf1->getinternID() == NORMALTYPE ) ||
	      ( allowRemoveUnique == true ) ) {
	    pft = findParent( l1, row );
	    if ( pft == NULL ) {
	      // no parent
	      filetypes->removeElement( tf1 );
	    } else {
	      pft->removeSubType( tf1 );
	    }
	    tf1->setParentType( NULL );
	    if ( cutft != NULL ) {
	      delete cutft;
	    }
	    cutft = tf1;
	    
	    updateConf( filetypes, &l1, lv, NULL );
	  }
	}
      }
    } else if ( msg.button.button == pastechildb ) {
      if ( cutft != NULL ) {
	row = lv->getActiveRow();
	if ( ( lv->isValidRow( row ) == true ) &&
	     ( row < (int)l1->size() ) ) {
	  if ( (*l1)[ row ].filetype != NULL ) {
	    WCFiletype *tf1 = (*l1)[ row ].filetype;
	    if( tf1->getinternID() == NORMALTYPE ) {
	      tf1->addSubType( cutft );
	      updateConf( filetypes, &l1, lv, cutft );
	      cutft = NULL;
	    }
	  }
	}
      }
    } else if ( msg.button.button == pasteb ) {
      if ( cutft != NULL ) {
	filetypes->addElement( cutft );
	updateConf( filetypes, &l1, lv, cutft );
	cutft = NULL;
      }
    } else if ( msg.button.button == editb ) {
      row = lv->getActiveRow();
      if ( ( lv->isValidRow( row ) == true ) &&
	   ( row < (int)l1->size() ) ) {
	if ( (*l1)[ row ].filetype != NULL ) {
	  WCFiletype *tf1 = (*l1)[ row ].filetype;
	  if ( tempconfig->configureFiletype( tf1 ) == true ) {
	    updateConf( filetypes, &l1, lv, tf1 );
	  }
	}
      }
    }
  }
}

WCFiletype *FiletypePanel::findParent( std::vector<FlatTypeList::flattypelist_t> *flatlist, int row )
{
  int d;
  
  if ( flatlist == NULL ) return NULL;
  if ( row >= (int)flatlist->size() ) return NULL;
  
  d = (*flatlist)[ row ].depth;
  if ( d == 0 ) return NULL;
  while ( (*flatlist)[ row ].depth >= d ) {
    row--;
    if ( row < 0 ) return NULL;
  }
  return (*flatlist)[ row ].filetype;
}

void FiletypePanel::updateConf( List *filetypes,
				std::vector<FlatTypeList::flattypelist_t> **flatlist,
				FieldListView *tlv,
				WCFiletype *highlightft )
{
  if ( filetypes == NULL ) return;
  if ( flatlist == NULL ) return;
  if ( *flatlist == NULL ) return;
  if ( tlv == NULL ) return;
  
  filetypes->sort( WCFiletype::sortfunction, 0 );
  delete *flatlist;
  *flatlist = FlatTypeList::getFlatTypeList( filetypes );
  FlatTypeList::buildLV( tlv, *flatlist, highlightft );
  tlv->showActive();
  tlv->redraw();
}

void FiletypePanel::setAllowRemoveUnique( bool nv )
{
  allowRemoveUnique = nv;
}

WConfigPanel::panel_action_t FiletypePanel::setColors( List *colors )
{
  if ( colors != tempconfig->getColors() ) {
    tempconfig->setColors( colors );
  }

  return PANEL_NOACTION;
}

int FiletypePanel::addFiletypes( List *filetypes,
                                 WConfigPanelCallBack::add_action_t action )
{
  int erg = 0;

  if ( filetypes != NULL && action == WConfigPanelCallBack::DO_IMPORT ) {
    erg = tempconfig->addFiletypes( filetypes );
  }
  _need_recreate = true;
  return erg;
}

