// $Id: ETRotate.cpp,v 1.1 2003/02/08 13:14:51 mrq Exp $

#include "ETRotate.h"

#include "Application.h"
#include <sstream>

ETRotate::ETRotate (World *world) : EntityTool (world), m_Entity (NULL)
{}

ETRotate::~ETRotate()
{
   if (m_Entity) m_Entity->Unref();
}

/// Apply tool at (x,z)
void
ETRotate::Apply3D(Ark::Vector3 newpos, const Ark::Collision &col)
{
   if (col.GetType() == Ark::Collision::ENTITY && m_Entity == NULL)
   {
      m_Entity = static_cast<Entity*>(col.m_Entity);
      m_Entity->Ref();
      m_OldPos = col.m_Pos;
      m_OldRot = m_Entity->m_MState.m_Rotation;
      return;
   }
   else if (m_Entity)
   {
      m_NewPos = col.m_Pos;
      m_NewRot = 
      m_Entity->m_MState.m_Rotation =
	 (m_OldRot *
	  Ark::Quat (0.0f, (newpos.Z-m_OldPos.Z)*20.0, 0.0f));
      g_Application->GetWorld()->Update(0.0);
   }
}

/// Update or reset tool
void
ETRotate::Update()
{
   if (m_Entity)
   {
      m_Entity->Unref();
      m_Entity = NULL;
   }
}

/// Create a command with a correct state.
Command*
ETRotate::CreateCommand()
{
   if (m_Entity == NULL)
      return NULL;
   else
   {
      m_Entity->m_MState.m_Rotation = m_OldRot;
      Command *c = new ECRotate (g_Application->GetWorld(), m_Entity,
				 m_NewRot);
      c->Execute();
      return c;
   }
}

///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////

ECRotate::ECRotate(World *world, Entity *entity, Ark::Quat newrot) : 
   m_World (world),
   m_Entity (entity)
{
   assert (m_Entity != 0);
   m_Entity->Ref();

   m_NewRot = newrot;
   m_OldRot = m_Entity->m_MState.m_Rotation;
}

ECRotate::~ECRotate()
{
   if (m_Entity)
      m_Entity->Unref();
}

/// Return the command type.
std::string
ECRotate::Type() const
{
   return "Rotate entity";
}

/// Execute this command.
void
ECRotate::Execute()
{
   //std::cerr << "Execute move";
   m_Entity->m_MState.m_Rotation = m_NewRot;
   g_Application->GetWorld()->Update(0.0);
}

/// Undo the action done by this command.
void
ECRotate::Unexecute()
{
   //std::cerr << "Unexecute move";
   m_Entity->m_MState.m_Rotation = m_OldRot;
   g_Application->GetWorld()->Update(0.0);
}
