#include "ToolHelper.h"

#include "World.h"
#include "Command.h"
#include "CommandStack.h"
#include "EntityOps.h"
#include "HeightOps.h"

#include "UI.h"
#include "Application.h"

ToolHelper::ToolHelper () : 
    m_UndoLevel (0),
    m_MaxUndoLevel (16),
    m_Commands (new CommandStack(m_MaxUndoLevel)),
    m_EntityOps (new EntityOpList),
    m_HeightOps (new HeightOpList)
{
}

ToolHelper::~ToolHelper ()
{
   delete m_Commands;
   delete m_EntityOps;
   delete m_HeightOps;
}


Tool *
ToolHelper::NewEntityTool (int type)
{
   if (GetWorld() == NULL)
      return 0;

   return m_EntityOps->operator[](type)->Create();
}

Tool *
ToolHelper::NewHeightTool (int type, int s, float a, float h)
{
   if (GetWorld() == NULL)
      return 0;

   return m_HeightOps->operator[](type)->Create(GetWorld(), type, s, a, h);
}

void 
ToolHelper::Undo()
{
    m_Commands->Undo();
    
    //FIXME redo mesage
    g_Application->GetUI()->EnableRedoCommands(1, "");

    if (m_Commands->CannotUndo())
	g_Application->GetUI()->EnableUndoCommands(0, "");

    GetTerrain()->GetView()->Redraw();
}

void
ToolHelper::Redo()
{
    m_Commands->Redo();
    
    g_Application->GetUI()->EnableUndoCommands(1, "");

    if (m_Commands->CannotRedo())
	g_Application->GetUI()->EnableRedoCommands(0, "");

    GetTerrain()->GetView()->Redraw();
}

void 
ToolHelper::ClearCommands() const
{
    m_Commands->Clear();
    g_Application->GetUI()->EnableUndoCommands(0, "");
    g_Application->GetUI()->EnableRedoCommands(0, "");
}

void 
ToolHelper::PushCommand(Command* command)
{
    m_Commands->Push( command );
    g_Application->GetUI()->EnableUndoCommands(1, "");
    g_Application->GetUI()->EnableRedoCommands(0, "");
}

//=============================================================================

// Tool operations
void 
ToolHelper::SetTool(Tool* tool)
{
    // Clearing tool
    if (!tool)
    {
	GetTerrain()->SetTool (0);
	return;
    }
    
    // Check for existing world
    if (GetWorld())
    {
	// Sets the tool's height field to appropriate value
	tool->SetWorld (GetWorld());

	// Sets the TerrainView with this tool
	GetTerrain()->SetTool(tool);
    }
}

void 
ToolHelper::SetView(ViewWidget* view)
{
  g_Application->GetUI()->InitHeightOps(*m_HeightOps);
  g_Application->GetUI()->InitEntityOps(*m_EntityOps);
}
