/*--------------------------------------------------------------------------*/
/* game actors                                                              */
/*--------------------------------------------------------------------------*/

#ifndef __MY_ACTORS_H
#define __MY_ACTORS_H

/* this file defines many constants using enums, many parts of the board */
/* and field depend on the order.  do not modify without good reason.    */

/*--------------------------------------------------------------------------*/
/* actor states                                                             */
/*--------------------------------------------------------------------------*/

enum {

   STATE_FIRE = 0,                      /* for querying about fire key */

   /* move states */
   STATE_MOVE_UP = 1,                   /* STATE_MOVE_* constants must */
   STATE_MOVE_DOWN,                     /*   have values 1 through 8:  */
   STATE_MOVE_LEFT,                     /*   don't move them!          */
   STATE_MOVE_RIGHT,
   STATE_MOVE_UP_LEFT,
   STATE_MOVE_DOWN_LEFT,
   STATE_MOVE_UP_RIGHT,
   STATE_MOVE_DOWN_RIGHT,

   /* fire states */
   STATE_FIRE_UP,                       /* must have same order as */
   STATE_FIRE_DOWN,                     /* STATE_MOVE_* constants */
   STATE_FIRE_LEFT,
   STATE_FIRE_RIGHT,
   STATE_FIRE_UP_LEFT,
   STATE_FIRE_DOWN_LEFT,
   STATE_FIRE_UP_RIGHT,
   STATE_FIRE_DOWN_RIGHT,
   STATE_FIRE_ANY,
   
   /* elemental states */
   STATE_AIR_ELEM,
   STATE_EARTH_ELEM,
   STATE_FIRE_ELEM,
   STATE_WATER_ELEM,

   /* other states */
   STATE_BOARD,                         /* floor/cursor on the board */
   STATE_POWER,                         /* power point */
   STATE_EMPTY,                         /* black cell */
   STATE_FIELD,                         /* field cell */
   STATE_ROCK,                          /* field rock */

   STATE_MOVE_FIRST = STATE_MOVE_UP,
   STATE_MOVE_LAST = STATE_MOVE_DOWN_RIGHT,
   STATE_MOVE_COUNT = (STATE_MOVE_LAST - STATE_MOVE_FIRST + 2),
   STATE_FIRE_FIRST = STATE_FIRE_UP
};

/*--------------------------------------------------------------------------*/
/* actor numbers                                                            */
/*--------------------------------------------------------------------------*/

enum {
   ACTOR_NULL,

   ACTOR_LIGHT_SWORD,                   /* weapons of light sides */
   ACTOR_LIGHT_CLOUD,
   ACTOR_LIGHT_BOULDER,
   ACTOR_LIGHT_ARROW,
   ACTOR_LIGHT_MAGICSPEAR,
   ACTOR_LIGHT_ENERGYBOLT,
   ACTOR_LIGHT_WHIRLWIND,
   ACTOR_LIGHT_FIREBALL,

   ACTOR_ELEMENTAL_TORNADO,             /* weapons of the mighty elementals */
   ACTOR_ELEMENTAL_BOULDER,             /*   must be placed immediately */
   ACTOR_ELEMENTAL_FIERYBOLT,           /*   after weapons of the light side */
   ACTOR_ELEMENTAL_ICEBOLT,
   
   ACTOR_DARK_CLUB,                     /* weapons of the dark side */
   ACTOR_DARK_CLOUD,
   ACTOR_DARK_BOULDER,
   ACTOR_DARK_TAILSPIKES,
   ACTOR_DARK_EYEBEAM,
   ACTOR_DARK_FIERYBREATH,
   ACTOR_DARK_CLONE,
   ACTOR_DARK_LIGHTNINGBOLT,

   ACTOR_KNIGHT,                        /* actors of the light side */
   ACTOR_ARCHER,
   ACTOR_VALKYRIE,
   ACTOR_GOLEM,
   ACTOR_UNICORN,
   ACTOR_DJINNI,
   ACTOR_PHOENIX,
   ACTOR_WIZARD,

   ACTOR_AIR_ELEM,                      /* the four mighty elementals */
   ACTOR_EARTH_ELEM,                    /*   must be placed immediately */
   ACTOR_FIRE_ELEM,                     /*   following the light side */
   ACTOR_WATER_ELEM,

   ACTOR_GOBLIN,                        /* actors of the dark side */
   ACTOR_MANTICORE,
   ACTOR_BANSHEE,
   ACTOR_TROLL,
   ACTOR_BASILISK,
   ACTOR_DRAGON,
   ACTOR_SHAPESHIFTER,
   ACTOR_SORCERESS,

   ACTOR_DUMMY_ACTOR,                   /* indicates end of actor list */
   ACTOR_NUM_ACTORS,

   ACTOR_LIGHT_FIRST = ACTOR_KNIGHT,
   ACTOR_LIGHT_LAST = ACTOR_WIZARD,

   ACTOR_DARK_FIRST = ACTOR_GOBLIN,
   ACTOR_DARK_LAST = ACTOR_SORCERESS,

   ACTOR_NUM_LIGHT = ACTOR_LIGHT_LAST - ACTOR_LIGHT_FIRST + 1,
   ACTOR_NUM_DARK = ACTOR_DARK_LAST - ACTOR_DARK_FIRST + 1,

   ACTOR_FIRST = ACTOR_LIGHT_SWORD,
   ACTOR_LAST = ACTOR_WATER_ELEM,
   ACTOR_MASK = 0x7F                    /* at most 128 actors allowed */
};

/*--------------------------------------------------------------------------*/
/* actor types                                                              */
/*--------------------------------------------------------------------------*/

enum {
   ACTOR_WEAPON = 0x8000,               /* if weapon, otherwise monster */
   ACTOR_MONSTER = 0,
   
   ACTOR_LIGHT = 0x4000,                /* if light, otherwise dark */
   ACTOR_DARK  = 0,

   ACTOR_GROUND = 0x20000,              /* plain ground monster */
   ACTOR_FLY = 0x10000,                 /* plain fly monster */
   ACTOR_MASTER = ACTOR_FLY | 0x40000,  /* wizard/sorceress teleport */ 
   ACTOR_ELEMENTAL = 0x80000,           /* elemental teleport */
   ACTOR_CLONE = 0x100000,              /* shapeshifter clone */

   ACTOR_WEAPON_HAND = (ACTOR_WEAPON | 0x2000),   /* knight/goblin */
   ACTOR_WEAPON_CLOUD = (ACTOR_WEAPON | 0x1000),  /* pheonix/banshee */
   ACTOR_WEAPON_SHOOT = (ACTOR_WEAPON | 0x800),   /* all others, except: */
   ACTOR_WEAPON_CLONE = (ACTOR_WEAPON | 0x400),   /* shapeshifter */

   ACTOR_NORMAL_SPEED = 0,              /* normal move/fire speed */
   ACTOR_SLOW_SPEED = 0x100,            /* slow move speed (monster only) */
   ACTOR_FAST_SPEED = 0x100             /* fast fire speed (weapon only) */
};

/*--------------------------------------------------------------------------*/
/* structures                                                               */
/*--------------------------------------------------------------------------*/

typedef struct {                        /* actor (monster/weapon) */

   /* general */
   
   char name[64];
   void *sprite;                        /* sprite for actor */
   int type;
   int distance;                        /* max board steps per turn */
   int strength;                        /* monster health or weapon damage */
   int weapon;                          /* index to weapon (monster only) */
   int recharge;                        /* recharge time (weapon only) */

} ACTOR;

/*--------------------------------------------------------------------------*/
/* functions                                                                */
/*--------------------------------------------------------------------------*/

void actors_init(void (*_progress_func)(char *msg, float progress));
void actors_load_theme(char *name);
int actor_is_side(ACTOR *actor, int side);

/*--------------------------------------------------------------------------*/
/* variables                                                                */
/*--------------------------------------------------------------------------*/

extern ACTOR actors_list[];
extern ACTOR orig_actors_list[];

extern void *floor_sprite;
extern void *cursor_sprite;

extern int state_move_x_step[STATE_MOVE_COUNT],
           state_move_y_step[STATE_MOVE_COUNT];
extern int state_opposite[STATE_MOVE_COUNT];

#endif /* __MY_ACTORS_H */
