/*--------------------------------------------------------------------------*/
/* interface                                                                */
/*--------------------------------------------------------------------------*/

#ifndef __MY_IFACE_H
#define __MY_IFACE_H

#include "list.h"

/*--------------------------------------------------------------------------*/
/* defines                                                                  */
/*--------------------------------------------------------------------------*/

enum {
   IFACE_HUMAN = 1,
   IFACE_COMPUTER,
   IFACE_NETWORK,
   IFACE_AI_COMPUTER,
   NUM_IFACES
};

enum {
   IFACE_BOARD = 1,
   IFACE_FIELD_START,
   IFACE_FIELD,
   IFACE_FIELD_STOP
};

/*--------------------------------------------------------------------------*/
/* structures                                                               */
/*--------------------------------------------------------------------------*/

typedef union {                         /* computer command */
   struct {
      int spell;                        /* spell, or 0 for simple move */
      int x1, y1;                       /* source cell (move, spells t/x) */
      int x2, y2;                       /* target cell (move, t/h/x/l/v/m) */
   } b;
   struct {
      int dir;                          /* direction of command */
      int fire;                         /* command modifier: fire or move */
   } f;
} COMMAND;

/*--------------------------------------------------------------------------*/
/* functions                                                                */
/*--------------------------------------------------------------------------*/

char *iface_start(int *light_first);
void iface_turn(int side_num, int mode);
void iface_frame(void);
int iface_key_down(int key);
void iface_notify_computer(int mode);
int iface_is_pausable(void);
void iface_config_read(void);
void iface_config_write(void);

#endif
