/*
 *  ghal
 *
 *  Copyright (c) 2007 Brian Tarricone <bjt23@cornell.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License ONLY.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GHAL_DEVICE_H__
#define __GHAL_DEVICE_H__

#if !defined(GHAL_IN_GHAL_H) && !defined(GHAL_COMPILATION)
#error "Do not include ghal-device.h directly.  Instead use <ghal/ghal.h>"
#endif

#include <glib-object.h>

#include <dbus/dbus-glib.h>

#include <ghal/ghal-types.h>

#define GHAL_TYPE_DEVICE     (ghal_device_get_type())
#define GHAL_DEVICE(obj)     (G_TYPE_CHECK_INSTANCE_CAST((obj), GHAL_TYPE_DEVICE, GHalDevice))
#define GHAL_IS_DEVICE(obj)  (G_TYPE_CHECK_INSTANCE_TYPE((obj), GHAL_TYPE_DEVICE))

G_BEGIN_DECLS

typedef struct _GHalDevice           GHalDevice;
typedef struct _GHalDeviceClass      GHalDeviceClass;
typedef struct _GHalDevicePrivate    GHalDevicePrivate;

struct _GHalDevice
{
    GObject parent;
    
    /*< private >*/
    GHalDevicePrivate *priv;
};

struct _GHalDeviceClass
{
    GObjectClass parent;
    
    /*< signals >*/
    
    void (*new_capability)(GHalDevice *device,
                           const gchar *capability);
    void (*lost_capability)(GHalDevice *device,
                            const gchar *capability);
    void (*property_changed)(GHalDevice *device,
                             const gchar *property,
                             GhalPropertyChangeType change_type);
    void (*condition)(GHalDevice *device,
                      const gchar *condition_name,
                      const gchar *condition_detail);
};

GType ghal_device_get_type() G_GNUC_CONST;

const gchar *ghal_device_peek_udi(GHalDevice *device);

gboolean ghal_device_exists(GHalDevice *device,
                            GError **error);

gboolean ghal_device_property_exists(GHalDevice *device,
                                     const gchar *property,
                                     GError **error);

gchar *ghal_device_get_property_string(GHalDevice *device,
                                       const gchar *property,
                                       GError **error);
gint ghal_device_get_property_int(GHalDevice *device,
                                  const gchar *property,
                                  GError **error);
guint64 ghal_device_get_property_uint64(GHalDevice *device,
                                        const gchar *property,
                                        GError **error);
gdouble ghal_device_get_property_double(GHalDevice *device,
                                        const gchar *property,
                                        GError **error);
gboolean ghal_device_get_property_bool(GHalDevice *device,
                                       const gchar *property,
                                       GError **error);
GList *ghal_device_get_property_strlist(GHalDevice *device,
                                        const gchar *property,
                                        GError **error);

gboolean ghal_device_set_property_string(GHalDevice *device,
                                         const gchar *property,
                                         const gchar *value,
                                         GError **error);
gboolean ghal_device_set_property_int(GHalDevice *device,
                                      const gchar *property,
                                      gint value,
                                      GError **error);
gboolean ghal_device_set_property_uint64(GHalDevice *device,
                                         const gchar *property,
                                         guint64 value,
                                         GError **error);
gboolean ghal_device_set_property_double(GHalDevice *device,
                                         const gchar *property,
                                         gdouble value,
                                         GError **error);
gboolean ghal_device_set_property_bool(GHalDevice *device,
                                       const gchar *property,
                                       gboolean value,
                                       GError **error);

gboolean ghal_device_property_strlist_append(GHalDevice *device,
                                             const gchar *property,
                                             const gchar *value,
                                             GError **error);
gboolean ghal_device_property_strlist_prepend(GHalDevice *device,
                                              const gchar *property,
                                              const gchar *value,
                                              GError **error);
gboolean ghal_device_property_strlist_remove_index(GHalDevice *device,
                                                   const gchar *property,
                                                   guint index_,
                                                   GError **error);
gboolean ghal_device_property_strlist_remove(GHalDevice *device,
                                             const gchar *property,
                                             const gchar *value,
                                             GError **error);

gboolean ghal_device_remove_property(GHalDevice *device,
                                     const gchar *property,
                                     GError **error);

gboolean ghal_device_query_capability(GHalDevice *device,
                                      const gchar *capability,
                                      GError **error);

DBusGProxy *ghal_device_get_dbus_proxy(GHalDevice *device,
                                       const gchar *dbus_interface);

guint ghal_device_hash(gconstpointer device);
gboolean ghal_device_equal(gconstpointer a,
                           gconstpointer b);
gint ghal_device_compare(gconstpointer a,
                         gconstpointer b);

G_END_DECLS

#endif  /* __GHAL_DEVICE_H__ */
