#ifndef HELP_H
#define HELP_H
  
#include "config.h"
#include "i18n.h"

#define HELP_TEXT _("\n \
\n \
                                  XFE, X File Explorer File Manager\n \
\n \
                               Copyright (C) 2002-2007 Roland Baudin\n \
\n \
                                    <http://roland65.free.fr/xfe>\n \
                                <http://sourceforge.net/projects/xfe>\n \
\n \
\n \
\n \
\n \
This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2, or (at your option) any later version.\n \
\n \
\n \
This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.\n \
\n \
\n \
  Description\n \
  =-=-=-=-=-=\n \
\n \
X File Explorer (xfe) is a lightweight file manager for X11, written using the FOX toolkit.\n \
It is desktop independent and can easily be customized.\n \
It has Commander or Explorer styles and it is very fast and small.\n \
Xfe is based on the popular, but discontinued X Win Commander, written by Maxim Baranov.\n \
\n \
\n \
  Features\n \
  =-=-=-=-=\n \
\n \
  - Very fast graphic user interface\n \
  - Commander/Explorer interface with four file manager modes : a) one panel, b) a directory tree\n \
    and one panel, c) two panels and d) a directory tree and two panels\n \
  - Integrated text editor (X File Write, xfw)\n \
  - Integrated text viewer (X File View, xfv)\n \
  - Integrated image viewer (X File Image, xfi)\n \
  - Integrated package (rpm or deb) viewer / installer / uninstaller (X File Package, xfp)\n \
  - UTF-8 support\n \
  - Copy/Cut/Paste files from and to your favorite desktop (GNOME/KDE/XFCE)\n \
  - Drag and Drop files from and to your favorite desktop\n \
  - Root mode with authentication by su or sudo\n \
  - Status line\n \
  - File associations\n \
  - Optional trash can for file delete operations (trash can directory is ~/.xfe/trash)\n \
  - Auto save registry\n \
  - Double click or single click files and directories navigation\n \
  - Right mouse click pop-up menu in tree list and file list\n \
  - Change file(s) attributes\n \
  - Mount/Unmount devices (Linux only)\n \
  - Warn when mount point are not responding (Linux only)\n \
  - Toolbars\n \
  - Bookmarks\n \
  - Back and forward history lists for directory navigation\n \
  - Color themes (GNOME, KDE, Windows...)\n \
  - Icon themes (Xfe, GNOME, XFCE, Windows...)\n \
  - Create/Extract archives (tar, zip, gzip, bzip2, lzh, rar compress formats are supported)\n \
  - Tooltips with file properties\n \
  - Progress bars or dialogs for lengthy file operations\n \
  - Thumbnails image previews\n \
  - and much more...\n \
\n \
\n \
  Key bindings:\n \
  =-=-=-=-=-=\n \
\n \
    o Help                         - F1\n \
    o New file                     - F2\n \
    o New window                   - F3\n \
    o New root window              - Shift-F3\n \
    o View                         - return\n \
    o Edit                         - F4\n \
    o Copy                         - Ctrl-c\n \
    o Copy to                      - F5, Ctrl-k\n \
    o Cut                          - Ctrl-x\n \
    o Paste                        - Ctrl-v\n \
    o Move                         - F6, Ctrl-d\n \
    o Symlink                      - Ctrl-s\n \
    o Rename                       - Ctrl-n\n \
    o New folder                   - F7\n \
    o Open                         - Ctrl-o\n \
    o Move to trash                - F8, del\n \
    o Delete                       - Shift-del\n \
    o Empty trash can              - Ctrl-del\n \
    o Go to trash                  - Ctrl-F8\n \
    o Go up                        - backspace\n \
    o Go back                      - Ctrl-backspace\n \
    o Go forward                   - Shift-backspace\n \
    o Properties                   - F9\n \
    o One panel                    - Ctrl-F1\n \
    o Tree and one panel           - Ctrl-F2\n \
    o Two panels                   - Ctrl-F3\n \
    o Tree and two panels          - Ctrl-F4\n \
    o Large icons                  - F10\n \
    o Small icons                  - F11\n \
    o Detailed view                - F12\n \
    o Hidden folders               - Ctrl-F5\n \
    o Hidden files                 - Ctrl-F6\n \
    o Thumbnails preview           - Ctrl-F7\n \
    o Execute                      - Ctrl-e\n \
    o Go home                      - Ctrl-h\n \
    o Terminal                     - Ctrl-t\n \
    o Refresh                      - Ctrl-r\n \
    o Select all                   - Ctrl-a\n \
    o Deselect all                 - Ctrl-z\n \
    o Invert selection             - Ctrl-i\n \
    o Add bookmark                 - Ctrl-b\n \
    o Mount (Linux only)           - Ctrl-m\n \
    o Unmount (Linux only)         - Ctrl-u\n \
    o Open file panel context menu - Shift-F10\n \
    o Quit                         - Ctrl-q, Ctrl-w\n \
\n \
\n \
  Drag and Drop operations :\n \
  =-=-=-=-=-=-=-=-=-=-=-=-=-=\n \
\n \
Dragging a file or group or files (by moving the mouse while maintaining the left button pressed) to a directory or a file panel optionally opens a dialog that allows to select the file operation : copy, move, link or cancel.\n \
\n \
\n \
  Configuration\n \
  =-=-=-=-=-=-=\n \
\n \
From version 0.98 and above, the configuration scheme was changed. It is now independent of the FOX registry and should be more simple and intuitive.\n \
\n \
You can perform any Xfe customization (layout, file associations, ...) without editing any file by hand. However, you may want to understand the configuration principles, because some customizations can easily be done by editing the configurations files.\n \
Be careful to quit Xfe before hand editing any configuration file, otherwise changes could not be taken into account.\n \
\n \
The system-wide configuration file xferc is located in /usr/share/xfe, /usr/local/share/xfe or /opt/local/share/xfe, in the given order of precedence.\n \
\n \
The local configuration files for Xfe, Xfw, Xfv, Xfi, Xfp are located in the ~/.xfe directory. They are named xferc, xfwrc, xfvrc, xfirc and xfprc.\n \
\n \
At the very first Xfe run, the system-wide configuration file is copied into the local configuration file ~/.xfe/xferc which does not exists yet. If the system-wide configuration file is not found (in case of an unusal install place), a dialog asks the user to select the right place. It is thus easier to customize Xfe (this is particularly true for the file associations) by hand editing because all the local options are located in the same file.\n \
\n \
Default PNG icons are located in /usr/share/xfe/icons/xfe-theme or /usr/local/share/xfe/icons/xfe-theme, depending on your installation.\n \
You can easily change the icon theme path in Preferences->Themes->Icon theme path.\n \
\n \
\n \
\
  Tips\n \
  =-=-=\n \
\n \
File list\n \
   - Select files and right click to open a context menu on the selected files\n \
   - Press Ctrl + right click to open a context menu on the file panel\n \
   - When dragging a file/folder to a folder, hold on the mouse\n \
     on the folder to open it\n \
\n \
Tree list\n \
   - Select a folder and right click to open a context menu on the selected folder\n \
   - When dragging a file/folder to a folder, hold on the mouse on the folder\n \
     to expand it\n \
\n \
Copy/Paste file names\n \
   - Select a file and press Ctrl-C to copy its name into the clipboard. Then in a dialog, press Ctrl-V to paste\n \
     the file name.\n \
   - In a file operation dialog, select a filename in the line containing the source name and paste it directly\n \
     to the destination using the middle button of your mouse. Then modify it to suit your needs.\n \
\n \
\n \
\
  Bugs\n \
  =-=-=\n \
\n \
Please report bugs to Roland Baudin <roland65@free.fr>.\n \
\n \
\n \
\
  Translations\n \
  =-=-=-=-=-=-=\n \
\n \
Xfe is now available in 18 languages. To translate Xfe to your language, open with a software like poedit, kbabel or gtranslator the xfe.pot file in the po directory of the source tree and fill it with your translated strings, and then send it back to me.\n \
\n \
\n \
\
  Patches\n \
  =-=-=-=\n \
\n \
If you've done some interesting patch, please send it to me, I will try to include it in the next release...\n \
\n \
[Many thanks to Maxim Baranov for his excellent X Win Commander and to all people that have provided useful patches,\n \
tests and advices.]\n \
\n \
")
;


#endif
