<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  
  <!-- This file is part of xgridfit.
       It is distributed under the GNU Public License, version 2.
       Copyright (c) 2006-7 by Peter S. Baker
  -->
  
  <!-- Set this to true() to suppress running messages (not error messages
  or warnings). On my machine, running xsltproc, this cuts processing
  time approximately in half. -->  
  <xsl:param name="silent-mode" select="false()"/>
  
  <xsl:template name="display-message">
    <xsl:param name="msg"/>
    <xsl:if test="not($silent-mode)">
      <xsl:message>
        <xsl:value-of select="$msg"/>
      </xsl:message>
    </xsl:if>
  </xsl:template>
  
  <xsl:template name="error-message">
    <xsl:param name="msg"/>
    <xsl:message terminate="yes">
      <xsl:value-of select="$newline"/>
      <xsl:text>Error: </xsl:text>
      <xsl:value-of select="$msg"/>
    </xsl:message>
  </xsl:template>
  
  <xsl:template name="warning">
    <xsl:param name="msg"/>
    <xsl:param name="with-pop" select="false()"/>
    <xsl:message>
      <xsl:value-of select="$newline"/>
      <xsl:text>Warning: </xsl:text>
      <xsl:value-of select="$msg"/>
    </xsl:message>
    <xsl:if test="$with-pop">
      <xsl:call-template name="simple-command">
        <xsl:with-param name="cmd" select="'POP'"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

</xsl:stylesheet>
