<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xgf="http://www.engl.virginia.edu/OE/xgridfit-data"
                version="1.0">
  
  <!-- This file is part of xgridfit.
       It is distributed under the GNU Public License, version 2.
       Copyright (c) 2006-7 by Peter S. Baker
  -->
  
  <!-- The next three templates support the <push> element, which contains
       a whitespace-delimited list of numbers, or values that can be resolved
       to numbers at compile-time. -->
  <xsl:template name="count-number-list">
    <xsl:param name="s"/>
    <xsl:param name="count" select="1"/>
    <xsl:variable name="next-string">
      <xsl:call-template name="get-remaining-tokens">
        <xsl:with-param  name="s"
                         select="$s"/>
      </xsl:call-template>
    </xsl:variable>  
    <xsl:choose>
      <xsl:when test="string-length($next-string) &gt; 0">
        <xsl:call-template name="count-number-list">
          <xsl:with-param  name="s"
                           select="$next-string"/>
          <xsl:with-param  name="count"
                           select="$count + 1"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$count"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="survey-number-list">
    <xsl:param name="s"/>
    <xsl:param name="call-macro-param-set"/>
    <xsl:variable name="current-string">
      <xsl:call-template name="get-first-token">
        <xsl:with-param  name="s"
          select="$s"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="ns">
      <xsl:call-template name="get-number-literal">
        <xsl:with-param  name="val"
                         select="$current-string"/>
	<xsl:with-param name="call-macro-param-set" select="$call-macro-param-set"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:if test="$ns = 'NaN'">
      <xsl:call-template name="error-message">
        <xsl:with-param  name="msg">
          <xsl:text>Identifier </xsl:text>
          <xsl:value-of select="$current-string"/>
          <xsl:text> does not resolve to a number.</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:if>
    <xsl:variable name="n" select="number($ns)"/>
    <xsl:variable name="next-string">
      <xsl:call-template name="get-remaining-tokens">
        <xsl:with-param  name="s"
                         select="$s"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="$n &lt; 0 or $n &gt; 255">
        <xsl:text>W</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test="string-length($next-string) &gt; 0">
            <xsl:call-template name="survey-number-list">
              <xsl:with-param  name="s"
                select="$next-string"/>
	      <xsl:with-param name="call-macro-param-set" select="$call-macro-param-set"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>B</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <!-- 
  
      output-number-list

      A "number-list" is a string of whitespace-separated
      tokens that can be resolved to numbers by xgridfit.
      This template goes through the list recursively,
      resolving the tokens to numbers and outputting the
      result. Used after a PUSH instruction has been
      output by the <push> instruction.
  -->
  <xsl:template name="output-number-list">
    <xsl:param name="s"/>
    <xsl:param name="count" select="1"/>
    <xsl:param name="call-macro-param-set"/>
    <xsl:variable name="current-string">
      <xsl:call-template name="get-first-token">
        <xsl:with-param name="s" select="$s"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="next-string">
      <xsl:call-template name="get-remaining-tokens">
        <xsl:with-param name="s" select="$s"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="$count = 1">
        <xsl:value-of select="$inst-newline"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$push-num-separator"/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:call-template name="get-number-literal">
      <xsl:with-param name="val" select="$current-string"/>
      <xsl:with-param name="call-macro-param-set"
		      select="$call-macro-param-set"/>
    </xsl:call-template>
    <xsl:if test="string-length($next-string) &gt; 0">
      <xsl:call-template name="output-number-list">
        <xsl:with-param name="s" select="$next-string"/>
        <xsl:with-param name="count" select="$count + 1"/>
	<xsl:with-param name="call-macro-param-set"
			select="$call-macro-param-set"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template match="to-stack">
    <xsl:param name="call-macro-param-set"/>
    <xsl:call-template name="push-value">
      <xsl:with-param name="val" select="."/>
      <xsl:with-param name="call-macro-param-set"
		      select="$call-macro-param-set"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="push">
    <xsl:param name="with-leading-newline" select="true()"/>
    <xsl:param name="call-macro-param-set"/>
    <xsl:variable name="num-list" select="normalize-space(string(.))"/>
    <xsl:variable name="push-size">
      <xsl:call-template name="survey-number-list">
        <xsl:with-param name="s" select="$num-list"/>
	<xsl:with-param name="call-macro-param-set" select="$call-macro-param-set"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="num-count">
      <xsl:call-template name="count-number-list">
        <xsl:with-param name="s" select="$num-list"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:call-template name="push-command">
      <xsl:with-param name="size" select="$push-size"/>
      <xsl:with-param name="count" select="$num-count"/>
      <xsl:with-param name="with-leading-newline" select="$with-leading-newline"/>
    </xsl:call-template>
    <xsl:call-template name="output-number-list">
      <xsl:with-param name="s" select="$num-list"/>
      <xsl:with-param name="call-macro-param-set" select="$call-macro-param-set"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="command">
    <!-- Test whether this is a valid instruction. -->
    <xsl:if test="not(document('xgfdata.xml')/*/xgf:instruction-set/xgf:inst[@val
                  = current()/@name])">
      <xsl:call-template name="error-message">
        <xsl:with-param name="msg">
          <xsl:text>Unrecognized instruction </xsl:text>
          <xsl:value-of select="@name"/>
          <xsl:text> in &lt;command&gt; element.</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:if>
    <xsl:choose>
      <!-- This instruction requires a modifier. -->
      <xsl:when test="document('xgfdata.xml')/*/xgf:instruction-set/xgf:inst[@val
                      = current()/@name]/@mod = 'yes'">
        <xsl:choose>
          <!-- We have a modifier provided via the modifier attribute, and there is
               no <modifier> element. We just copy the modifier with no checking. -->
          <xsl:when test="@modifier and not(modifier)">
            <xsl:call-template name="simple-command">
              <xsl:with-param name="cmd" select="@name"/>
              <xsl:with-param name="modifier" select="@modifier"/>
            </xsl:call-template>
          </xsl:when>
          <!-- Otherwise we either have (a) modifier element(s) or we use (a) default(s). -->
          <xsl:otherwise>
            <xsl:call-template name="simple-command">
              <xsl:with-param name="cmd" select="@name"/>
              <xsl:with-param name="modifier">
                <xsl:choose>
                  <xsl:when test="@name='MIRP' or @name='MDRP'">
                    <!--
                        defaults are:
                        set-rp0: true
                        min-distance: true
                        round (and cut-in for MIRP): true
                        color: gray
                    -->
                    <xsl:call-template name="mirp-mdrp-bits">
                      <xsl:with-param name="set-rp0"
                        select="boolean(not(modifier[@type='set-rp0']) or
                                modifier[@type='set-rp0']/@value = 'yes')"/>
                      <xsl:with-param name="min-distance"
                        select="boolean(not(modifier[@type='minimum-distance']) or
                                modifier[@type='minimum-distance']/@value = 'yes')"/>
                      <xsl:with-param name="round-cut-in"
                        select="boolean(not(modifier[@type='round']) or
                                modifier[@type='round']/@value = 'yes')"/>
                      <xsl:with-param name="color">
                        <xsl:choose>
                          <xsl:when test="modifier[@type='color']">
                            <xsl:value-of select="modifier[@type='color']/@value"/>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:text>gray</xsl:text>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:with-param>
                    </xsl:call-template>
                  </xsl:when>
                  <xsl:when test="@name='ROUND' or @name='NROUND'">
                    <!-- default is gray -->
                    <xsl:call-template name="color-bits">
                      <xsl:with-param name="color">
                        <xsl:choose>
                          <xsl:when test="modifier[@type='color']">
                            <xsl:value-of select="modifier[@type='color']/@value"/>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:text>gray</xsl:text>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:with-param>
                    </xsl:call-template>
                  </xsl:when>
                  <xsl:when test="@name='SDPVTL' or @name='SPVTL' or @name='SFVTL'">
                    <!-- default is parallel -->
                    <xsl:call-template name="to-line-bit">
                      <xsl:with-param name="tlb">
                        <xsl:choose>
                          <xsl:when test="modifier[@type='to-line']">
                            <xsl:value-of select="modifier[@type='to-line']/@value"/>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:text>parallel</xsl:text>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:with-param>
                    </xsl:call-template>
                  </xsl:when>
                  <xsl:when test="@name='SVTCA' or @name='SPVTCA'
                    or @name='SFVTCA' or @name='IUP'">
                    <!-- default is x axis -->
                    <xsl:call-template name="axis-bit">
                      <xsl:with-param name="axis">
                        <xsl:choose>
                          <xsl:when test="modifier[@type='axis']">
                            <xsl:value-of select="modifier[@type='axis']/@value"/>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:text>x</xsl:text>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:with-param>
                    </xsl:call-template>
                  </xsl:when>
                  <xsl:when test="@name='MIAP' or @name='MDAP'">
                    <!-- default is yes -->
                    <xsl:call-template name="round-and-cut-in-bit">
                      <xsl:with-param name="b"
                                      select="boolean(not(modifier[@type='round']) or
                                              modifier[@type='round']/@value='yes')"/>
                    </xsl:call-template>
                  </xsl:when>
                  <xsl:when test="@name='MSIRP'">
                    <!-- default is yes -->
                    <xsl:call-template name="rp0-bit">
                      <xsl:with-param name="set-rp0"
                                      select="boolean(not(modifier[@type='set-rp0']) or
                                              modifier[@type='set-rp0']/@value='yes')"/>
                    </xsl:call-template>
                  </xsl:when>
                  <xsl:when test="@name='SHP' or @name='SHC' or @name='SHZ'">
                    <!-- default is 1 -->
                    <xsl:call-template name="ref-ptr-bit">
                      <xsl:with-param name="ref-ptr">
                        <xsl:choose>
                          <xsl:when test="modifier[@type='ref-ptr']">
                            <xsl:value-of select="modifier[@type='ref-ptr']/@value"/>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:text>1</xsl:text>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:with-param>
                    </xsl:call-template>
                  </xsl:when>
                  <xsl:when test="@name='GC' or @name='MD'">
                    <!-- default is grid-fitted -->
                    <xsl:call-template name="grid-fitted-bit">
                      <xsl:with-param name="grid-fitted"
                        select="boolean(not(modifier[@type='grid-fitted']) or
                                modifier[@type='grid-fitted']/@value='yes')"/>
                    </xsl:call-template>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:call-template name="error-message">
                      <xsl:with-param name="msg">
                        <xsl:text>Nothing to do in &lt;command&gt; with &lt;modifier&gt;. </xsl:text>
                        <xsl:text>This should not happen!</xsl:text>
                      </xsl:with-param>
                    </xsl:call-template>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- This instruction does not take a modifier. If one is present, it
           will be ignored. -->
      <xsl:otherwise>
        <xsl:call-template name="simple-command">
          <xsl:with-param name="cmd" select="@name"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>
