/*
 * Decompiled with CFR 0.152.
 */
package de.zeigermann.xml;

public final class XMLEncode {
    private static final int CDATA_BLOCK_THRESHOLD_LENGTH = 12;
    private static final char DEFAULT_QUOTE_CHAR = '\"';

    public static final boolean isWhiteSpace(String text) {
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (!Character.isWhitespace(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final String xmlEncodeTextForAttribute(String text, char quoteChar) {
        if (text == null) {
            return null;
        }
        return XMLEncode.xmlEncodeTextAsPCDATA(text, true, quoteChar);
    }

    public static final String xmlEncodeText(String text) {
        String cdata;
        if (text == null) {
            return null;
        }
        if (!XMLEncode.needsEncoding(text)) {
            return text;
        }
        if (text.length() > 12 && (cdata = XMLEncode.xmlEncodeTextAsCDATABlock(text)) != null) {
            return cdata;
        }
        return XMLEncode.xmlEncodeTextAsPCDATA(text);
    }

    public static final String xmlEncodeTextAsPCDATA(String text) {
        if (text == null) {
            return null;
        }
        return XMLEncode.xmlEncodeTextAsPCDATA(text, false);
    }

    public static final String xmlEncodeTextAsPCDATA(String text, boolean forAttribute) {
        return XMLEncode.xmlEncodeTextAsPCDATA(text, forAttribute, '\"');
    }

    public static final String xmlEncodeTextAsPCDATA(String text, boolean forAttribute, char quoteChar) {
        if (text == null) {
            return null;
        }
        StringBuffer n = new StringBuffer(text.length() * 2);
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            switch (c) {
                case '&': {
                    n.append("&amp;");
                    break;
                }
                case '<': {
                    n.append("&lt;");
                    break;
                }
                case '>': {
                    n.append("&gt;");
                    break;
                }
                case '\"': {
                    if (forAttribute) {
                        n.append("&quot;");
                        break;
                    }
                    n.append(c);
                    break;
                }
                case '\'': {
                    if (forAttribute) {
                        n.append("&apos;");
                        break;
                    }
                    n.append(c);
                    break;
                }
                default: {
                    n.append(c);
                }
            }
            ++i;
        }
        if (forAttribute) {
            n.append(quoteChar);
            n.insert(0, quoteChar);
        }
        return n.toString();
    }

    public static final String xmlEncodeTextAsCDATABlock(String text) {
        if (text == null) {
            return null;
        }
        if (XMLEncode.isCompatibleWithCDATABlock(text)) {
            return "<![CDATA[" + text + "]]>";
        }
        return null;
    }

    public static final boolean needsEncoding(String text) {
        return XMLEncode.needsEncoding(text, false);
    }

    public static final boolean needsEncoding(String data, boolean checkForAttr) {
        if (data == null) {
            return false;
        }
        int i = 0;
        while (i < data.length()) {
            char c = data.charAt(i);
            if (c == '&' || c == '<' || checkForAttr && (c == '\"' || c == '\'')) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean isCompatibleWithCDATABlock(String text) {
        if (text == null) {
            return false;
        }
        return text.indexOf("]]>") == -1;
    }

    public static final String xmlDecodeTextToCDATA(String pcdata) {
        if (pcdata == null) {
            return null;
        }
        StringBuffer n = new StringBuffer(pcdata.length());
        int i = 0;
        while (i < pcdata.length()) {
            char c = pcdata.charAt(i);
            if (c == '&') {
                char c1 = XMLEncode.lookAhead(1, i, pcdata);
                char c2 = XMLEncode.lookAhead(2, i, pcdata);
                char c3 = XMLEncode.lookAhead(3, i, pcdata);
                char c4 = XMLEncode.lookAhead(4, i, pcdata);
                char c5 = XMLEncode.lookAhead(5, i, pcdata);
                if (c1 == 'a' && c2 == 'm' && c3 == 'p' && c4 == ';') {
                    n.append("&");
                    i += 4;
                } else if (c1 == 'l' && c2 == 't' && c3 == ';') {
                    n.append("<");
                    i += 3;
                } else if (c1 == 'g' && c2 == 't' && c3 == ';') {
                    n.append(">");
                    i += 3;
                } else if (c1 == 'q' && c2 == 'u' && c3 == 'o' && c4 == 't' && c5 == ';') {
                    n.append("\"");
                    i += 5;
                } else if (c1 == 'a' && c2 == 'p' && c3 == 'o' && c4 == 's' && c5 == ';') {
                    n.append("'");
                    i += 5;
                } else {
                    n.append("&");
                }
            } else {
                n.append(c);
            }
            ++i;
        }
        return n.toString();
    }

    private static final char lookAhead(int la, int offset, String data) {
        try {
            return data.charAt(offset + la);
        }
        catch (StringIndexOutOfBoundsException e) {
            return '\u0000';
        }
    }

    private static final boolean contains(String text, char[] chars) {
        if (text == null || chars == null || chars.length == 0) {
            return false;
        }
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            int j = 0;
            while (j < chars.length) {
                if (chars[j] == c) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }
}

