CC := gcc
CFLAGS := -O2 -ffast-math -fomit-frame-pointer -fPIC
#CFLAGS := -Wall -g -O3
CFLAGS += -DHAVE_AV_CONFIG_H -I.. -D_FILE_OFFSET_BITS=64 -D_LARGEFILE_SOURCE -D_GNU_SOURCE
CFLAGS += -I ffmpeg-strip-wma
CFLAGS += `xmms-config --cflags`
LIBS := `xmms-config --libs` -L ffmpeg-strip-wma -lffwma

$(PLUGIN_FILE): $(OBJECTS)
	$(CC) -o $@ $^ $(LIBS) -shared

$(OBJDIR)/%.o: %.c
	$(CC) -c -o $@ $(CFLAGS) $<

$(DEPDIR)/%.d: %.c
	$(CC) -MM $(CFLAGS) $< | sed "s/^$*\.o:/$(OBJDIR)\/$*\.o $(DEPDIR)\/$*\.d:/" > $@

-include $(DEPS)
