/*
 *   XPP - The X Printing Panel
 *   --------------------------
 *
 *   Implementation of the main function of the program. It opens the main
 *   window of XPP (created with FLUID, the GUI designing tool of FLTK,
 *   source: mainwindow.fl, generated code: mainwindow.cxx/.h). The main
 *   window then uses the "printFiles" class defined in xpp.cxx/.h to handle
 *   the printing.
 *
 *   Copyright 2000 by Till Kamppeter
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License as
 *   published by the Free Software Foundation; either version 2 of the
 *   License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *   02111-1307  USA
 *
 */

/*
 * Include necessary headers...
 */

#include "mainwindow.h"
#include <FL/Fl_Shared_Image.H>

/*
 * 'main()' - Do all what xpp should do
 */

int
main(int  argc,		/* I - Number of command-line arguments */
     char *argv[])	/* I - Command-line arguments */

{
  int exitstat = 0;     /* exit status of called functions */
 
  fl_register_images(); /* Needed for image preview in file chooser 
			   dialog */
  xppMainWindow *window = new xppMainWindow(argc,argv,exitstat);
  if (exitstat == 0)
  {
    window->show();
    exitstat=Fl::run();
    if (exitstat == 0) exitstat = window->printstat;
    delete window;
  }
  return(exitstat);
}

/*
 * End of "$Id: xppmain.cxx,v 1.3 2004/12/16 17:34:53 tillkamppeter Exp $".
 */
