/*

This program prints the "idle time" of the user to stdout.  The "idle
time" is the number of milliseconds since input was received on any
input device.  If unsuccessful, the program prints a message to stderr
and exits with a non-zero exit code.

Copyright (c) 2005 Magnus Henoch <henoch@dtek.chalmers.se>
This program is distributed under a BSD-style license.  See the file
COPYING.

*/

#include <X11/Xlib.h>
#include <X11/extensions/scrnsaver.h>
#include <stdio.h>

void usage(char *name);

int main(int argc, char *argv[])
{
  XScreenSaverInfo ssi;
  Display *dpy;
  int event_basep, error_basep;

  if (argc != 1) {
    usage(argv[0]);
    return 1;
  }
  
  dpy = XOpenDisplay(NULL);
  if (dpy == NULL) {
    fprintf(stderr, "couldn't open display\n");
    return 1;
  }
  
  if (!XScreenSaverQueryExtension(dpy, &event_basep, &error_basep)) {
    fprintf(stderr, "screen saver extension not supported\n");
    return 1;
  }
  
  if (!XScreenSaverQueryInfo(dpy, DefaultRootWindow(dpy), &ssi)) {
    fprintf(stderr, "couldn't query screen saver info\n");
    return 1;
  }
  
  printf("%lu\n", ssi.idle);
  
  XCloseDisplay(dpy);
  return 0;
}

void usage(char *name)
{
  fprintf(stderr,
	  "Usage:\n"
	  "%s\n"
	  "That is, no command line arguments.  The user's idle time\n"
	  "in milliseconds is printed on stdout.\n",
	  name);
}
