/*

    xpuyopuyo - pnetint.h     Copyright(c) 1999,2000 Justin David Smith
    justins(at)chaos2.org     http://chaos2.org/
    
    Internal Header for network code
    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __pnetint_h_defined
#define __pnetint_h_defined


#include <xpuyopuyo.h>
#if USE_NETWORK /* allow network support */


/* Uncomment following line to enable network communication debugging */
/*#define P_NET_DEBUG_COMM*/
/*#define P_NET_DEBUG_COMM_VERBOSE*/


/* Uncomment following line to enable nonblocking calls on client sockets */
#define P_NET_NONBLOCKING_SOCKETS


#include <pnet.h>


#if !HAVE_SYS_TYPES_H
#   error "Requires <sys/types.h> for network support"
#endif
#include <sys/types.h>


#if !HAVE_SYS_SOCKET_H
#   error "Requires <sys/socket.h> for network support"
#endif
#include <sys/socket.h>


#if !HAVE_NETDB_H
#   error "Requires <netdb.h> for network support"
#endif
#include <netdb.h>


#if !HAVE_NETINET_IN_H
#   error "Requires <netinet/in.h> for network support"
#endif
#include <netinet/in.h>


#ifndef DEFAULT_PROTOCOL
#define DEFAULT_PROTOCOL   0
#endif /* DEFAULT_PROTOCOL definition */


#define P_NET_CONFIG_ID       0x6f43                  /* Configuration ID */
#define P_NET_CONFIG_SIZE     32 + P_PLAYER_NAME_SIZE /* Configuration size */

#define P_NET_SEND_ROCKS_ID   0x6b63      /* Rocks sent ID */
#define P_NET_BOARD_ID        0x3a64      /* GameBoard packet */
#define P_NET_SUBBOARD_ID     0x4262      /* Subboard packet */
#define P_NET_STATUS_ID       0x7461      /* Game statistics */
#define P_NET_STATUS_SIZE     (32 + (P_PLAYER_NUM_CLUMPS * 4)) /* Size of a status packet */
#define P_NET_I_LOST          0x7473      /* Transmit if I lost the game */
#define P_NET_END_ID          0x2164      /* End game */
#define P_NET_PAUSE_ID        0x2b75      /* Initiate pause */
#define P_NET_UNPAUSE_ID      0x2d75      /* End pause (unpause) */
#define P_NET_SEND_NEXT_ID    0x7478      /* Sending our next piece */
#define P_NET_SEND_NEXT_SIZE  8           /* Size of next piece */


/* Communication */
void pnet_shutdown(int *socket);
void pnet_shutdown_all(psocket *socket);
int pnet_ready_to_send(struct _pconfig *c, psocket *socket);
int pnet_ready_to_recv(struct _pconfig *c, psocket *socket);
int pnet_recv_null(struct _pconfig *c, psocket *socket, int size);
int pnet_send_header(struct _pconfig *c, psocket *socket, word type, word size);
int pnet_recv_header(struct _pconfig *c, psocket *socket, word *type, word *size);
int pnet_send_word(struct _pconfig *c, psocket *socket, word value);
int pnet_recv_word(struct _pconfig *c, psocket *socket, word *value);
int pnet_send_dword(struct _pconfig *c, psocket *socket, dword value);
int pnet_recv_dword(struct _pconfig *c, psocket *socket, dword *value);
int pnet_send_buffer(struct _pconfig *c, psocket *socket, const byte *value, int size);
int pnet_recv_buffer(struct _pconfig *c, psocket *socket, byte *value, int size);


/* Error messages */
void pnet_set_error(const char *function, const char *errormsg);


#endif /* Network? */


#endif /* __pnetint_h_defined */

